/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.base;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Predicate;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nullable;

public final class Predicates {
    public static <T> Predicate<T> not(Predicate<T> predicate) {
        Predicate<T> predicate2;
        return new NotPredicate<T>(predicate2);
    }

    public static <T> Predicate<T> equalTo(@Nullable T target) {
        T t;
        if (target == null) {
            target = ObjectPredicate.IS_NULL;
            return target;
        }
        return new IsEqualToPredicate(t, 0);
    }

    public static Predicate<Object> instanceOf(Class<?> clazz) {
        Class<?> clazz2;
        return new InstanceOfPredicate(clazz2, 0);
    }

    public static <T> Predicate<T> in(Collection<? extends T> target) {
        Collection<? extends T> collection;
        return new InPredicate(collection, 0);
    }

    static {
        Ascii.on$27f19060(',');
    }

    static final class InPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Collection<?> target;

        /*
         * WARNING - void declaration
         */
        private InPredicate(Collection<?> target) {
            void var1_1;
            this.target = (Collection)Ascii.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(@Nullable T t) {
            try {
                void var1_1;
                return this.target.contains(var1_1);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof InPredicate) {
                void var1_1;
                InPredicate that = (InPredicate)obj;
                return this.target.equals(var1_1.target);
            }
            return false;
        }

        public final int hashCode() {
            return this.target.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.target));
            return new StringBuilder(15 + string.length()).append("Predicates.in(").append(string).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ InPredicate(Collection x0, byte by) {
            this((Collection<?>)var1_1);
            void var1_1;
        }
    }

    static final class InstanceOfPredicate
    implements Predicate<Object>,
    Serializable {
        private final Class<?> clazz;

        /*
         * WARNING - void declaration
         */
        private InstanceOfPredicate(Class<?> clazz) {
            void var1_1;
            this.clazz = (Class)Ascii.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(@Nullable Object o) {
            void var1_1;
            return this.clazz.isInstance(var1_1);
        }

        public final int hashCode() {
            return this.clazz.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof InstanceOfPredicate) {
                void var1_1;
                InstanceOfPredicate that = (InstanceOfPredicate)obj;
                return this.clazz == var1_1.clazz;
            }
            return false;
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.clazz.getName()));
            return new StringBuilder(23 + string.length()).append("Predicates.instanceOf(").append(string).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ InstanceOfPredicate(Class x0, byte by) {
            this((Class<?>)var1_1);
            void var1_1;
        }
    }

    static final class IsEqualToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final T target;

        /*
         * WARNING - void declaration
         */
        private IsEqualToPredicate(T target) {
            void var1_1;
            this.target = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(T t) {
            void var1_1;
            return this.target.equals(var1_1);
        }

        public final int hashCode() {
            return this.target.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof IsEqualToPredicate) {
                void var1_1;
                IsEqualToPredicate that = (IsEqualToPredicate)obj;
                return this.target.equals(var1_1.target);
            }
            return false;
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.target));
            return new StringBuilder(20 + string.length()).append("Predicates.equalTo(").append(string).append(")").toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ IsEqualToPredicate(Object x0, byte by) {
            this(var1_1);
            void var1_1;
        }
    }

    static final class NotPredicate<T>
    implements Predicate<T>,
    Serializable {
        private Predicate<T> predicate;

        /*
         * WARNING - void declaration
         */
        NotPredicate(Predicate<T> predicate) {
            void var1_1;
            this.predicate = (Predicate)Ascii.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean apply(@Nullable T t) {
            void var1_1;
            return !this.predicate.apply(var1_1);
        }

        public final int hashCode() {
            return ~this.predicate.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object obj) {
            if (obj instanceof NotPredicate) {
                void var1_1;
                NotPredicate that = (NotPredicate)obj;
                return this.predicate.equals(var1_1.predicate);
            }
            return false;
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.predicate.toString()));
            return new StringBuilder(16 + string.length()).append("Predicates.not(").append(string).append(")").toString();
        }
    }

    static abstract class ObjectPredicate
    extends Enum<ObjectPredicate>
    implements Predicate<Object> {
        private static /* enum */ ObjectPredicate ALWAYS_TRUE = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return true;
            }

            public final String toString() {
                return "Predicates.alwaysTrue()";
            }
        };
        private static /* enum */ ObjectPredicate ALWAYS_FALSE = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return false;
            }

            public final String toString() {
                return "Predicates.alwaysFalse()";
            }
        };
        public static final /* enum */ ObjectPredicate IS_NULL = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return o == null;
            }

            public final String toString() {
                return "Predicates.isNull()";
            }
        };
        private static /* enum */ ObjectPredicate NOT_NULL = new ObjectPredicate(){

            @Override
            public final boolean apply(@Nullable Object o) {
                return o != null;
            }

            public final String toString() {
                return "Predicates.notNull()";
            }
        };

        private ObjectPredicate() {
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ObjectPredicate(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            ObjectPredicate[] objectPredicateArray = new ObjectPredicate[]{ALWAYS_TRUE, ALWAYS_FALSE, IS_NULL, NOT_NULL};
        }
    }
}

