/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.base;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;

public final class Stopwatch {
    private final Ticker ticker;
    private boolean isRunning;
    private long elapsedNanos;
    private long startTick;

    public static Stopwatch createUnstarted() {
        return new Stopwatch();
    }

    public static Stopwatch createStarted() {
        return new Stopwatch().start();
    }

    @Deprecated
    Stopwatch() {
        this(Ticker.systemTicker());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    private Stopwatch(Ticker ticker) {
        void var1_1;
        this.ticker = (Ticker)Ascii.checkNotNull(var1_1, "ticker");
    }

    public final Stopwatch start() {
        Ascii.checkState(!this.isRunning, "This stopwatch is already running.");
        this.isRunning = true;
        this.startTick = this.ticker.read();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Stopwatch stop() {
        void var1_1;
        long tick = this.ticker.read();
        Ascii.checkState(this.isRunning, "This stopwatch is already stopped.");
        this.isRunning = false;
        this.elapsedNanos += var1_1 - this.startTick;
        return this;
    }

    private long elapsedNanos() {
        if (this.isRunning) {
            return this.ticker.read() - this.startTick + this.elapsedNanos;
        }
        return this.elapsedNanos;
    }

    public final long elapsed(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        String string;
        void var1_1;
        long nanos = this.elapsedNanos();
        long l = nanos;
        TimeUnit unit = TimeUnit.DAYS.convert(l, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.DAYS : (TimeUnit.HOURS.convert(l, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.HOURS : (TimeUnit.MINUTES.convert(l, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.MINUTES : (TimeUnit.SECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.SECONDS : (TimeUnit.MILLISECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.MILLISECONDS : (TimeUnit.MICROSECONDS.convert(l, TimeUnit.NANOSECONDS) > 0L ? TimeUnit.MICROSECONDS : TimeUnit.NANOSECONDS)))));
        double value = (double)var1_1 / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        Object[] objectArray = new Object[2];
        objectArray[0] = value;
        TimeUnit timeUnit = unit;
        switch (timeUnit) {
            case NANOSECONDS: {
                string = "ns";
                break;
            }
            case MICROSECONDS: {
                string = "\u03bcs";
                break;
            }
            case MILLISECONDS: {
                string = "ms";
                break;
            }
            case SECONDS: {
                string = "s";
                break;
            }
            case MINUTES: {
                string = "min";
                break;
            }
            case HOURS: {
                string = "h";
                break;
            }
            case DAYS: {
                string = "d";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        objectArray[1] = string;
        return String.format("%.4g %s", objectArray);
    }
}

