/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.cache;

import com.github.igorsuhorukov.google.common.cache.AbstractCache;
import com.github.igorsuhorukov.google.common.cache.LoadingCache;
import com.github.igorsuhorukov.google.common.collect.ImmutableMap;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.util.concurrent.UncheckedExecutionException;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;

public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            void var1_2;
            throw new UncheckedExecutionException(var1_2.getCause());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        void var2_2;
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key : keys) {
            void var3_3;
            if (result.containsKey(key)) continue;
            result.put(key, this.get(var3_3));
        }
        return ImmutableMap.copyOf(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V apply(K key) {
        void var1_1;
        return this.getUnchecked(var1_1);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

