/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.cache;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Splitter;
import com.github.igorsuhorukov.google.common.cache.CacheBuilder;
import com.github.igorsuhorukov.google.common.cache.LocalCache;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public final class CacheBuilderSpec {
    private static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder$3fa3e7a2().put$3841f726("initialCapacity", new InitialCapacityParser()).put$3841f726("maximumSize", (InitialCapacityParser)((Object)new MaximumSizeParser())).put$3841f726("maximumWeight", (InitialCapacityParser)((Object)new MaximumWeightParser())).put$3841f726("concurrencyLevel", (InitialCapacityParser)((Object)new ConcurrencyLevelParser())).put$3841f726("weakKeys", (InitialCapacityParser)((Object)new KeyStrengthParser(LocalCache.Strength.WEAK))).put$3841f726("softValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.SOFT))).put$3841f726("weakValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.WEAK))).put$3841f726("recordStats", (InitialCapacityParser)((Object)new RecordStatsParser())).put$3841f726("expireAfterAccess", (InitialCapacityParser)((Object)new AccessDurationParser())).put$3841f726("expireAfterWrite", (InitialCapacityParser)((Object)new WriteDurationParser())).put$3841f726("refreshAfterWrite", (InitialCapacityParser)((Object)new RefreshDurationParser())).put$3841f726("refreshInterval", (InitialCapacityParser)((Object)new RefreshDurationParser())).build();
    Integer initialCapacity;
    Long maximumSize;
    Long maximumWeight;
    Integer concurrencyLevel;
    LocalCache.Strength keyStrength;
    LocalCache.Strength valueStrength;
    Boolean recordStats;
    long writeExpirationDuration;
    TimeUnit writeExpirationTimeUnit;
    long accessExpirationDuration;
    TimeUnit accessExpirationTimeUnit;
    long refreshDuration;
    TimeUnit refreshTimeUnit;
    private final String specification;

    /*
     * WARNING - void declaration
     */
    private CacheBuilderSpec(String specification) {
        void var1_1;
        this.specification = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static CacheBuilderSpec parse(String cacheBuilderSpecification) {
        void var1_1;
        CacheBuilderSpec spec = new CacheBuilderSpec(cacheBuilderSpecification);
        if (!cacheBuilderSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split(cacheBuilderSpecification)) {
                void var3_3;
                void var2_2;
                ImmutableList<String> keyAndValue = ImmutableList.copyOf(KEY_VALUE_SPLITTER.split(keyValuePair));
                Ascii.checkArgument(!keyAndValue.isEmpty(), "blank key-value pair");
                Ascii.checkArgument(keyAndValue.size() <= 2, "key-value pair %s with more than one equals sign", keyValuePair);
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = VALUE_PARSERS.get(key);
                Ascii.checkArgument(valueParser != null, "unknown key %s", key);
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, (String)var2_2, (String)var3_3);
            }
        }
        return var1_1;
    }

    public static CacheBuilderSpec disableCaching() {
        return CacheBuilderSpec.parse("maximumSize=0");
    }

    /*
     * WARNING - void declaration
     */
    final CacheBuilder<Object, Object> toCacheBuilder() {
        void var1_1;
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        if (this.initialCapacity != null) {
            builder.initialCapacity(this.initialCapacity);
        }
        if (this.maximumSize != null) {
            builder.maximumSize(this.maximumSize);
        }
        if (this.maximumWeight != null) {
            builder.maximumWeight(this.maximumWeight);
        }
        if (this.concurrencyLevel != null) {
            builder.concurrencyLevel(this.concurrencyLevel);
        }
        if (this.keyStrength != null) {
            switch (this.keyStrength) {
                case WEAK: {
                    builder.weakKeys();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.valueStrength != null) {
            switch (this.valueStrength) {
                case SOFT: {
                    builder.softValues();
                    break;
                }
                case WEAK: {
                    builder.weakValues();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.recordStats != null && this.recordStats.booleanValue()) {
            builder.recordStats();
        }
        if (this.writeExpirationTimeUnit != null) {
            builder.expireAfterWrite(this.writeExpirationDuration, this.writeExpirationTimeUnit);
        }
        if (this.accessExpirationTimeUnit != null) {
            builder.expireAfterAccess(this.accessExpirationDuration, this.accessExpirationTimeUnit);
        }
        if (this.refreshTimeUnit != null) {
            builder.refreshAfterWrite(this.refreshDuration, this.refreshTimeUnit);
        }
        return var1_1;
    }

    public final String toParsableString() {
        return this.specification;
    }

    public final String toString() {
        return Ascii.toStringHelper(this).addValue(this.toParsableString()).toString();
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.concurrencyLevel, this.keyStrength, this.valueStrength, this.recordStats, CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit)};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(@Nullable Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheBuilderSpec)) {
            return false;
        }
        CacheBuilderSpec that = (CacheBuilderSpec)obj;
        return Ascii.equal(this.initialCapacity, that.initialCapacity) && Ascii.equal(this.maximumSize, that.maximumSize) && Ascii.equal(this.maximumWeight, that.maximumWeight) && Ascii.equal(this.concurrencyLevel, that.concurrencyLevel) && Ascii.equal((Object)this.keyStrength, (Object)that.keyStrength) && Ascii.equal((Object)this.valueStrength, (Object)that.valueStrength) && Ascii.equal(this.recordStats, that.recordStats) && Ascii.equal(CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.writeExpirationDuration, that.writeExpirationTimeUnit)) && Ascii.equal(CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.accessExpirationDuration, that.accessExpirationTimeUnit)) && Ascii.equal(CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit), CacheBuilderSpec.durationInNanos(that.refreshDuration, var1_1.refreshTimeUnit));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Long durationInNanos(long duration, @Nullable TimeUnit unit) {
        long l;
        void var2_1;
        if (unit == null) {
            return null;
        }
        return var2_1.toNanos(l);
    }

    static final class RefreshDurationParser
    extends DurationParser {
        RefreshDurationParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            void var2_2;
            Ascii.checkArgument(spec.refreshTimeUnit == null, "refreshAfterWrite already set");
            spec.refreshDuration = var2_2;
            var1_1.refreshTimeUnit = unit;
        }
    }

    static final class WriteDurationParser
    extends DurationParser {
        WriteDurationParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            void var2_2;
            Ascii.checkArgument(spec.writeExpirationTimeUnit == null, "expireAfterWrite already set");
            spec.writeExpirationDuration = var2_2;
            var1_1.writeExpirationTimeUnit = unit;
        }
    }

    static final class AccessDurationParser
    extends DurationParser {
        AccessDurationParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            void var2_2;
            Ascii.checkArgument(spec.accessExpirationTimeUnit == null, "expireAfterAccess already set");
            spec.accessExpirationDuration = var2_2;
            var1_1.accessExpirationTimeUnit = unit;
        }
    }

    static abstract class DurationParser
    implements ValueParser {
        DurationParser() {
        }

        protected abstract void parseDuration(CacheBuilderSpec var1, long var2, TimeUnit var4);

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(CacheBuilderSpec spec, String key, String value) {
            Ascii.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                void var1_1;
                TimeUnit timeUnit;
                char c = value.charAt(value.length() - 1);
                switch (c) {
                    case 'd': {
                        timeUnit = TimeUnit.DAYS;
                        break;
                    }
                    case 'h': {
                        timeUnit = TimeUnit.HOURS;
                        break;
                    }
                    case 'm': {
                        timeUnit = TimeUnit.MINUTES;
                        break;
                    }
                    case 's': {
                        timeUnit = TimeUnit.SECONDS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("key %s invalid format.  was %s, must end with one of [dDhHmMsS]", key, value));
                    }
                }
                long duration = Long.parseLong(value.substring(0, value.length() - 1));
                this.parseDuration((CacheBuilderSpec)var1_1, duration, timeUnit);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                void var3_3;
                void var2_2;
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", var2_2, var3_3));
            }
        }
    }

    static final class RecordStatsParser
    implements ValueParser {
        RecordStatsParser() {
        }

        @Override
        public final void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            Ascii.checkArgument(value == null, "recordStats does not take values");
            Ascii.checkArgument(spec.recordStats == null, "recordStats already set");
            var1_1.recordStats = true;
        }
    }

    static final class ValueStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        /*
         * WARNING - void declaration
         */
        public ValueStrengthParser(LocalCache.Strength strength) {
            void var1_1;
            this.strength = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            void var2_2;
            Ascii.checkArgument(value == null, "key %s does not take values", key);
            Ascii.checkArgument(spec.valueStrength == null, "%s was already set to %s", new Object[]{var2_2, spec.valueStrength});
            var1_1.valueStrength = this.strength;
        }
    }

    static final class KeyStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        /*
         * WARNING - void declaration
         */
        public KeyStrengthParser(LocalCache.Strength strength) {
            void var1_1;
            this.strength = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            void var2_2;
            Ascii.checkArgument(value == null, "key %s does not take values", key);
            Ascii.checkArgument(spec.keyStrength == null, "%s was already set to %s", new Object[]{var2_2, spec.keyStrength});
            var1_1.keyStrength = this.strength;
        }
    }

    static final class ConcurrencyLevelParser
    extends IntegerParser {
        ConcurrencyLevelParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void parseInteger(CacheBuilderSpec spec, int value) {
            void var2_2;
            Ascii.checkArgument(spec.concurrencyLevel == null, "concurrency level was already set to ", spec.concurrencyLevel);
            var1_1.concurrencyLevel = (int)var2_2;
        }
    }

    static final class MaximumWeightParser
    extends LongParser {
        MaximumWeightParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void parseLong(CacheBuilderSpec spec, long value) {
            void var2_2;
            Ascii.checkArgument(spec.maximumWeight == null, "maximum weight was already set to ", spec.maximumWeight);
            Ascii.checkArgument(spec.maximumSize == null, "maximum size was already set to ", spec.maximumSize);
            var1_1.maximumWeight = (long)var2_2;
        }
    }

    static final class MaximumSizeParser
    extends LongParser {
        MaximumSizeParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void parseLong(CacheBuilderSpec spec, long value) {
            void var2_2;
            Ascii.checkArgument(spec.maximumSize == null, "maximum size was already set to ", spec.maximumSize);
            Ascii.checkArgument(spec.maximumWeight == null, "maximum weight was already set to ", spec.maximumWeight);
            var1_1.maximumSize = (long)var2_2;
        }
    }

    static final class InitialCapacityParser
    extends IntegerParser {
        InitialCapacityParser() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void parseInteger(CacheBuilderSpec spec, int value) {
            void var2_2;
            Ascii.checkArgument(spec.initialCapacity == null, "initial capacity was already set to ", spec.initialCapacity);
            var1_1.initialCapacity = (int)var2_2;
        }
    }

    static abstract class LongParser
    implements ValueParser {
        LongParser() {
        }

        protected abstract void parseLong(CacheBuilderSpec var1, long var2);

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(CacheBuilderSpec spec, String key, String value) {
            Ascii.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseLong(spec, Long.parseLong(value));
                return;
            }
            catch (NumberFormatException e) {
                void var1_2;
                void var3_4;
                void var2_3;
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", var2_3, var3_4), (Throwable)var1_2);
            }
        }
    }

    static abstract class IntegerParser
    implements ValueParser {
        IntegerParser() {
        }

        protected abstract void parseInteger(CacheBuilderSpec var1, int var2);

        /*
         * WARNING - void declaration
         */
        @Override
        public final void parse(CacheBuilderSpec spec, String key, String value) {
            Ascii.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseInteger(spec, Integer.parseInt(value));
                return;
            }
            catch (NumberFormatException e) {
                void var1_2;
                void var3_4;
                void var2_3;
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", var2_3, var3_4), (Throwable)var1_2);
            }
        }
    }

    static interface ValueParser {
        public void parse(CacheBuilderSpec var1, String var2, @Nullable String var3);
    }
}

