/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.cache;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.base.Supplier;
import com.github.igorsuhorukov.google.common.util.concurrent.Futures;
import com.github.igorsuhorukov.google.common.util.concurrent.ListenableFuture;
import com.github.igorsuhorukov.google.common.util.concurrent.ListenableFutureTask;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public abstract class CacheLoader<K, V> {
    protected CacheLoader() {
    }

    public abstract V load(K var1) throws Exception;

    /*
     * WARNING - void declaration
     */
    public ListenableFuture<V> reload(K key, V oldValue) throws Exception {
        void var1_1;
        void var2_2;
        Ascii.checkNotNull(key);
        Ascii.checkNotNull(var2_2);
        return Futures.immediateFuture(this.load(var1_1));
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
        throw new UnsupportedLoadingOperationException();
    }

    public static <K, V> CacheLoader<K, V> from(Function<K, V> function) {
        Function<K, V> function2;
        return new FunctionToCacheLoader<K, V>(function2);
    }

    public static <V> CacheLoader<Object, V> from(Supplier<V> supplier) {
        Supplier<V> supplier2;
        return new SupplierToCacheLoader<V>(supplier2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> CacheLoader<K, V> asyncReloading(CacheLoader<K, V> loader, Executor executor) {
        void var1_1;
        CacheLoader<K, V> cacheLoader;
        Ascii.checkNotNull(loader);
        Ascii.checkNotNull(executor);
        return new CacheLoader<K, V>((Executor)var1_1){
            private /* synthetic */ Executor val$executor;
            {
                this.val$executor = executor;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final V load(K key) throws Exception {
                void var1_1;
                return cacheLoader.load(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final ListenableFuture<V> reload(K key, V oldValue) throws Exception {
                void var1_1;
                void var2_2;
                ListenableFutureTask task = ListenableFutureTask.create(new Callable<V>(this, key, var2_2){
                    private /* synthetic */ Object val$key;
                    private /* synthetic */ Object val$oldValue;
                    private /* synthetic */ 1 this$0;
                    {
                        this.this$0 = var1_1;
                        this.val$key = object;
                        this.val$oldValue = object2;
                    }

                    @Override
                    public final V call() throws Exception {
                        return this.this$0.cacheLoader.reload(this.val$key, this.val$oldValue).get();
                    }
                });
                this.val$executor.execute(task);
                return var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Map<K, V> loadAll(Iterable<? extends K> keys) throws Exception {
                void var1_1;
                return cacheLoader.loadAll(var1_1);
            }
        };
    }

    public static final class InvalidCacheLoadException
    extends RuntimeException {
        /*
         * WARNING - void declaration
         */
        public InvalidCacheLoadException(String message) {
            super((String)var1_1);
            void var1_1;
        }
    }

    static final class UnsupportedLoadingOperationException
    extends UnsupportedOperationException {
        UnsupportedLoadingOperationException() {
        }
    }

    static final class SupplierToCacheLoader<V>
    extends CacheLoader<Object, V>
    implements Serializable {
        private final Supplier<V> computingSupplier;

        /*
         * WARNING - void declaration
         */
        public SupplierToCacheLoader(Supplier<V> computingSupplier) {
            void var1_1;
            this.computingSupplier = (Supplier)Ascii.checkNotNull(var1_1);
        }

        @Override
        public final V load(Object key) {
            Ascii.checkNotNull(key);
            return this.computingSupplier.get();
        }
    }

    static final class FunctionToCacheLoader<K, V>
    extends CacheLoader<K, V>
    implements Serializable {
        private final Function<K, V> computingFunction;

        /*
         * WARNING - void declaration
         */
        public FunctionToCacheLoader(Function<K, V> computingFunction) {
            void var1_1;
            this.computingFunction = (Function)Ascii.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V load(K key) {
            void var1_1;
            return this.computingFunction.apply(Ascii.checkNotNull(var1_1));
        }
    }
}

