/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.cache;

import com.github.igorsuhorukov.google.common.base.Ascii;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class CacheStats {
    private final long hitCount;
    private final long missCount;
    private final long loadSuccessCount;
    private final long loadExceptionCount;
    private final long totalLoadTime;
    private final long evictionCount;

    /*
     * WARNING - void declaration
     */
    public CacheStats(long hitCount, long missCount, long loadSuccessCount, long loadExceptionCount, long totalLoadTime, long evictionCount) {
        void var3_2;
        void var1_1;
        Ascii.checkArgument(hitCount >= 0L);
        Ascii.checkArgument(missCount >= 0L);
        Ascii.checkArgument(loadSuccessCount >= 0L);
        Ascii.checkArgument(loadExceptionCount >= 0L);
        Ascii.checkArgument(totalLoadTime >= 0L);
        Ascii.checkArgument(evictionCount >= 0L);
        this.hitCount = var1_1;
        this.missCount = var3_2;
        this.loadSuccessCount = loadSuccessCount;
        this.loadExceptionCount = loadExceptionCount;
        this.totalLoadTime = totalLoadTime;
        this.evictionCount = evictionCount;
    }

    public final long requestCount() {
        return this.hitCount + this.missCount;
    }

    public final long hitCount() {
        return this.hitCount;
    }

    /*
     * WARNING - void declaration
     */
    public final double hitRate() {
        void var1_1;
        long requestCount = this.requestCount();
        if (requestCount == 0L) {
            return 1.0;
        }
        return (double)this.hitCount / (double)var1_1;
    }

    public final long missCount() {
        return this.missCount;
    }

    /*
     * WARNING - void declaration
     */
    public final double missRate() {
        void var1_1;
        long requestCount = this.requestCount();
        if (requestCount == 0L) {
            return 0.0;
        }
        return (double)this.missCount / (double)var1_1;
    }

    public final long loadCount() {
        return this.loadSuccessCount + this.loadExceptionCount;
    }

    public final long loadSuccessCount() {
        return this.loadSuccessCount;
    }

    public final long loadExceptionCount() {
        return this.loadExceptionCount;
    }

    /*
     * WARNING - void declaration
     */
    public final double loadExceptionRate() {
        void var1_1;
        long totalLoadCount = this.loadSuccessCount + this.loadExceptionCount;
        if (totalLoadCount == 0L) {
            return 0.0;
        }
        return (double)this.loadExceptionCount / (double)var1_1;
    }

    public final long totalLoadTime() {
        return this.totalLoadTime;
    }

    /*
     * WARNING - void declaration
     */
    public final double averageLoadPenalty() {
        void var1_1;
        long totalLoadCount = this.loadSuccessCount + this.loadExceptionCount;
        if (totalLoadCount == 0L) {
            return 0.0;
        }
        return (double)this.totalLoadTime / (double)var1_1;
    }

    public final long evictionCount() {
        return this.evictionCount;
    }

    /*
     * WARNING - void declaration
     */
    public final CacheStats minus(CacheStats other) {
        void var1_1;
        return new CacheStats(Math.max(0L, this.hitCount - other.hitCount), Math.max(0L, this.missCount - other.missCount), Math.max(0L, this.loadSuccessCount - other.loadSuccessCount), Math.max(0L, this.loadExceptionCount - other.loadExceptionCount), Math.max(0L, this.totalLoadTime - other.totalLoadTime), Math.max(0L, this.evictionCount - var1_1.evictionCount));
    }

    /*
     * WARNING - void declaration
     */
    public final CacheStats plus(CacheStats other) {
        void var1_1;
        return new CacheStats(this.hitCount + other.hitCount, this.missCount + other.missCount, this.loadSuccessCount + other.loadSuccessCount, this.loadExceptionCount + other.loadExceptionCount, this.totalLoadTime + other.totalLoadTime, this.evictionCount + var1_1.evictionCount);
    }

    public final int hashCode() {
        Object[] objectArray = new Object[]{this.hitCount, this.missCount, this.loadSuccessCount, this.loadExceptionCount, this.totalLoadTime, this.evictionCount};
        return Arrays.hashCode(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(@Nullable Object object) {
        if (object instanceof CacheStats) {
            void var1_1;
            CacheStats other = (CacheStats)object;
            return this.hitCount == other.hitCount && this.missCount == other.missCount && this.loadSuccessCount == other.loadSuccessCount && this.loadExceptionCount == other.loadExceptionCount && this.totalLoadTime == other.totalLoadTime && this.evictionCount == var1_1.evictionCount;
        }
        return false;
    }

    public final String toString() {
        return Ascii.toStringHelper(this).add("hitCount", this.hitCount).add("missCount", this.missCount).add("loadSuccessCount", this.loadSuccessCount).add("loadExceptionCount", this.loadExceptionCount).add("totalLoadTime", this.totalLoadTime).add("evictionCount", this.evictionCount).toString();
    }
}

