/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.cache;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Equivalence;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.base.Stopwatch;
import com.github.igorsuhorukov.google.common.base.Ticker;
import com.github.igorsuhorukov.google.common.cache.AbstractCache;
import com.github.igorsuhorukov.google.common.cache.Cache;
import com.github.igorsuhorukov.google.common.cache.CacheBuilder;
import com.github.igorsuhorukov.google.common.cache.CacheLoader;
import com.github.igorsuhorukov.google.common.cache.CacheStats;
import com.github.igorsuhorukov.google.common.cache.LoadingCache;
import com.github.igorsuhorukov.google.common.cache.LocalCache;
import com.github.igorsuhorukov.google.common.cache.RemovalCause;
import com.github.igorsuhorukov.google.common.cache.RemovalListener;
import com.github.igorsuhorukov.google.common.cache.RemovalNotification;
import com.github.igorsuhorukov.google.common.cache.Weigher;
import com.github.igorsuhorukov.google.common.collect.AbstractSequentialIterator;
import com.github.igorsuhorukov.google.common.collect.ImmutableMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableSet;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.primitives.Ints;
import com.github.igorsuhorukov.google.common.util.concurrent.ExecutionError;
import com.github.igorsuhorukov.google.common.util.concurrent.ExecutionList;
import com.github.igorsuhorukov.google.common.util.concurrent.Futures;
import com.github.igorsuhorukov.google.common.util.concurrent.ListenableFuture;
import com.github.igorsuhorukov.google.common.util.concurrent.SettableFuture;
import com.github.igorsuhorukov.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class LocalCache<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final Logger logger = Logger.getLogger(LocalCache.class.getName());
    private int segmentMask;
    private int segmentShift;
    final Segment<K, V>[] segments;
    private int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final Equivalence<Object> valueEquivalence;
    private Strength keyStrength;
    final Strength valueStrength;
    private long maxWeight;
    final Weigher<K, V> weigher;
    private long expireAfterAccessNanos;
    private long expireAfterWriteNanos;
    final long refreshNanos;
    final Queue<RemovalNotification<K, V>> removalNotificationQueue;
    final RemovalListener<K, V> removalListener;
    final Ticker ticker;
    final EntryFactory entryFactory;
    final AbstractCache.StatsCounter globalStatsCounter;
    @Nullable
    final CacheLoader<? super K, V> defaultLoader;
    static final ValueReference<Object, Object> UNSET = new ValueReference<Object, Object>(){

        @Override
        public final Object get() {
            return null;
        }

        @Override
        public final int getWeight() {
            return 0;
        }

        @Override
        public final ReferenceEntry<Object, Object> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<Object, Object> copyFor(ReferenceQueue<Object> queue, @Nullable Object value, ReferenceEntry<Object, Object> entry) {
            return this;
        }

        @Override
        public final boolean isLoading() {
            return false;
        }

        @Override
        public final boolean isActive() {
            return false;
        }

        @Override
        public final Object waitForValue() {
            return null;
        }

        @Override
        public final void notifyNewValue(Object newValue) {
        }
    };
    static final Queue<? extends Object> DISCARDING_QUEUE = new AbstractQueue<Object>(){

        @Override
        public final boolean offer(Object o) {
            return true;
        }

        @Override
        public final Object peek() {
            return null;
        }

        @Override
        public final Object poll() {
            return null;
        }

        @Override
        public final int size() {
            return 0;
        }

        @Override
        public final Iterator<Object> iterator() {
            return ImmutableSet.of().iterator();
        }
    };
    private Set<K> keySet;
    private Collection<V> values;
    private Set<Map.Entry<K, V>> entrySet;

    LocalCache(CacheBuilder<? super K, ? super V> builder, @Nullable CacheLoader<? super K, V> loader) {
        int segmentSize;
        int segmentCount;
        LocalCache localCache;
        this.concurrencyLevel = Math.min(builder.getConcurrencyLevel(), 65536);
        this.keyStrength = builder.getKeyStrength();
        this.valueStrength = builder.getValueStrength();
        this.keyEquivalence = builder.getKeyEquivalence();
        this.valueEquivalence = builder.getValueEquivalence();
        this.maxWeight = builder.getMaximumWeight();
        this.weigher = builder.getWeigher();
        this.expireAfterAccessNanos = builder.getExpireAfterAccessNanos();
        this.expireAfterWriteNanos = builder.getExpireAfterWriteNanos();
        this.refreshNanos = builder.getRefreshNanos();
        this.removalListener = builder.getRemovalListener();
        this.removalNotificationQueue = this.removalListener == CacheBuilder.NullListener.INSTANCE ? DISCARDING_QUEUE : new ConcurrentLinkedQueue();
        LocalCache localCache2 = this;
        this.ticker = builder.getTicker(localCache2.recordsWrite() || (localCache = localCache2).expiresAfterAccess());
        localCache2 = this;
        boolean bl = localCache2.usesAccessQueue() || (localCache = localCache2).expiresAfterAccess();
        localCache = localCache2 = this;
        this.entryFactory = EntryFactory.getFactory(this.keyStrength, bl, localCache2.expiresAfterWrite() || localCache2.recordsWrite());
        this.globalStatsCounter = builder.getStatsCounterSupplier().get();
        this.defaultLoader = loader;
        int initialCapacity = Math.min(builder.getInitialCapacity(), 0x40000000);
        if (this.evictsBySize() && !this.customWeigher()) {
            initialCapacity = Math.min(initialCapacity, (int)this.maxWeight);
        }
        int segmentShift = 0;
        for (segmentCount = 1; !(segmentCount >= this.concurrencyLevel || this.evictsBySize() && (long)(segmentCount * 20) > this.maxWeight); segmentCount <<= 1) {
            ++segmentShift;
        }
        this.segmentShift = 32 - segmentShift;
        this.segmentMask = segmentCount - 1;
        segmentShift = segmentCount;
        this.segments = new Segment[segmentShift];
        int segmentCapacity = initialCapacity / segmentCount;
        if (segmentCapacity * segmentCount < initialCapacity) {
            ++segmentCapacity;
        }
        for (segmentSize = 1; segmentSize < segmentCapacity; segmentSize <<= 1) {
        }
        if (this.evictsBySize()) {
            long maxSegmentWeight = this.maxWeight / (long)segmentCount + 1L;
            long remainder = this.maxWeight % (long)segmentCount;
            for (int i = 0; i < this.segments.length; ++i) {
                if ((long)i == remainder) {
                    --maxSegmentWeight;
                }
                this.segments[i] = this.createSegment(segmentSize, maxSegmentWeight, builder.getStatsCounterSupplier().get());
            }
            return;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = this.createSegment(segmentSize, -1L, builder.getStatsCounterSupplier().get());
        }
    }

    final boolean evictsBySize() {
        return this.maxWeight >= 0L;
    }

    final boolean customWeigher() {
        return this.weigher != CacheBuilder.OneWeigher.INSTANCE;
    }

    final boolean expiresAfterWrite() {
        return this.expireAfterWriteNanos > 0L;
    }

    final boolean expiresAfterAccess() {
        return this.expireAfterAccessNanos > 0L;
    }

    final boolean refreshes() {
        return this.refreshNanos > 0L;
    }

    final boolean usesAccessQueue() {
        return this.expiresAfterAccess() || this.evictsBySize();
    }

    final boolean recordsWrite() {
        return this.expiresAfterWrite() || this.refreshes();
    }

    final boolean usesKeyReferences() {
        return this.keyStrength != Strength.STRONG;
    }

    final boolean usesValueReferences() {
        return this.valueStrength != Strength.STRONG;
    }

    static <K, V> ValueReference<K, V> unset() {
        return UNSET;
    }

    static <K, V> ReferenceEntry<K, V> nullEntry() {
        return NullEntry.INSTANCE;
    }

    static <E> Queue<E> discardingQueue() {
        return DISCARDING_QUEUE;
    }

    /*
     * WARNING - void declaration
     */
    final int hash(@Nullable Object key) {
        void var1_1;
        int n = this.keyEquivalence.hash(var1_1);
        int n2 = n;
        n2 = n;
        n2 = n + (n2 << 15 ^ 0xFFFFCD7D);
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += (n2 << 2) + (n2 << 14);
        return n2 ^ n2 >>> 16;
    }

    /*
     * WARNING - void declaration
     */
    final Segment<K, V> segmentFor(int hash) {
        void var1_1;
        return this.segments[var1_1 >>> this.segmentShift & this.segmentMask];
    }

    /*
     * WARNING - void declaration
     */
    private Segment<K, V> createSegment(int initialCapacity, long maxSegmentWeight, AbstractCache.StatsCounter statsCounter) {
        void var2_2;
        void var1_1;
        return new Segment(this, (int)var1_1, (long)var2_2, statsCounter);
    }

    /*
     * WARNING - void declaration
     */
    final boolean isExpired(ReferenceEntry<K, V> entry, long now) {
        void var1_1;
        void var2_2;
        Ascii.checkNotNull(entry);
        if (this.expiresAfterAccess() && now - entry.getAccessTime() >= this.expireAfterAccessNanos) {
            return true;
        }
        return this.expiresAfterWrite() && var2_2 - var1_1.getWriteTime() >= this.expireAfterWriteNanos;
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void connectAccessOrder(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        ReferenceEntry<K, V> referenceEntry;
        void var1_1;
        previous.setNextInAccessQueue(next);
        var1_1.setPreviousInAccessQueue(referenceEntry);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void nullifyAccessOrder(ReferenceEntry<K, V> nulled) {
        void var1_1;
        ReferenceEntry<K, V> referenceEntry;
        NullEntry nullEntry = NullEntry.INSTANCE;
        nulled.setNextInAccessQueue(nullEntry);
        referenceEntry.setPreviousInAccessQueue((ReferenceEntry<K, V>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void connectWriteOrder(ReferenceEntry<K, V> previous, ReferenceEntry<K, V> next) {
        ReferenceEntry<K, V> referenceEntry;
        void var1_1;
        previous.setNextInWriteQueue(next);
        var1_1.setPreviousInWriteQueue(referenceEntry);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void nullifyWriteOrder(ReferenceEntry<K, V> nulled) {
        void var1_1;
        ReferenceEntry<K, V> referenceEntry;
        NullEntry nullEntry = NullEntry.INSTANCE;
        nulled.setNextInWriteQueue(nullEntry);
        referenceEntry.setPreviousInWriteQueue((ReferenceEntry<K, V>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEmpty() {
        int i;
        long sum = 0L;
        Segment<K, V>[] segments = this.segments;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            sum += (long)segments[i].modCount;
        }
        if (sum != 0L) {
            void var1_1;
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count != 0) {
                    return false;
                }
                sum -= (long)segments[i].modCount;
            }
            if (var1_1 != 0L) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    final long longSize() {
        void var2_2;
        Segment<K, V>[] segments = this.segments;
        long sum = 0L;
        for (int i = 0; i < segments.length; ++i) {
            sum += (long)segments[i].count;
        }
        return (long)var2_2;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.longSize());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public V get(@Nullable Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).get(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final V get(K key, CacheLoader<? super K, V> loader) throws ExecutionException {
        void var2_2;
        void var3_3;
        void var1_1;
        int hash = this.hash(Ascii.checkNotNull(key));
        return this.segmentFor(hash).get(var1_1, (int)var3_3, (CacheLoader<void, V>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    final ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        int hits = 0;
        int misses = 0;
        LinkedHashMap<Object, V> result = Maps.newLinkedHashMap();
        LinkedHashSet<K> keysToLoad = new LinkedHashSet<K>();
        for (K key : keys) {
            V value = this.get(key);
            if (result.containsKey(key)) continue;
            result.put(key, value);
            if (value == null) {
                ++misses;
                keysToLoad.add(key);
                continue;
            }
            ++hits;
        }
        try {
            if (!keysToLoad.isEmpty()) {
                try {
                    Object newEntries = this.loadAll(keysToLoad, this.defaultLoader);
                    for (Object key : keysToLoad) {
                        V value = newEntries.get(key);
                        if (value == null) {
                            newEntries = String.valueOf(String.valueOf(key));
                            throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(37 + ((String)newEntries).length()).append("loadAll failed to return a value for ").append((String)newEntries).toString());
                        }
                        result.put(key, value);
                    }
                }
                catch (CacheLoader.UnsupportedLoadingOperationException unsupportedLoadingOperationException) {
                    for (Object key : keysToLoad) {
                        --misses;
                        result.put(key, this.get(key, this.defaultLoader));
                    }
                }
            }
            ImmutableMap immutableMap = ImmutableMap.copyOf(result);
            this.globalStatsCounter.recordHits(hits);
            this.globalStatsCounter.recordMisses(misses);
            return immutableMap;
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            this.globalStatsCounter.recordHits((int)var2_3);
            this.globalStatsCounter.recordMisses((int)var3_4);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private Map<K, V> loadAll(Set<? extends K> keys, CacheLoader<? super K, V> loader) throws ExecutionException {
        void var1_1;
        void var3_3;
        Map<K, V> result;
        Ascii.checkNotNull(loader);
        Ascii.checkNotNull(keys);
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean success = false;
        try {
            try {
                Map<K, V> map;
                result = map = loader.loadAll(keys);
            }
            catch (CacheLoader.UnsupportedLoadingOperationException e) {
                success = true;
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ExecutionException(e);
            }
            catch (RuntimeException e) {
                throw new UncheckedExecutionException(e);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            catch (Error e) {
                throw new ExecutionError(e);
            }
        }
        catch (Throwable throwable) {
            if (!success) {
                this.globalStatsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
            }
            throw throwable;
        }
        if (result == null) {
            this.globalStatsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
            String e = String.valueOf(String.valueOf(loader));
            throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(31 + e.length()).append(e).append(" returned null map from loadAll").toString());
        }
        stopwatch.stop();
        boolean nullsPresent = false;
        for (Map.Entry<K, V> entry : result.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null || value == null) {
                nullsPresent = true;
                continue;
            }
            this.put(key, value);
        }
        if (nullsPresent) {
            void var2_2;
            this.globalStatsCounter.recordLoadException(stopwatch.elapsed(TimeUnit.NANOSECONDS));
            String string = String.valueOf(String.valueOf(var2_2));
            throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(42 + string.length()).append(string).append(" returned null keys or values from loadAll").toString());
        }
        this.globalStatsCounter.recordLoadSuccess(var3_3.elapsed(TimeUnit.NANOSECONDS));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(@Nullable Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(var1_1, (int)var2_2);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        long now = this.ticker.read();
        Segment<K, V>[] segments = this.segments;
        long last = -1L;
        for (int i = 0; i < 3; ++i) {
            long sum = 0L;
            Segment<K, V>[] arr$ = segments;
            int len$ = segments.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Segment segment = arr$[i$];
                int cfr_ignored_0 = segment.count;
                AtomicReferenceArray table = segment.table;
                for (int j = 0; j < table.length(); ++j) {
                    for (ReferenceEntry e = table.get(j); e != null; e = e.getNext()) {
                        V v = segment.getLiveValue(e, now);
                        if (v == null || !this.valueEquivalence.equivalent(value, v)) continue;
                        return true;
                    }
                }
                sum += (long)segment.modCount;
            }
            if (sum == last) break;
            last = sum;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Ascii.checkNotNull(key);
        Ascii.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Ascii.checkNotNull(key);
        Ascii.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            void var2_2;
            this.put(e.getKey(), var2_2.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(@Nullable Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(@Nullable Object key, @Nullable Object value) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (key == null || value == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var3_3, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean replace(K key, @Nullable V oldValue, V newValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        Ascii.checkNotNull(key);
        Ascii.checkNotNull(newValue);
        if (oldValue == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, hash, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V replace(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Ascii.checkNotNull(key);
        Ascii.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, (int)var3_3, var2_2);
    }

    @Override
    public void clear() {
        Segment<K, V>[] arr$ = this.segments;
        int len$ = this.segments.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Segment segment = arr$[i$];
            Segment segment2 = segment;
            segment2 = segment;
            if (segment.count == 0) continue;
            segment2.lock();
            try {
                int n;
                Serializable serializable = segment2.table;
                for (n = 0; n < serializable.length(); ++n) {
                    for (ReferenceEntry referenceEntry = serializable.get(n); referenceEntry != null; referenceEntry = referenceEntry.getNext()) {
                        if (!referenceEntry.getValueReference().isActive()) continue;
                        segment2.enqueueNotification(referenceEntry, RemovalCause.EXPLICIT);
                    }
                }
                for (n = 0; n < serializable.length(); ++n) {
                    serializable.set(n, null);
                }
                serializable = segment2;
                if (((Segment)serializable).map.usesKeyReferences()) {
                    Serializable serializable2 = serializable;
                    while (((Segment)serializable2).keyReferenceQueue.poll() != null) {
                    }
                }
                if (((Segment)serializable).map.usesValueReferences()) {
                    Serializable serializable3 = serializable;
                    while (((Segment)serializable3).valueReferenceQueue.poll() != null) {
                    }
                }
                segment2.writeQueue.clear();
                segment2.accessQueue.clear();
                segment2.readCount.set(0);
                ++segment2.modCount;
                segment2.count = 0;
                continue;
            }
            finally {
                segment2.unlock();
                segment2.runUnlockedCleanup();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        if (ks != null) {
            void var1_1;
            return var1_1;
        }
        this.keySet = new KeySet(this, this);
        return this.keySet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> values() {
        Collection<V> vs = this.values;
        if (vs != null) {
            void var1_1;
            return var1_1;
        }
        this.values = new Values(this, this);
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            void var1_1;
            return var1_1;
        }
        this.entrySet = new EntrySet(this, this);
        return this.entrySet;
    }

    static final class LocalLoadingCache<K, V>
    extends LocalManualCache<K, V>
    implements LoadingCache<K, V> {
        /*
         * WARNING - void declaration
         */
        LocalLoadingCache(CacheBuilder<? super K, ? super V> builder, CacheLoader<? super K, V> loader) {
            super(new LocalCache(var1_1, (CacheLoader)Ascii.checkNotNull(var2_2)), (byte)0);
            void var2_2;
            void var1_1;
        }

        @Override
        public final V get(K key) throws ExecutionException {
            LocalCache localCache;
            void var2_2 = localCache;
            localCache = this.localCache;
            return localCache.get(var2_2, localCache.defaultLoader);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V getUnchecked(K key) {
            try {
                return this.get(key);
            }
            catch (ExecutionException e) {
                void var1_2;
                throw new UncheckedExecutionException(var1_2.getCause());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
            void var1_1;
            return this.localCache.getAll(var1_1);
        }

        @Override
        public final void refresh(K key) {
            LocalCache localCache;
            void var2_2 = localCache;
            localCache = this.localCache;
            int n = localCache.hash(Ascii.checkNotNull(var2_2));
            localCache.segmentFor(n).refresh(var2_2, n, localCache.defaultLoader, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V apply(K key) {
            void var1_1;
            return this.getUnchecked(var1_1);
        }
    }

    static class LocalManualCache<K, V>
    implements Cache<K, V>,
    Serializable {
        final LocalCache<K, V> localCache;

        /*
         * WARNING - void declaration
         */
        LocalManualCache(CacheBuilder<? super K, ? super V> builder) {
            this(new LocalCache(var1_1, null));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private LocalManualCache(LocalCache<K, V> localCache) {
            void var1_1;
            this.localCache = var1_1;
        }

        @Override
        @Nullable
        public V getIfPresent(Object key) {
            LocalCache<K, V> localCache;
            V v = localCache;
            localCache = this.localCache;
            int n = localCache.hash(Ascii.checkNotNull(v));
            if ((v = localCache.segmentFor(n).get(v, n)) == null) {
                localCache.globalStatsCounter.recordMisses(1);
            } else {
                localCache.globalStatsCounter.recordHits(1);
            }
            return v;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
            void var2_2;
            void var1_1;
            Ascii.checkNotNull(valueLoader);
            return this.localCache.get(var1_1, new CacheLoader<Object, V>(this, (Callable)var2_2){
                private /* synthetic */ Callable val$valueLoader;
                {
                    this.val$valueLoader = callable;
                }

                @Override
                public final V load(Object key) throws Exception {
                    return this.val$valueLoader.call();
                }
            });
        }

        @Override
        public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
            LocalCache<K, V> localCache;
            Iterator iterator = localCache;
            localCache = this.localCache;
            int n = 0;
            int n2 = 0;
            LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                V v = localCache.get(t);
                if (v == null) {
                    ++n2;
                    continue;
                }
                linkedHashMap.put(t, v);
                ++n;
            }
            localCache.globalStatsCounter.recordHits(n);
            localCache.globalStatsCounter.recordMisses(n2);
            return ImmutableMap.copyOf(linkedHashMap);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void put(K key, V value) {
            void var2_2;
            void var1_1;
            this.localCache.put(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            void var1_1;
            this.localCache.putAll((Map<K, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void invalidate(Object key) {
            void var1_1;
            Ascii.checkNotNull(key);
            this.localCache.remove(var1_1);
        }

        @Override
        public void invalidateAll(Iterable<?> keys) {
            LocalCache<K, V> localCache;
            Iterator iterator = localCache;
            localCache = this.localCache;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                localCache.remove(t);
            }
        }

        @Override
        public void invalidateAll() {
            this.localCache.clear();
        }

        @Override
        public long size() {
            return this.localCache.longSize();
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            return this.localCache;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public CacheStats stats() {
            void var1_1;
            AbstractCache.SimpleStatsCounter aggregator = new AbstractCache.SimpleStatsCounter();
            aggregator.incrementBy(this.localCache.globalStatsCounter);
            Segment<K, V>[] arr$ = this.localCache.segments;
            int len$ = this.localCache.segments.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Segment segment = arr$[i$];
                aggregator.incrementBy(segment.statsCounter);
            }
            return var1_1.snapshot();
        }

        @Override
        public void cleanUp() {
            Segment<K, V>[] segmentArray = this.localCache;
            segmentArray = this.localCache.segments;
            int n = this.localCache.segments.length;
            for (int i = 0; i < n; ++i) {
                Segment segment = segmentArray[i];
                segment.cleanUp();
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ LocalManualCache(LocalCache x0, byte by) {
            this((LocalCache<K, V>)var1_1);
            void var1_1;
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.cache.LocalCache$com.google.common.cache.LocalCache$AbstractCacheSet<java.util.Map$Entry<K, V>>, not com.github.igorsuhorukov.google.common.cache.LocalCache$AbstractCacheSet - discarding signature.
     */
    final class EntrySet
    extends AbstractCacheSet {
        private /* synthetic */ LocalCache this$0;

        /*
         * WARNING - void declaration
         */
        EntrySet(LocalCache localCache, ConcurrentMap<?, ?> map) {
            void var2_2;
            this.this$0 = localCache;
            super(localCache, (ConcurrentMap<?, ?>)var2_2);
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.this$0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var2_2;
            void var1_1;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.this$0.get(key);
            return v != null && this.this$0.valueEquivalence.equivalent(var1_1.getValue(), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            void var2_2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && this.this$0.remove(var2_2, var1_1.getValue());
        }
    }

    final class Values
    extends AbstractCollection<V> {
        private final ConcurrentMap<?, ?> map;
        private /* synthetic */ LocalCache this$0;

        /*
         * WARNING - void declaration
         */
        Values(LocalCache localCache, ConcurrentMap<?, ?> map) {
            void var2_2;
            this.this$0 = localCache;
            this.map = var2_2;
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.this$0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.map.containsValue(var1_1);
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.cache.LocalCache$com.google.common.cache.LocalCache$AbstractCacheSet<K>, not com.github.igorsuhorukov.google.common.cache.LocalCache$AbstractCacheSet - discarding signature.
     */
    final class KeySet
    extends AbstractCacheSet {
        private /* synthetic */ LocalCache this$0;

        /*
         * WARNING - void declaration
         */
        KeySet(LocalCache localCache, ConcurrentMap<?, ?> map) {
            void var2_2;
            this.this$0 = localCache;
            super(localCache, (ConcurrentMap<?, ?>)var2_2);
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(this.this$0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.map.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            return this.map.remove(var1_1) != null;
        }
    }

    abstract class AbstractCacheSet<T>
    extends AbstractSet<T> {
        final ConcurrentMap<?, ?> map;

        /*
         * WARNING - void declaration
         */
        AbstractCacheSet(LocalCache localCache, ConcurrentMap<?, ?> map) {
            void var2_2;
            this.map = var2_2;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.cache.LocalCache$com.google.common.cache.LocalCache$HashIterator<java.util.Map$Entry<K, V>>, not com.github.igorsuhorukov.google.common.cache.LocalCache$HashIterator - discarding signature.
     */
    final class EntryIterator
    extends HashIterator {
        EntryIterator(LocalCache localCache) {
            super(localCache);
        }
    }

    final class WriteThroughEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        /*
         * WARNING - void declaration
         */
        WriteThroughEntry(LocalCache localCache, K key, V value) {
            void var3_3;
            void var2_2;
            this.key = var2_2;
            this.value = var3_3;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                void var1_1;
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(var1_1.getValue());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public final V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        public final String toString() {
            String string = String.valueOf(String.valueOf(this.getKey()));
            String string2 = String.valueOf(String.valueOf(this.getValue()));
            return new StringBuilder(1 + string.length() + string2.length()).append(string).append("=").append(string2).toString();
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.cache.LocalCache$com.google.common.cache.LocalCache$HashIterator<V>, not com.github.igorsuhorukov.google.common.cache.LocalCache$HashIterator - discarding signature.
     */
    final class ValueIterator
    extends HashIterator {
        ValueIterator(LocalCache localCache) {
            super(localCache);
        }

        @Override
        public final V next() {
            return this.nextEntry().getValue();
        }
    }

    /*
     * Signature claims super is com.github.igorsuhorukov.google.common.cache.LocalCache$com.google.common.cache.LocalCache$HashIterator<K>, not com.github.igorsuhorukov.google.common.cache.LocalCache$HashIterator - discarding signature.
     */
    final class KeyIterator
    extends HashIterator {
        KeyIterator(LocalCache localCache) {
            super(localCache);
        }

        @Override
        public final K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        private int nextSegmentIndex;
        private int nextTableIndex;
        private Segment<K, V> currentSegment;
        private AtomicReferenceArray<ReferenceEntry<K, V>> currentTable;
        private ReferenceEntry<K, V> nextEntry;
        private LocalCache.LocalCache.WriteThroughEntry nextExternal;
        private LocalCache.LocalCache.WriteThroughEntry lastReturned;
        private /* synthetic */ LocalCache this$0;

        HashIterator(LocalCache localCache) {
            this.this$0 = localCache;
            this.nextSegmentIndex = localCache.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        private void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                this.currentSegment = this.this$0.segments[this.nextSegmentIndex--];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        private boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    if (this.advanceTo(this.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        private boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable.get(this.nextTableIndex--)) == null || !this.advanceTo(this.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean advanceTo(ReferenceEntry<K, V> entry) {
            try {
                Object value;
                Object v;
                void var2_3;
                long now = this.this$0.ticker.read();
                Object key = entry.getKey();
                void var5_5 = var2_3;
                ReferenceEntry referenceEntry = entry;
                entry = this.this$0;
                if ((referenceEntry.getKey() == null ? null : ((v = referenceEntry.getValueReference().get()) == null ? null : (value = ((LocalCache)entry).isExpired(referenceEntry, (long)var5_5) ? null : v))) != null) {
                    void var1_1;
                    this.nextExternal = new WriteThroughEntry(this.this$0, key, var1_1);
                    return true;
                }
                return false;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextExternal != null;
        }

        final LocalCache.WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            Ascii.checkState(this.lastReturned != null);
            this.this$0.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class AccessQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(this){
            private ReferenceEntry<K, V> nextAccess = this;
            private ReferenceEntry<K, V> previousAccess = this;

            @Override
            public final long getAccessTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public final void setAccessTime(long time) {
            }

            @Override
            public final ReferenceEntry<K, V> getNextInAccessQueue() {
                return this.nextAccess;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
                void var1_1;
                this.nextAccess = var1_1;
            }

            @Override
            public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
                return this.previousAccess;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
                void var1_1;
                this.previousAccess = var1_1;
            }
        };

        AccessQueue() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        private ReferenceEntry<K, V> peek() {
            void var1_1;
            ReferenceEntry<K, V> next = this.head.getNextInAccessQueue();
            if (next == this.head) {
                return null;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var3_3;
            void var1_1;
            void var2_2;
            ReferenceEntry e = (ReferenceEntry)o;
            ReferenceEntry previous = e.getPreviousInAccessQueue();
            ReferenceEntry next = e.getNextInAccessQueue();
            LocalCache.connectAccessOrder(var2_2, next);
            LocalCache.nullifyAccessOrder(var1_1);
            return var3_3 != NullEntry.INSTANCE;
        }

        @Override
        public final boolean contains(Object o) {
            ReferenceEntry referenceEntry = (ReferenceEntry)o;
            return referenceEntry.getNextInAccessQueue() != NullEntry.INSTANCE;
        }

        @Override
        public final boolean isEmpty() {
            return this.head.getNextInAccessQueue() == this.head;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int size() {
            void var1_1;
            int size = 0;
            for (ReferenceEntry<K, V> e = this.head.getNextInAccessQueue(); e != this.head; e = e.getNextInAccessQueue()) {
                ++size;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void clear() {
            ReferenceEntry<K, V> e = this.head.getNextInAccessQueue();
            while (e != this.head) {
                void var2_2;
                ReferenceEntry<K, V> next = e.getNextInAccessQueue();
                LocalCache.nullifyAccessOrder(e);
                e = var2_2;
            }
            this.head.setNextInAccessQueue(this.head);
            this.head.setPreviousInAccessQueue(this.head);
        }

        @Override
        public final Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>(this, (ReferenceEntry)this.peek()){
                private /* synthetic */ AccessQueue this$0;
                {
                    void var2_2;
                    this.this$0 = accessQueue;
                    super(var2_2);
                }
            };
        }
    }

    static final class WriteQueue<K, V>
    extends AbstractQueue<ReferenceEntry<K, V>> {
        final ReferenceEntry<K, V> head = new AbstractReferenceEntry<K, V>(this){
            private ReferenceEntry<K, V> nextWrite = this;
            private ReferenceEntry<K, V> previousWrite = this;

            @Override
            public final long getWriteTime() {
                return Long.MAX_VALUE;
            }

            @Override
            public final void setWriteTime(long time) {
            }

            @Override
            public final ReferenceEntry<K, V> getNextInWriteQueue() {
                return this.nextWrite;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
                void var1_1;
                this.nextWrite = var1_1;
            }

            @Override
            public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
                return this.previousWrite;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
                void var1_1;
                this.previousWrite = var1_1;
            }
        };

        WriteQueue() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        private ReferenceEntry<K, V> peek() {
            void var1_1;
            ReferenceEntry<K, V> next = this.head.getNextInWriteQueue();
            if (next == this.head) {
                return null;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var3_3;
            void var1_1;
            void var2_2;
            ReferenceEntry e = (ReferenceEntry)o;
            ReferenceEntry previous = e.getPreviousInWriteQueue();
            ReferenceEntry next = e.getNextInWriteQueue();
            LocalCache.connectWriteOrder(var2_2, next);
            LocalCache.nullifyWriteOrder(var1_1);
            return var3_3 != NullEntry.INSTANCE;
        }

        @Override
        public final boolean contains(Object o) {
            ReferenceEntry referenceEntry = (ReferenceEntry)o;
            return referenceEntry.getNextInWriteQueue() != NullEntry.INSTANCE;
        }

        @Override
        public final boolean isEmpty() {
            return this.head.getNextInWriteQueue() == this.head;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int size() {
            void var1_1;
            int size = 0;
            for (ReferenceEntry<K, V> e = this.head.getNextInWriteQueue(); e != this.head; e = e.getNextInWriteQueue()) {
                ++size;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void clear() {
            ReferenceEntry<K, V> e = this.head.getNextInWriteQueue();
            while (e != this.head) {
                void var2_2;
                ReferenceEntry<K, V> next = e.getNextInWriteQueue();
                LocalCache.nullifyWriteOrder(e);
                e = var2_2;
            }
            this.head.setNextInWriteQueue(this.head);
            this.head.setPreviousInWriteQueue(this.head);
        }

        @Override
        public final Iterator<ReferenceEntry<K, V>> iterator() {
            return new AbstractSequentialIterator<ReferenceEntry<K, V>>(this, (ReferenceEntry)this.peek()){
                private /* synthetic */ WriteQueue this$0;
                {
                    void var2_2;
                    this.this$0 = writeQueue;
                    super(var2_2);
                }
            };
        }
    }

    static final class LoadingValueReference<K, V>
    implements ValueReference<K, V> {
        volatile ValueReference<K, V> oldValue;
        private SettableFuture<V> futureValue = SettableFuture.create();
        private Stopwatch stopwatch = Stopwatch.createUnstarted();

        public LoadingValueReference() {
            this(LocalCache.unset());
        }

        /*
         * WARNING - void declaration
         */
        public LoadingValueReference(ValueReference<K, V> oldValue) {
            void var1_1;
            this.oldValue = var1_1;
        }

        @Override
        public final boolean isLoading() {
            return true;
        }

        @Override
        public final boolean isActive() {
            return this.oldValue.isActive();
        }

        @Override
        public final int getWeight() {
            return this.oldValue.getWeight();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean set(@Nullable V newValue) {
            void var1_1;
            return this.futureValue.set(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean setException(Throwable t) {
            void var1_1;
            return this.futureValue.setException((Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void notifyNewValue(@Nullable V newValue) {
            if (newValue != null) {
                void var1_1;
                this.set(var1_1);
                return;
            }
            this.oldValue = LocalCache.unset();
        }

        /*
         * WARNING - void declaration
         */
        public final ListenableFuture<V> loadFuture(K key, CacheLoader<? super K, V> loader) {
            this.stopwatch.start();
            V previousValue = this.oldValue.get();
            try {
                void var3_3;
                void var2_2;
                Object newValue;
                if (previousValue == null) {
                    newValue = loader.load(key);
                    if (this.set(newValue)) {
                        return this.futureValue;
                    }
                    return Futures.immediateFuture(newValue);
                }
                if ((newValue = var2_2.reload(newValue, var3_3)) == null) {
                    return Futures.immediateFuture(null);
                }
                return Futures.transform(newValue, new Function<V, V>(this){
                    private /* synthetic */ LoadingValueReference this$0;
                    {
                        this.this$0 = loadingValueReference;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final V apply(V newValue) {
                        void var1_1;
                        this.this$0.set(newValue);
                        return var1_1;
                    }
                });
            }
            catch (Throwable throwable) {
                void var1_1;
                Throwable t = throwable;
                if (throwable instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (this.setException(t)) {
                    return this.futureValue;
                }
                return Futures.immediateFailedFuture((Throwable)var1_1);
            }
        }

        public final long elapsedNanos() {
            return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
        }

        @Override
        public final V waitForValue() throws ExecutionException {
            return Ascii.getUninterruptibly(this.futureValue);
        }

        @Override
        public final V get() {
            return this.oldValue.get();
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, @Nullable V value, ReferenceEntry<K, V> entry) {
            return this;
        }
    }

    static final class Segment<K, V>
    extends ReentrantLock {
        final LocalCache<K, V> map;
        volatile int count;
        @GuardedBy(value="this")
        private long totalWeight;
        int modCount;
        private int threshold;
        volatile AtomicReferenceArray<ReferenceEntry<K, V>> table;
        private long maxSegmentWeight;
        final ReferenceQueue<K> keyReferenceQueue;
        final ReferenceQueue<V> valueReferenceQueue;
        private Queue<ReferenceEntry<K, V>> recencyQueue;
        final AtomicInteger readCount = new AtomicInteger();
        @GuardedBy(value="this")
        final Queue<ReferenceEntry<K, V>> writeQueue;
        @GuardedBy(value="this")
        final Queue<ReferenceEntry<K, V>> accessQueue;
        final AbstractCache.StatsCounter statsCounter;

        /*
         * WARNING - void declaration
         */
        Segment(LocalCache<K, V> map, int initialCapacity, long maxSegmentWeight, AbstractCache.StatsCounter statsCounter) {
            void var1_1;
            void var2_2;
            void var3_4;
            this.map = map;
            this.maxSegmentWeight = var3_4;
            this.statsCounter = Ascii.checkNotNull(statsCounter);
            AtomicReferenceArray<ReferenceEntry<K, V>> atomicReferenceArray = Segment.newEntryArray((int)var2_2);
            Object object = this;
            this.threshold = atomicReferenceArray.length() * 3 / 4;
            if (!((Segment)object).map.customWeigher() && (long)((Segment)object).threshold == ((Segment)object).maxSegmentWeight) {
                ++((Segment)object).threshold;
            }
            ((Segment)object).table = atomicReferenceArray;
            this.keyReferenceQueue = map.usesKeyReferences() ? new ReferenceQueue() : null;
            this.valueReferenceQueue = map.usesValueReferences() ? new ReferenceQueue() : null;
            this.recencyQueue = map.usesAccessQueue() ? new ConcurrentLinkedQueue() : LocalCache.discardingQueue();
            object = map;
            this.writeQueue = ((LocalCache)object).expiresAfterWrite() ? new WriteQueue() : LocalCache.discardingQueue();
            this.accessQueue = var1_1.usesAccessQueue() ? new AccessQueue() : LocalCache.discardingQueue();
        }

        private static AtomicReferenceArray<ReferenceEntry<K, V>> newEntryArray(int size) {
            int n;
            return new AtomicReferenceArray(n);
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private ReferenceEntry<K, V> newEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.map.entryFactory.newEntry(this, Ascii.checkNotNull(var1_1), (int)var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private ReferenceEntry<K, V> copyEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (original.getKey() == null) {
                return null;
            }
            ValueReference<K, V> valueReference = original.getValueReference();
            V value = valueReference.get();
            if (value == null && valueReference.isActive()) {
                return null;
            }
            ReferenceEntry<K, V> newEntry = this.map.entryFactory.copyEntry(this, original, var2_2);
            newEntry.setValueReference(var3_3.copyFor(this.valueReferenceQueue, value, newEntry));
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private void setValue(ReferenceEntry<K, V> entry, K key, V value, long now) {
            void var3_5;
            Segment segment;
            void var2_3;
            ValueReference<K, void> previous = entry.getValueReference();
            int weight = this.map.weigher.weigh(key, value);
            Ascii.checkState(weight >= 0, "Weights must be non-negative");
            ValueReference<K, V> valueReference = this.map.valueStrength.referenceValue(this, entry, value, weight);
            entry.setValueReference(valueReference);
            long l = now;
            void var4_7 = var2_3;
            void var2_4 = segment;
            segment = this;
            segment.drainRecencyQueue();
            segment.totalWeight += (long)var4_7;
            LocalCache<K, V> localCache = segment.map;
            if (localCache.expiresAfterAccess()) {
                var2_4.setAccessTime(l);
            }
            if (segment.map.recordsWrite()) {
                var2_4.setWriteTime(l);
            }
            segment.accessQueue.add((ReferenceEntry<K, V>)var2_4);
            segment.writeQueue.add((ReferenceEntry<K, V>)var2_4);
            previous.notifyNewValue(var3_5);
        }

        /*
         * WARNING - void declaration
         */
        final V get(K key, int hash, CacheLoader<? super K, V> loader) throws ExecutionException {
            Ascii.checkNotNull(key);
            Ascii.checkNotNull(loader);
            try {
                void var3_4;
                void var2_3;
                void var1_1;
                ReferenceEntry<K, V> e;
                if (this.count != 0 && (e = this.getEntry(key, hash)) != null) {
                    long now = this.map.ticker.read();
                    V value = this.getLiveValue(e, now);
                    if (value != null) {
                        this.recordRead(e, now);
                        this.statsCounter.recordHits(1);
                        V v = this.scheduleRefresh(e, key, hash, value, now, loader);
                        return v;
                    }
                    ValueReference<K, V> valueReference = e.getValueReference();
                    if (valueReference.isLoading()) {
                        key = this.waitForLoadingValue(e, key, valueReference);
                        return (V)key;
                    }
                }
                e = this.lockedGetOrLoad(var1_1, (int)var2_3, (CacheLoader<? super K, V>)var3_4);
                return (V)e;
            }
            catch (ExecutionException executionException) {
                ExecutionException ee = executionException;
                Throwable cause = executionException.getCause();
                if (cause instanceof Error) {
                    throw new ExecutionError((Error)cause);
                }
                if (cause instanceof RuntimeException) {
                    throw new UncheckedExecutionException(cause);
                }
                throw ee;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private V lockedGetOrLoad(K key, int hash, CacheLoader<? super K, V> loader) throws ExecutionException {
            void var1_1;
            Object e;
            ValueReference<K, V> valueReference = null;
            LoadingValueReference loadingValueReference = null;
            boolean createNewEntry = true;
            this.lock();
            try {
                long now;
                long l = now = this.map.ticker.read();
                Segment segment = this;
                segment.runLockedCleanup(l);
                int newCount = this.count - 1;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                ReferenceEntry first = table.get(index);
                for (e = first; e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    valueReference = e.getValueReference();
                    if (valueReference.isLoading()) {
                        createNewEntry = false;
                        break;
                    }
                    V value = valueReference.get();
                    if (value == null) {
                        this.enqueueNotification$1dd09a7a(entryKey, valueReference, RemovalCause.COLLECTED);
                    } else if (this.map.isExpired((ReferenceEntry<K, V>)e, now)) {
                        this.enqueueNotification$1dd09a7a(entryKey, valueReference, RemovalCause.EXPIRED);
                    } else {
                        this.recordLockedRead((ReferenceEntry<K, V>)e, now);
                        this.statsCounter.recordHits(1);
                        key = value;
                        return (V)key;
                    }
                    this.writeQueue.remove(e);
                    this.accessQueue.remove(e);
                    this.count = newCount;
                    break;
                }
                if (createNewEntry) {
                    loadingValueReference = new LoadingValueReference();
                    if (e == null) {
                        e = this.newEntry(key, hash, first);
                        e.setValueReference(loadingValueReference);
                        table.set(index, (ReferenceEntry<K, V>)e);
                    } else {
                        e.setValueReference(loadingValueReference);
                    }
                }
            }
            finally {
                this.unlock();
                Segment newCount = this;
                newCount.runUnlockedCleanup();
            }
            if (createNewEntry) {
                try {
                    ReferenceEntry referenceEntry = e;
                    synchronized (referenceEntry) {
                        void var2_5;
                        void var3_7;
                        valueReference = var3_7;
                        e = loadingValueReference;
                        void var3_8 = var2_5;
                        K k = key;
                        key = this;
                        valueReference = ((LoadingValueReference)e).loadFuture(k, valueReference);
                        V v = ((Segment)key).getAndRecordStats(k, (int)var3_8, (LoadingValueReference<K, V>)e, (ListenableFuture<V>)((Object)valueReference));
                        return v;
                    }
                }
                finally {
                    this.statsCounter.recordMisses(1);
                }
            }
            return this.waitForLoadingValue((ReferenceEntry<K, V>)e, var1_1, valueReference);
        }

        /*
         * WARNING - void declaration
         */
        private V waitForLoadingValue(ReferenceEntry<K, V> e, K key, ValueReference<K, V> valueReference) throws ExecutionException {
            if (!valueReference.isLoading()) {
                throw new AssertionError();
            }
            Ascii.checkState(!Thread.holdsLock(e), "Recursive load of: %s", key);
            try {
                void var3_4;
                void var1_1;
                V value = valueReference.waitForValue();
                if (value == null) {
                    void var2_3;
                    String string = String.valueOf(String.valueOf(var2_3));
                    throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(35 + string.length()).append("CacheLoader returned null for key ").append(string).append(".").toString());
                }
                long now = this.map.ticker.read();
                this.recordRead((ReferenceEntry<K, V>)var1_1, now);
                var1_1 = var3_4;
                return var1_1;
            }
            finally {
                this.statsCounter.recordMisses(1);
            }
        }

        /*
         * WARNING - void declaration
         */
        final V getAndRecordStats(K key, int hash, LoadingValueReference<K, V> loadingValueReference, ListenableFuture<V> newValue) throws ExecutionException {
            String string;
            block4: {
                V value = null;
                try {
                    V v = Ascii.getUninterruptibly(newValue);
                    value = v;
                    if (v == null) {
                        string = String.valueOf(String.valueOf(key));
                        throw new CacheLoader.InvalidCacheLoadException(new StringBuilder(35 + string.length()).append("CacheLoader returned null for key ").append(string).append(".").toString());
                    }
                    this.statsCounter.recordLoadSuccess(loadingValueReference.elapsedNanos());
                    this.storeLoadedValue(key, hash, loadingValueReference, value);
                    string = value;
                    if (value != null) break block4;
                    this.statsCounter.recordLoadException(loadingValueReference.elapsedNanos());
                    this.removeLoadingValue(key, hash, loadingValueReference);
                }
                catch (Throwable throwable) {
                    if (value == null) {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.statsCounter.recordLoadException(loadingValueReference.elapsedNanos());
                        this.removeLoadingValue(var1_1, (int)var2_2, (LoadingValueReference<K, V>)var3_3);
                    }
                    throw throwable;
                }
            }
            return (V)string;
        }

        /*
         * WARNING - void declaration
         */
        private V scheduleRefresh(ReferenceEntry<K, V> entry, K key, int hash, V oldValue, long now, CacheLoader<? super K, V> loader) {
            void var3_3;
            void var2_2;
            V newValue;
            if (this.map.refreshes() && now - entry.getWriteTime() > this.map.refreshNanos && !entry.getValueReference().isLoading() && (newValue = this.refresh(var2_2, (int)var3_3, loader, true)) != null) {
                void var1_1;
                return var1_1;
            }
            return oldValue;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        final V refresh(K key, int hash, CacheLoader<? super K, V> loader, boolean checkTime) {
            void var2_2;
            void var3_4;
            LoadingValueReference<K, V> loadingValueReference = this.insertLoadingValueReference(key, hash, checkTime);
            if (loadingValueReference == null) {
                return null;
            }
            ListenableFuture<V> listenableFuture = var3_4;
            LoadingValueReference<K, V> loadingValueReference2 = loadingValueReference;
            void var3_5 = var2_2;
            K k = key;
            key = this;
            listenableFuture = loadingValueReference2.loadFuture(k, (CacheLoader<K, V>)((Object)listenableFuture));
            listenableFuture.addListener(new Runnable((Segment)key, k, (int)var3_5, loadingValueReference2, listenableFuture){
                private /* synthetic */ Object val$key;
                private /* synthetic */ int val$hash;
                private /* synthetic */ LoadingValueReference val$loadingValueReference;
                private /* synthetic */ ListenableFuture val$loadingFuture;
                private /* synthetic */ Segment this$0;
                {
                    this.this$0 = segment;
                    this.val$key = object;
                    this.val$hash = n;
                    this.val$loadingValueReference = loadingValueReference;
                    this.val$loadingFuture = listenableFuture;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void run() {
                    try {
                        this.this$0.getAndRecordStats(this.val$key, this.val$hash, this.val$loadingValueReference, this.val$loadingFuture);
                        return;
                    }
                    catch (Throwable t) {
                        void var1_1;
                        logger.log(Level.WARNING, "Exception thrown during refresh", t);
                        this.val$loadingValueReference.setException((Throwable)var1_1);
                        return;
                    }
                }
            }, ExecutionList.RunnableExecutorPair.directExecutor());
            ListenableFuture<V> result = listenableFuture;
            if (result.isDone()) {
                try {
                    void var1_1;
                    return Ascii.getUninterruptibly(var1_1);
                }
                catch (Throwable throwable) {}
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private LoadingValueReference<K, V> insertLoadingValueReference(K key, int hash, boolean checkTime) {
            Object e;
            this.lock();
            try {
                void var2_3;
                LoadingValueReference loadingValueReference;
                long now;
                long l = now = this.map.ticker.read();
                Segment segment = this;
                segment.runLockedCleanup(l);
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                ReferenceEntry<K, V> first = table.get(index);
                for (e = first; e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    if (valueReference.isLoading() || checkTime && now - e.getWriteTime() < this.map.refreshNanos) {
                        return null;
                    }
                    ++this.modCount;
                    LoadingValueReference<K, V> loadingValueReference2 = new LoadingValueReference<K, V>(valueReference);
                    e.setValueReference(loadingValueReference2);
                    return loadingValueReference;
                }
                ++this.modCount;
                LoadingValueReference loadingValueReference3 = new LoadingValueReference();
                e = this.newEntry(loadingValueReference, (int)var2_3, first);
                e.setValueReference(loadingValueReference3);
                table.set(index, (ReferenceEntry<K, V>)e);
                loadingValueReference = loadingValueReference3;
                return loadingValueReference;
            }
            finally {
                this.unlock();
                e = this;
                ((Segment)e).runUnlockedCleanup();
            }
        }

        private void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.drainReferenceQueues();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        @GuardedBy(value="this")
        private void drainReferenceQueues() {
            Object object;
            LocalCache<K, V> localCache;
            int n;
            Segment segment;
            if (this.map.usesKeyReferences()) {
                segment = this;
                n = 0;
                while ((localCache = segment.keyReferenceQueue.poll()) != null) {
                    localCache = (ReferenceEntry)((Object)localCache);
                    object = localCache;
                    localCache = segment.map;
                    int n2 = object.getHash();
                    localCache.segmentFor(n2).reclaimKey((ReferenceEntry<K, V>)object, n2);
                    if (++n != 16) continue;
                }
            }
            if (this.map.usesValueReferences()) {
                segment = this;
                n = 0;
                while ((localCache = segment.valueReferenceQueue.poll()) != null) {
                    localCache = (ValueReference)((Object)localCache);
                    object = localCache;
                    localCache = segment.map;
                    ReferenceEntry referenceEntry = object.getEntry();
                    int n3 = referenceEntry.getHash();
                    localCache.segmentFor(n3).reclaimValue((K)referenceEntry.getKey(), n3, (ValueReference<K, V>)object);
                    if (++n != 16) continue;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void recordRead(ReferenceEntry<K, V> entry, long now) {
            void var1_1;
            LocalCache<K, V> localCache = this.map;
            if (localCache.expiresAfterAccess()) {
                void var2_2;
                entry.setAccessTime((long)var2_2);
            }
            this.recencyQueue.add((ReferenceEntry<K, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private void recordLockedRead(ReferenceEntry<K, V> entry, long now) {
            void var1_1;
            LocalCache<K, V> localCache = this.map;
            if (localCache.expiresAfterAccess()) {
                void var2_2;
                entry.setAccessTime((long)var2_2);
            }
            this.accessQueue.add((ReferenceEntry<K, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private void drainRecencyQueue() {
            ReferenceEntry<K, V> e;
            while ((e = this.recencyQueue.poll()) != null) {
                void var1_1;
                if (!this.accessQueue.contains(e)) continue;
                this.accessQueue.add((ReferenceEntry<K, V>)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void tryExpireEntries(long now) {
            if (this.tryLock()) {
                try {
                    void var1_1;
                    this.expireEntries((long)var1_1);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private void expireEntries(long now) {
            ReferenceEntry<K, V> e;
            this.drainRecencyQueue();
            while ((e = this.writeQueue.peek()) != null && this.map.isExpired(e, now)) {
                if (!this.removeEntry(e, e.getHash(), RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
            while ((e = this.accessQueue.peek()) != null && this.map.isExpired(e, now)) {
                void var3_2;
                if (!this.removeEntry(e, var3_2.getHash(), RemovalCause.EXPIRED)) {
                    throw new AssertionError();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        final void enqueueNotification(ReferenceEntry<K, V> entry, RemovalCause cause) {
            void var2_2;
            void var1_1;
            K k = entry.getKey();
            entry.getHash();
            this.enqueueNotification$1dd09a7a(k, var1_1.getValueReference(), (RemovalCause)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private void enqueueNotification$1dd09a7a(@Nullable K key, ValueReference<K, V> valueReference, RemovalCause cause) {
            this.totalWeight -= (long)valueReference.getWeight();
            if (cause.wasEvicted()) {
                this.statsCounter.recordEviction();
            }
            if (this.map.removalNotificationQueue != DISCARDING_QUEUE) {
                void var1_1;
                void var3_3;
                void var2_2;
                V value = valueReference.get();
                RemovalNotification<K, void> notification = new RemovalNotification<K, void>(key, var2_2, (RemovalCause)var3_3);
                this.map.removalNotificationQueue.offer(var1_1);
            }
        }

        @GuardedBy(value="this")
        private void evictEntries() {
            if (!this.map.evictsBySize()) {
                return;
            }
            this.drainRecencyQueue();
            while (this.totalWeight > this.maxSegmentWeight) {
                ReferenceEntry referenceEntry;
                Object object;
                block4: {
                    object = this;
                    object = ((Segment)object).accessQueue.iterator();
                    while (object.hasNext()) {
                        referenceEntry = (ReferenceEntry)object.next();
                        int n = referenceEntry.getValueReference().getWeight();
                        if (n <= 0) continue;
                        break block4;
                    }
                    throw new AssertionError();
                }
                ReferenceEntry e = referenceEntry;
                if (!this.removeEntry(e, object.getHash(), RemovalCause.SIZE)) {
                    throw new AssertionError();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private ReferenceEntry<K, V> getEntry(Object key, int hash) {
            int n = hash;
            Serializable serializable = this;
            serializable = ((Segment)serializable).table;
            for (ReferenceEntry<K, V> e = ((AtomicReferenceArray)serializable).get(n & ((AtomicReferenceArray)serializable).length() - 1); e != null; e = e.getNext()) {
                void var3_4;
                if (e.getHash() != hash) continue;
                K entryKey = e.getKey();
                if (entryKey == null) {
                    this.tryDrainReferenceQueues();
                    continue;
                }
                if (!this.map.keyEquivalence.equivalent(key, var3_4)) continue;
                return e;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        private ReferenceEntry<K, V> getLiveEntry(Object key, int hash, long now) {
            void var1_1;
            void var2_2;
            ReferenceEntry<K, V> e = this.getEntry(key, (int)var2_2);
            if (e == null) {
                return null;
            }
            if (this.map.isExpired(e, now)) {
                void var3_3;
                this.tryExpireEntries((long)var3_3);
                return null;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final V getLiveValue(ReferenceEntry<K, V> entry, long now) {
            void var1_1;
            if (entry.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            V value = entry.getValueReference().get();
            if (value == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            if (this.map.isExpired((ReferenceEntry<K, V>)var1_1, now)) {
                void var2_2;
                this.tryExpireEntries((long)var2_2);
                return null;
            }
            return value;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        final V get(Object key, int hash) {
            try {
                if (this.count != 0) {
                    long now = this.map.ticker.read();
                    ReferenceEntry<K, V> e = this.getLiveEntry(key, hash, now);
                    if (e == null) {
                        return null;
                    }
                    V value = e.getValueReference().get();
                    if (value != null) {
                        void var3_4;
                        void var2_3;
                        V v;
                        this.recordRead(e, now);
                        v = this.scheduleRefresh(e, v.getKey(), (int)var2_3, value, (long)var3_4, this.map.defaultLoader);
                        return v;
                    }
                    this.tryDrainReferenceQueues();
                }
                return null;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean containsKey(Object key, int hash) {
            try {
                if (this.count != 0) {
                    void var1_1;
                    void var3_5;
                    void var2_4;
                    long now = this.map.ticker.read();
                    ReferenceEntry<K, V> e = this.getLiveEntry(key, (int)var2_4, (long)var3_5);
                    if (e == null) {
                        return false;
                    }
                    boolean bl = var1_1.getValueReference().get() != null;
                    return bl;
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        final V put(K key, int hash, V value, boolean onlyIfAbsent) {
            this.lock();
            try {
                void var3_5;
                void var1_1;
                void var2_3;
                Segment newCount2;
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                Segment segment = this;
                segment.runLockedCleanup(l);
                int n = this.count + 1;
                if (n > this.threshold) {
                    this.expand();
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    void var2_4;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        int newCount2;
                        ++this.modCount;
                        if (valueReference.isActive()) {
                            this.enqueueNotification$1dd09a7a(key, valueReference, RemovalCause.COLLECTED);
                            this.setValue(e, key, value, now);
                            newCount2 = this.count;
                        } else {
                            this.setValue(e, key, value, now);
                            newCount2 = this.count + 1;
                        }
                        this.count = newCount2;
                        this.evictEntries();
                        return null;
                    }
                    if (onlyIfAbsent) {
                        this.recordLockedRead(e, now);
                        key = newCount2;
                        return (V)key;
                    }
                    ++this.modCount;
                    this.enqueueNotification$1dd09a7a(key, (ValueReference<K, V>)var2_4, RemovalCause.REPLACED);
                    this.setValue(e, key, value, now);
                    this.evictEntries();
                    key = newCount2;
                    return (V)key;
                }
                ++this.modCount;
                ReferenceEntry<K, V> newEntry = this.newEntry(key, (int)var2_3, first);
                this.setValue(newEntry, var1_1, var3_5, now);
                ((AtomicReferenceArray)((Object)newCount2)).set(index, newEntry);
                this.count = newCount2 = this.count + 1;
                this.evictEntries();
                return null;
            }
            finally {
                this.unlock();
                Segment newCount2 = this;
                newCount2.runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private void expand() {
            void var3_3;
            AtomicReferenceArray<ReferenceEntry<K, V>> oldTable = this.table;
            int oldCapacity = oldTable.length();
            if (oldCapacity >= 0x40000000) {
                return;
            }
            int newCount = this.count;
            AtomicReferenceArray<ReferenceEntry<K, V>> newTable = Segment.newEntryArray(oldCapacity << 1);
            this.threshold = newTable.length() * 3 / 4;
            int newMask = newTable.length() - 1;
            for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
                int newIndex;
                ReferenceEntry<K, V> e;
                ReferenceEntry<K, V> head = oldTable.get(oldIndex);
                if (head == null) continue;
                ReferenceEntry<K, V> next = head.getNext();
                int headIndex = head.getHash() & newMask;
                if (next == null) {
                    newTable.set(headIndex, head);
                    continue;
                }
                ReferenceEntry<K, V> tail = head;
                int tailIndex = headIndex;
                for (e = next; e != null; e = e.getNext()) {
                    newIndex = e.getHash() & newMask;
                    if (newIndex == tailIndex) continue;
                    tailIndex = newIndex;
                    tail = e;
                }
                newTable.set(tailIndex, tail);
                for (e = head; e != tail; e = e.getNext()) {
                    newIndex = e.getHash() & newMask;
                    ReferenceEntry<K, V> newNext = newTable.get(newIndex);
                    ReferenceEntry<K, V> newFirst = this.copyEntry(e, newNext);
                    if (newFirst != null) {
                        newTable.set(newIndex, newFirst);
                        continue;
                    }
                    this.removeCollectedEntry(e);
                    --newCount;
                }
            }
            this.table = newTable;
            this.count = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        final boolean replace(K key, int hash, V oldValue, V newValue) {
            Serializable table;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                Segment segment = this;
                segment.runLockedCleanup(l);
                table = this.table;
                int index = hash & ((AtomicReferenceArray)table).length() - 1;
                for (ReferenceEntry<K, V> e = first = ((AtomicReferenceArray)table).get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (valueReference.isActive()) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, RemovalCause.COLLECTED);
                            int newCount = this.count - 1;
                            ((AtomicReferenceArray)table).set(index, var2_5);
                            this.count = var1_2;
                        }
                        return false;
                    }
                    if (this.map.valueEquivalence.equivalent(oldValue, entryValue)) {
                        void var1_1;
                        ++this.modCount;
                        this.enqueueNotification$1dd09a7a(var1_1, valueReference, RemovalCause.REPLACED);
                        this.setValue(e, var1_1, newValue, now);
                        this.evictEntries();
                        return true;
                    }
                    this.recordLockedRead(e, now);
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                table = this;
                ((Segment)table).runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        final V replace(K key, int hash, V newValue) {
            Serializable table;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                Segment segment = this;
                segment.runLockedCleanup(l);
                table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    V v;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue == null) {
                        if (valueReference.isActive()) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, RemovalCause.COLLECTED);
                            int newCount = this.count - 1;
                            table.set(index, (ReferenceEntry<K, V>)var2_5);
                            this.count = var1_2;
                        }
                        return null;
                    }
                    ++this.modCount;
                    this.enqueueNotification$1dd09a7a(v, valueReference, RemovalCause.REPLACED);
                    this.setValue(e, v, newValue, now);
                    this.evictEntries();
                    v = entryValue;
                    return v;
                }
                return null;
            }
            finally {
                this.unlock();
                table = this;
                ((Segment)table).runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        final V remove(Object key, int hash) {
            Serializable table;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                void var3_7;
                long now = this.map.ticker.read();
                void var5_8 = var3_7;
                Segment segment = this;
                segment.runLockedCleanup((long)var5_8);
                table = this.table;
                int index = hash & ((AtomicReferenceArray)table).length() - 1;
                for (ReferenceEntry<K, V> e = first = ((AtomicReferenceArray)table).get(index); e != null; e = e.getNext()) {
                    void var1_2;
                    void var2_6;
                    RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (entryValue != null) {
                        cause = RemovalCause.EXPLICIT;
                    } else if (valueReference.isActive()) {
                        cause = RemovalCause.COLLECTED;
                    } else {
                        return null;
                    }
                    ++this.modCount;
                    ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, cause);
                    int newCount = this.count - 1;
                    ((AtomicReferenceArray)table).set(index, var2_6);
                    this.count = var1_2;
                    V v = entryValue;
                    return v;
                }
                return null;
            }
            finally {
                this.unlock();
                table = this;
                ((Segment)table).runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean storeLoadedValue(K key, int hash, LoadingValueReference<K, V> oldValueReference, V newValue) {
            this.lock();
            try {
                void var10_15;
                void var1_1;
                void var2_3;
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                Segment segment = this;
                segment.runLockedCleanup(l);
                int newCount = this.count + 1;
                if (newCount > this.threshold) {
                    this.expand();
                    newCount = this.count + 1;
                }
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    WeightedStrongValueReference weightedStrongValueReference;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (oldValueReference == valueReference || entryValue == null && valueReference != UNSET) {
                        ++this.modCount;
                        if (oldValueReference.isActive()) {
                            RemovalCause cause = entryValue == null ? RemovalCause.COLLECTED : RemovalCause.REPLACED;
                            this.enqueueNotification$1dd09a7a(key, oldValueReference, (RemovalCause)((Object)weightedStrongValueReference));
                            --newCount;
                        }
                        this.setValue(e, key, newValue, now);
                        this.count = newCount;
                        this.evictEntries();
                        return true;
                    }
                    weightedStrongValueReference = new WeightedStrongValueReference(newValue, 0);
                    this.enqueueNotification$1dd09a7a(key, weightedStrongValueReference, RemovalCause.REPLACED);
                    return false;
                }
                ++this.modCount;
                ReferenceEntry<K, V> newEntry = this.newEntry(key, (int)var2_3, first);
                this.setValue(newEntry, var1_1, newValue, now);
                var10_15.set(index, newEntry);
                this.count = newCount;
                this.evictEntries();
                return true;
            }
            finally {
                this.unlock();
                Segment newCount = this;
                newCount.runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean remove(Object key, int hash, Object value) {
            Serializable table;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                long now;
                long l = now = this.map.ticker.read();
                Segment segment = this;
                segment.runLockedCleanup(l);
                table = this.table;
                int index = hash & ((AtomicReferenceArray)table).length() - 1;
                for (ReferenceEntry<K, V> e = first = ((AtomicReferenceArray)table).get(index); e != null; e = e.getNext()) {
                    void var3_6;
                    boolean bl;
                    void var2_5;
                    RemovalCause cause;
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    ValueReference<K, V> valueReference = e.getValueReference();
                    V entryValue = valueReference.get();
                    if (this.map.valueEquivalence.equivalent(value, entryValue)) {
                        cause = RemovalCause.EXPLICIT;
                    } else if (entryValue == null && valueReference.isActive()) {
                        cause = RemovalCause.COLLECTED;
                    } else {
                        return false;
                    }
                    ++this.modCount;
                    ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, cause);
                    int newCount = this.count - 1;
                    ((AtomicReferenceArray)table).set(index, var2_5);
                    this.count = bl;
                    bl = var3_6 == RemovalCause.EXPLICIT;
                    return bl;
                }
                return false;
            }
            finally {
                this.unlock();
                table = this;
                ((Segment)table).runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        @GuardedBy(value="this")
        private ReferenceEntry<K, V> removeValueFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry, @Nullable K key, int hash, ValueReference<K, V> valueReference, RemovalCause cause) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.enqueueNotification$1dd09a7a(var3_3, valueReference, cause);
            this.writeQueue.remove(entry);
            this.accessQueue.remove(entry);
            if (valueReference.isLoading()) {
                valueReference.notifyNewValue(null);
                return first;
            }
            return this.removeEntryFromChain((ReferenceEntry<K, V>)var1_1, (ReferenceEntry<K, V>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        @GuardedBy(value="this")
        private ReferenceEntry<K, V> removeEntryFromChain(ReferenceEntry<K, V> first, ReferenceEntry<K, V> entry) {
            void var3_3;
            ReferenceEntry e;
            int newCount = this.count;
            ReferenceEntry<K, V> newFirst = entry.getNext();
            while (e != entry) {
                ReferenceEntry<K, V> next = this.copyEntry(e, newFirst);
                if (next != null) {
                    newFirst = next;
                } else {
                    this.removeCollectedEntry(e);
                    --newCount;
                }
                e = e.getNext();
            }
            this.count = var3_3;
            return newFirst;
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private void removeCollectedEntry(ReferenceEntry<K, V> entry) {
            void var1_1;
            this.enqueueNotification(entry, RemovalCause.COLLECTED);
            this.writeQueue.remove(entry);
            this.accessQueue.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final boolean reclaimKey(ReferenceEntry<K, V> entry, int hash) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    void var1_2;
                    if (e != entry) continue;
                    ++this.modCount;
                    ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, e.getKey(), hash, e.getValueReference(), RemovalCause.COLLECTED);
                    int newCount = this.count - 1;
                    table.set(index, (ReferenceEntry<K, V>)((Object)segment));
                    this.count = var1_2;
                    return true;
                }
                return false;
            }
            finally {
                this.unlock();
                segment = this;
                segment.runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        final boolean reclaimValue(K key, int hash, ValueReference<K, V> valueReference) {
            Segment segment;
            this.lock();
            try {
                ReferenceEntry<K, V> first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash & table.length() - 1;
                for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    key = e.getValueReference();
                    if (key == valueReference) {
                        void var1_2;
                        ++this.modCount;
                        ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, entryKey, hash, valueReference, RemovalCause.COLLECTED);
                        int newCount = this.count - 1;
                        table.set(index, (ReferenceEntry<K, V>)((Object)segment));
                        this.count = var1_2;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                if (!this.isHeldByCurrentThread()) {
                    segment = this;
                    segment.runUnlockedCleanup();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean removeLoadingValue(K key, int hash2, LoadingValueReference<K, V> valueReference) {
            this.lock();
            try {
                ReferenceEntry first;
                AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
                int index = hash2 & table.length() - 1;
                for (ReferenceEntry e = first = table.get(index); e != null; e = e.getNext()) {
                    K entryKey = e.getKey();
                    if (e.getHash() != hash2 || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    key = e.getValueReference();
                    if (key == valueReference) {
                        if (valueReference.isActive()) {
                            key = valueReference;
                            e.setValueReference(((LoadingValueReference)key).oldValue);
                        } else {
                            void var1_1;
                            ReferenceEntry<K, V> newFirst = this.removeEntryFromChain(first, e);
                            table.set(index, (ReferenceEntry<K, V>)var1_1);
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
                Segment hash2 = this;
                hash2.runUnlockedCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        @GuardedBy(value="this")
        private boolean removeEntry(ReferenceEntry<K, V> entry, int hash, RemovalCause cause) {
            ReferenceEntry<K, V> first;
            AtomicReferenceArray<ReferenceEntry<K, V>> table = this.table;
            int index = hash & table.length() - 1;
            for (ReferenceEntry<K, V> e = first = table.get(index); e != null; e = e.getNext()) {
                void var1_2;
                void var2_4;
                if (e != entry) continue;
                ++this.modCount;
                ReferenceEntry<K, V> newFirst = this.removeValueFromChain(first, e, e.getKey(), hash, e.getValueReference(), cause);
                int newCount = this.count - 1;
                table.set(index, (ReferenceEntry<K, V>)var2_4);
                this.count = var1_2;
                return true;
            }
            return false;
        }

        final void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.cleanUp();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void cleanUp() {
            void var1_1;
            long now = this.map.ticker.read();
            this.runLockedCleanup((long)var1_1);
            this.runUnlockedCleanup();
        }

        /*
         * WARNING - void declaration
         */
        private void runLockedCleanup(long now) {
            if (this.tryLock()) {
                try {
                    void var1_1;
                    this.drainReferenceQueues();
                    this.expireEntries((long)var1_1);
                    this.readCount.set(0);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        final void runUnlockedCleanup() {
            if (!this.isHeldByCurrentThread()) {
                RemovalNotification removalNotification;
                LocalCache<K, V> localCache = this.map;
                while ((removalNotification = localCache.removalNotificationQueue.poll()) != null) {
                    try {
                        localCache.removalListener.onRemoval(removalNotification);
                    }
                    catch (Throwable throwable) {
                        logger.log(Level.WARNING, "Exception thrown by removal listener", throwable);
                    }
                }
            }
        }
    }

    static final class WeightedStrongValueReference<K, V>
    extends StrongValueReference<K, V> {
        private int weight;

        /*
         * WARNING - void declaration
         */
        WeightedStrongValueReference(V referent, int weight) {
            super(var1_1);
            void var2_2;
            void var1_1;
            this.weight = var2_2;
        }

        @Override
        public final int getWeight() {
            return this.weight;
        }
    }

    static final class WeightedSoftValueReference<K, V>
    extends SoftValueReference<K, V> {
        private int weight;

        /*
         * WARNING - void declaration
         */
        WeightedSoftValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry, int weight) {
            super(var1_1, var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.weight = weight;
        }

        @Override
        public final int getWeight() {
            return this.weight;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new WeightedSoftValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3, this.weight);
        }
    }

    static final class WeightedWeakValueReference<K, V>
    extends WeakValueReference<K, V> {
        private int weight;

        /*
         * WARNING - void declaration
         */
        WeightedWeakValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry, int weight) {
            super(var1_1, var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
            this.weight = weight;
        }

        @Override
        public final int getWeight() {
            return this.weight;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new WeightedWeakValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3, this.weight);
        }
    }

    static class StrongValueReference<K, V>
    implements ValueReference<K, V> {
        private V referent;

        /*
         * WARNING - void declaration
         */
        StrongValueReference(V referent) {
            void var1_1;
            this.referent = var1_1;
        }

        @Override
        public V get() {
            return this.referent;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return null;
        }

        @Override
        public final ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            return this;
        }

        @Override
        public final boolean isLoading() {
            return false;
        }

        @Override
        public final boolean isActive() {
            return true;
        }

        @Override
        public final V waitForValue() {
            return this.get();
        }

        @Override
        public final void notifyNewValue(V newValue) {
        }
    }

    static class SoftValueReference<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        private ReferenceEntry<K, V> entry;

        /*
         * WARNING - void declaration
         */
        SoftValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.entry = var3_3;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public final void notifyNewValue(V newValue) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new SoftValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3);
        }

        @Override
        public final boolean isLoading() {
            return false;
        }

        @Override
        public final boolean isActive() {
            return true;
        }

        @Override
        public final V waitForValue() {
            return (V)this.get();
        }
    }

    static class WeakValueReference<K, V>
    extends WeakReference<V>
    implements ValueReference<K, V> {
        private ReferenceEntry<K, V> entry;

        /*
         * WARNING - void declaration
         */
        WeakValueReference(ReferenceQueue<V> queue, V referent, ReferenceEntry<K, V> entry) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.entry = var3_3;
        }

        @Override
        public int getWeight() {
            return 1;
        }

        @Override
        public final ReferenceEntry<K, V> getEntry() {
            return this.entry;
        }

        @Override
        public final void notifyNewValue(V newValue) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ValueReference<K, V> copyFor(ReferenceQueue<V> queue, V value, ReferenceEntry<K, V> entry) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new WeakValueReference<K, void>((ReferenceQueue<void>)var1_1, var2_2, var3_3);
        }

        @Override
        public final boolean isLoading() {
            return false;
        }

        @Override
        public final boolean isActive() {
            return true;
        }

        @Override
        public final V waitForValue() {
            return (V)this.get();
        }
    }

    static final class WeakAccessWriteEntry<K, V>
    extends WeakEntry<K, V> {
        private volatile long accessTime = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        private ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        private volatile long writeTime = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        private ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        WeakAccessWriteEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setAccessTime(long time) {
            void var1_1;
            this.accessTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextAccess = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousAccess = var1_1;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWriteTime(long time) {
            void var1_1;
            this.writeTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextWrite = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousWrite = var1_1;
        }
    }

    static final class WeakWriteEntry<K, V>
    extends WeakEntry<K, V> {
        private volatile long writeTime = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        private ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        WeakWriteEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWriteTime(long time) {
            void var1_1;
            this.writeTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextWrite = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousWrite = var1_1;
        }
    }

    static final class WeakAccessEntry<K, V>
    extends WeakEntry<K, V> {
        private volatile long accessTime = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        private ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        WeakAccessEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setAccessTime(long time) {
            void var1_1;
            this.accessTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextAccess = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousAccess = var1_1;
        }
    }

    static class WeakEntry<K, V>
    extends WeakReference<K>
    implements ReferenceEntry<K, V> {
        private int hash;
        private ReferenceEntry<K, V> next;
        private volatile ValueReference<K, V> valueReference = LocalCache.unset();

        /*
         * WARNING - void declaration
         */
        WeakEntry(ReferenceQueue<K> queue, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.hash = var3_3;
            this.next = next;
        }

        @Override
        public final K getKey() {
            return (K)this.get();
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            void var1_1;
            this.valueReference = var1_1;
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static final class StrongAccessWriteEntry<K, V>
    extends StrongEntry<K, V> {
        private volatile long accessTime = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        private ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();
        private volatile long writeTime = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        private ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        StrongAccessWriteEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setAccessTime(long time) {
            void var1_1;
            this.accessTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextAccess = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousAccess = var1_1;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWriteTime(long time) {
            void var1_1;
            this.writeTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextWrite = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousWrite = var1_1;
        }
    }

    static final class StrongWriteEntry<K, V>
    extends StrongEntry<K, V> {
        private volatile long writeTime = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextWrite = LocalCache.nullEntry();
        private ReferenceEntry<K, V> previousWrite = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        StrongWriteEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getWriteTime() {
            return this.writeTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWriteTime(long time) {
            void var1_1;
            this.writeTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInWriteQueue() {
            return this.nextWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextWrite = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInWriteQueue() {
            return this.previousWrite;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousWrite = var1_1;
        }
    }

    static final class StrongAccessEntry<K, V>
    extends StrongEntry<K, V> {
        private volatile long accessTime = Long.MAX_VALUE;
        private ReferenceEntry<K, V> nextAccess = LocalCache.nullEntry();
        private ReferenceEntry<K, V> previousAccess = LocalCache.nullEntry();

        /*
         * WARNING - void declaration
         */
        StrongAccessEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final long getAccessTime() {
            return this.accessTime;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setAccessTime(long time) {
            void var1_1;
            this.accessTime = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getNextInAccessQueue() {
            return this.nextAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            void var1_1;
            this.nextAccess = var1_1;
        }

        @Override
        public final ReferenceEntry<K, V> getPreviousInAccessQueue() {
            return this.previousAccess;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            void var1_1;
            this.previousAccess = var1_1;
        }
    }

    static class StrongEntry<K, V>
    extends AbstractReferenceEntry<K, V> {
        private K key;
        private int hash;
        private ReferenceEntry<K, V> next;
        private volatile ValueReference<K, V> valueReference = LocalCache.unset();

        /*
         * WARNING - void declaration
         */
        StrongEntry(K key, int hash, @Nullable ReferenceEntry<K, V> next) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.hash = var2_2;
            this.next = var3_3;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final ValueReference<K, V> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setValueReference(ValueReference<K, V> valueReference) {
            void var1_1;
            this.valueReference = var1_1;
        }

        @Override
        public final int getHash() {
            return this.hash;
        }

        @Override
        public final ReferenceEntry<K, V> getNext() {
            return this.next;
        }
    }

    static abstract class AbstractReferenceEntry<K, V>
    implements ReferenceEntry<K, V> {
        AbstractReferenceEntry() {
        }

        @Override
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setValueReference(ValueReference<K, V> valueReference) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public K getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAccessTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInAccessQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInAccessQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInAccessQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getWriteTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setWriteTime(long time) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getNextInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNextInWriteQueue(ReferenceEntry<K, V> next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceEntry<K, V> getPreviousInWriteQueue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPreviousInWriteQueue(ReferenceEntry<K, V> previous) {
            throw new UnsupportedOperationException();
        }
    }

    static final class NullEntry
    extends Enum<NullEntry>
    implements ReferenceEntry<Object, Object> {
        public static final /* enum */ NullEntry INSTANCE;

        @Override
        public final ValueReference<Object, Object> getValueReference() {
            return null;
        }

        @Override
        public final void setValueReference(ValueReference<Object, Object> valueReference) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNext() {
            return null;
        }

        @Override
        public final int getHash() {
            return 0;
        }

        @Override
        public final Object getKey() {
            return null;
        }

        @Override
        public final long getAccessTime() {
            return 0L;
        }

        @Override
        public final void setAccessTime(long time) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextInAccessQueue() {
            return this;
        }

        @Override
        public final void setNextInAccessQueue(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousInAccessQueue() {
            return this;
        }

        @Override
        public final void setPreviousInAccessQueue(ReferenceEntry<Object, Object> previous) {
        }

        @Override
        public final long getWriteTime() {
            return 0L;
        }

        @Override
        public final void setWriteTime(long time) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getNextInWriteQueue() {
            return this;
        }

        @Override
        public final void setNextInWriteQueue(ReferenceEntry<Object, Object> next) {
        }

        @Override
        public final ReferenceEntry<Object, Object> getPreviousInWriteQueue() {
            return this;
        }

        @Override
        public final void setPreviousInWriteQueue(ReferenceEntry<Object, Object> previous) {
        }

        static {
            (new NullEntry[1])[0] = INSTANCE = new NullEntry();
        }
    }

    static interface ReferenceEntry<K, V> {
        public ValueReference<K, V> getValueReference();

        public void setValueReference(ValueReference<K, V> var1);

        @Nullable
        public ReferenceEntry<K, V> getNext();

        public int getHash();

        @Nullable
        public K getKey();

        public long getAccessTime();

        public void setAccessTime(long var1);

        public ReferenceEntry<K, V> getNextInAccessQueue();

        public void setNextInAccessQueue(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousInAccessQueue();

        public void setPreviousInAccessQueue(ReferenceEntry<K, V> var1);

        public long getWriteTime();

        public void setWriteTime(long var1);

        public ReferenceEntry<K, V> getNextInWriteQueue();

        public void setNextInWriteQueue(ReferenceEntry<K, V> var1);

        public ReferenceEntry<K, V> getPreviousInWriteQueue();

        public void setPreviousInWriteQueue(ReferenceEntry<K, V> var1);
    }

    static interface ValueReference<K, V> {
        @Nullable
        public V get();

        public V waitForValue() throws ExecutionException;

        public int getWeight();

        @Nullable
        public ReferenceEntry<K, V> getEntry();

        public ValueReference<K, V> copyFor(ReferenceQueue<V> var1, @Nullable V var2, ReferenceEntry<K, V> var3);

        public void notifyNewValue(@Nullable V var1);

        public boolean isLoading();

        public boolean isActive();
    }

    static abstract class EntryFactory
    extends Enum<EntryFactory> {
        private static /* enum */ EntryFactory STRONG = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongEntry<void, V>(var2_2, (int)var3_3, next);
            }
        };
        private static /* enum */ EntryFactory STRONG_ACCESS = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongAccessEntry<void, V>(var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                2.copyAccessEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory STRONG_WRITE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongWriteEntry<void, V>(var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                3.copyWriteEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory STRONG_ACCESS_WRITE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongAccessWriteEntry<void, V>(var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                4.copyAccessEntry(original, newEntry);
                4.copyWriteEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory WEAK = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }
        };
        private static /* enum */ EntryFactory WEAK_ACCESS = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakAccessEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                6.copyAccessEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory WEAK_WRITE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakWriteEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                7.copyWriteEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static /* enum */ EntryFactory WEAK_ACCESS_WRITE = new EntryFactory(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> segment, K key, int hash, @Nullable ReferenceEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakAccessWriteEntry<void, V>(var1_1.keyReferenceQueue, var2_2, (int)var3_3, next);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
                void var1_1;
                void var2_2;
                void var3_3;
                ReferenceEntry<K, V> newEntry = super.copyEntry(segment, original, var3_3);
                8.copyAccessEntry(original, newEntry);
                8.copyWriteEntry(var2_2, newEntry);
                return var1_1;
            }
        };
        private static EntryFactory[] factories;

        private EntryFactory() {
        }

        /*
         * WARNING - void declaration
         */
        static EntryFactory getFactory(Strength keyStrength, boolean usesAccessQueue, boolean usesWriteQueue) {
            void var0_1;
            void var2_3;
            void var1_2;
            int flags = (keyStrength == Strength.WEAK ? 4 : 0) | (var1_2 != false ? 1 : 0) | (var2_3 != false ? 2 : 0);
            return factories[var0_1];
        }

        abstract <K, V> ReferenceEntry<K, V> newEntry(Segment<K, V> var1, K var2, int var3, @Nullable ReferenceEntry<K, V> var4);

        /*
         * WARNING - void declaration
         */
        <K, V> ReferenceEntry<K, V> copyEntry(Segment<K, V> segment, ReferenceEntry<K, V> original, ReferenceEntry<K, V> newNext) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.newEntry((Segment<K, V>)var1_1, original.getKey(), var2_2.getHash(), (ReferenceEntry<K, V>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        static <K, V> void copyAccessEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            ReferenceEntry<K, V> referenceEntry;
            void var1_1;
            newEntry.setAccessTime(original.getAccessTime());
            LocalCache.connectAccessOrder(original.getPreviousInAccessQueue(), newEntry);
            LocalCache.connectAccessOrder(var1_1, original.getNextInAccessQueue());
            LocalCache.nullifyAccessOrder(referenceEntry);
        }

        /*
         * WARNING - void declaration
         */
        static <K, V> void copyWriteEntry(ReferenceEntry<K, V> original, ReferenceEntry<K, V> newEntry) {
            ReferenceEntry<K, V> referenceEntry;
            void var1_1;
            newEntry.setWriteTime(original.getWriteTime());
            LocalCache.connectWriteOrder(original.getPreviousInWriteQueue(), newEntry);
            LocalCache.connectWriteOrder(var1_1, original.getNextInWriteQueue());
            LocalCache.nullifyWriteOrder(referenceEntry);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntryFactory(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            EntryFactory[] entryFactoryArray = new EntryFactory[]{STRONG, STRONG_ACCESS, STRONG_WRITE, STRONG_ACCESS_WRITE, WEAK, WEAK_ACCESS, WEAK_WRITE, WEAK_ACCESS_WRITE};
            factories = new EntryFactory[]{STRONG, STRONG_ACCESS, STRONG_WRITE, STRONG_ACCESS_WRITE, WEAK, WEAK_ACCESS, WEAK_WRITE, WEAK_ACCESS_WRITE};
        }
    }

    static abstract class Strength
    extends Enum<Strength> {
        public static final /* enum */ Strength STRONG = new Strength(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                void var3_3;
                if (weight == 1) {
                    return new StrongValueReference(value);
                }
                return new WeightedStrongValueReference(var3_3, weight);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.equals();
            }
        };
        public static final /* enum */ Strength SOFT = new Strength(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                void var2_2;
                void var3_3;
                void var1_1;
                if (weight == 1) {
                    return new SoftValueReference(segment.valueReferenceQueue, value, entry);
                }
                return new WeightedSoftValueReference(var1_1.valueReferenceQueue, var3_3, var2_2, weight);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };
        public static final /* enum */ Strength WEAK = new Strength(){

            /*
             * WARNING - void declaration
             */
            @Override
            final <K, V> ValueReference<K, V> referenceValue(Segment<K, V> segment, ReferenceEntry<K, V> entry, V value, int weight) {
                void var2_2;
                void var3_3;
                void var1_1;
                if (weight == 1) {
                    return new WeakValueReference(segment.valueReferenceQueue, value, entry);
                }
                return new WeightedWeakValueReference(var1_1.valueReferenceQueue, var3_3, var2_2, weight);
            }

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };
        private static final /* synthetic */ Strength[] $VALUES;

        public static Strength[] values() {
            return (Strength[])$VALUES.clone();
        }

        private Strength() {
        }

        abstract <K, V> ValueReference<K, V> referenceValue(Segment<K, V> var1, ReferenceEntry<K, V> var2, V var3, int var4);

        abstract Equivalence<Object> defaultEquivalence();

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Strength(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            $VALUES = new Strength[]{STRONG, SOFT, WEAK};
        }
    }
}

