/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.collect.ImmutableCollection;
import com.github.igorsuhorukov.google.common.collect.ImmutableMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableMapEntry;
import com.github.igorsuhorukov.google.common.collect.ObjectArrays;
import com.github.igorsuhorukov.google.common.collect.RegularImmutableMap;
import com.github.igorsuhorukov.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class CollectPreconditions<K, V> {
    ImmutableMapEntry.TerminalEntry<K, V>[] entries = new ImmutableMapEntry.TerminalEntry[4];
    int size = 0;

    /*
     * WARNING - void declaration
     */
    static void checkEntryNotNull(Object key, Object value) {
        void var1_1;
        if (key == null) {
            key = String.valueOf(String.valueOf(value));
            throw new NullPointerException(new StringBuilder(24 + ((String)key).length()).append("null key in entry: null=").append((String)key).toString());
        }
        if (var1_1 == null) {
            Object object;
            object = String.valueOf(String.valueOf(object));
            throw new NullPointerException(new StringBuilder(26 + ((String)object).length()).append("null value in entry: ").append((String)object).append("=null").toString());
        }
    }

    static int checkNonnegative(int value, String name) {
        int n;
        if (value < 0) {
            String string;
            string = String.valueOf(String.valueOf(string));
            throw new IllegalArgumentException(new StringBuilder(40 + string.length()).append(string).append(" cannot be negative but was: ").append(value).toString());
        }
        return n;
    }

    public CollectPreconditions() {
        this(4);
    }

    CollectPreconditions(int initialCapacity) {
    }

    /*
     * WARNING - void declaration
     */
    public CollectPreconditions<K, V> put$3841f726(K key, V value) {
        void var1_1;
        void var2_2;
        int n = this.size + 1;
        CollectPreconditions collectPreconditions = this;
        if (n > collectPreconditions.entries.length) {
            collectPreconditions.entries = ObjectArrays.arraysCopyOf(collectPreconditions.entries, ImmutableCollection.Builder.expandedCapacity(collectPreconditions.entries.length, n));
        }
        ImmutableMapEntry.TerminalEntry<K, void> entry = ImmutableMap.entryOf(key, var2_2);
        this.entries[this.size++] = var1_1;
        return this;
    }

    public ImmutableMap<K, V> build() {
        switch (this.size) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                return ImmutableMap.of(this.entries[0].getKey(), this.entries[0].getValue());
            }
        }
        return new RegularImmutableMap(this.size, this.entries);
    }

    static int computeArrayListCapacity(int arraySize) {
        int n;
        CollectPreconditions.checkNonnegative(arraySize, "arraySize");
        return Ints.saturatedCast(5L + (long)arraySize + (long)(n / 10));
    }

    public static <E> ArrayList<E> newArrayListWithExpectedSize(int estimatedSize) {
        int n;
        return new ArrayList(CollectPreconditions.computeArrayListCapacity(n));
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(Set<?> s, Object object) {
        if (s == object) {
            return true;
        }
        if (object instanceof Set) {
            Set o = (Set)object;
            try {
                void var1_1;
                Set<?> set;
                return s.size() == o.size() && set.containsAll((Collection<?>)var1_1);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return false;
    }
}

