/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.AbstractIndexedListIterator;
import com.github.igorsuhorukov.google.common.collect.ImmutableCollection;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.ObjectArrays;
import com.github.igorsuhorukov.google.common.collect.RegularImmutableList;
import com.github.igorsuhorukov.google.common.collect.SingletonImmutableList;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.Nullable;

public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    private static final ImmutableList<Object> EMPTY = new RegularImmutableList<Object>(ObjectArrays.EMPTY_ARRAY);

    public static <E> ImmutableList<E> of() {
        return EMPTY;
    }

    public static <E> ImmutableList<E> of(E element) {
        E e;
        return new SingletonImmutableList<E>(e);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2) {
        void var1_1;
        Object object;
        object = new Object[]{object, var1_1};
        object = ObjectArrays.checkElementsNotNull((Object[])object);
        return ImmutableList.asImmutableList((Object[])object, ((E)object).length);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3) {
        void var2_2;
        void var1_1;
        Object object;
        object = new Object[]{object, var1_1, var2_2};
        object = ObjectArrays.checkElementsNotNull((Object[])object);
        return ImmutableList.asImmutableList((Object[])object, ((E)object).length);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object;
        object = new Object[]{object, var1_1, var2_2, var3_3};
        object = ObjectArrays.checkElementsNotNull((Object[])object);
        return ImmutableList.asImmutableList((Object[])object, ((E)object).length);
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> elements) {
        ImmutableList immutableList;
        block6: {
            Object object;
            block2: {
                ImmutableList<E> immutableList2;
                block5: {
                    block3: {
                        ImmutableList immutableList3;
                        block4: {
                            Ascii.checkNotNull(elements);
                            if (!(elements instanceof Collection)) break block2;
                            if (!((elements = (Object[])elements) instanceof ImmutableCollection)) break block3;
                            immutableList3 = ((ImmutableCollection)elements).asList();
                            if (!immutableList3.isPartialView()) break block4;
                            elements = immutableList3.toArray();
                            immutableList2 = ImmutableList.asImmutableList(elements, elements.length);
                            break block5;
                        }
                        immutableList = immutableList3;
                        break block6;
                    }
                    elements = elements.toArray();
                    elements = ObjectArrays.checkElementsNotNull(elements);
                    immutableList2 = ImmutableList.asImmutableList(elements, elements.length);
                }
                return immutableList2;
            }
            if (!(object = object.iterator()).hasNext()) {
                return EMPTY;
            }
            Object e = object.next();
            if (!object.hasNext()) {
                return ImmutableList.of(e);
            }
            object = ((Builder)new Builder().add(e)).addAll((Iterator)object);
            immutableList = ImmutableList.asImmutableList(((Builder)object).contents, ((Builder)object).size);
        }
        return immutableList;
    }

    public static <E> ImmutableList<E> copyOf(E[] elements) {
        E[] EArray;
        switch (elements.length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return new SingletonImmutableList<E>(elements[0]);
            }
        }
        return new RegularImmutableList(ObjectArrays.checkElementsNotNull((Object[])EArray.clone()));
    }

    static <E> ImmutableList<E> asImmutableList(Object[] elements) {
        Object[] objectArray;
        return ImmutableList.asImmutableList(elements, objectArray.length);
    }

    /*
     * WARNING - void declaration
     */
    static <E> ImmutableList<E> asImmutableList(Object[] elements, int length) {
        Object[] objectArray;
        switch (length) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                elements = new SingletonImmutableList<Object>(elements[0]);
                return elements;
            }
        }
        if (length < ((Object[])elements).length) {
            void var1_1;
            elements = ObjectArrays.arraysCopyOf(elements, (int)var1_1);
        }
        return new RegularImmutableList(objectArray);
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        ImmutableList immutableList = this;
        return immutableList.listIterator(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        void var1_1;
        return new AbstractIndexedListIterator<E>(this, this.size(), (int)var1_1){
            private /* synthetic */ ImmutableList this$0;
            {
                void var3_3;
                void var2_2;
                this.this$0 = immutableList;
                super((int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final E get(int index) {
                void var1_1;
                return this.this$0.get((int)var1_1);
            }
        };
    }

    @Override
    public int indexOf(@Nullable Object object) {
        if (object != null) {
            Object object2;
            void var2_2 = object2;
            object2 = this;
            object2 = object2.listIterator();
            while (object2.hasNext()) {
                if (!Ascii.equal(var2_2, object2.next())) continue;
                return object2.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        if (object != null) {
            Object object2;
            void var2_2 = object2;
            object2 = this;
            object2 = object2.listIterator(object2.size());
            while (object2.hasPrevious()) {
                if (!Ascii.equal(var2_2, object2.previous())) continue;
                return object2.nextIndex();
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(@Nullable Object object) {
        void var1_1;
        return this.indexOf(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        Ascii.checkPositionIndexes(fromIndex, toIndex, this.size());
        int n = toIndex - fromIndex;
        switch (n) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return ImmutableList.of(this.get(fromIndex));
            }
        }
        return this.subListUnchecked((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        return new SubList(this, fromIndex, (int)(var2_2 - var1_1));
    }

    @Override
    @Deprecated
    public final boolean addAll(int index, Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ImmutableList<E> asList() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int copyIntoArray(Object[] dst, int offset) {
        void var3_3;
        void var2_2;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            dst[offset + i] = this.get(i);
        }
        return (int)(var2_2 + var3_3);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        ImmutableList immutableList;
        List list = immutableList;
        if (list == Ascii.checkNotNull(immutableList = this)) {
            return true;
        }
        if (list instanceof List) {
            list = list;
            if (immutableList.size() == list.size() && Iterators.elementsEqual(immutableList.iterator(), list.iterator())) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int hashCode = 1;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            hashCode = hashCode * 31 + this.get(i).hashCode();
            hashCode = ~(~hashCode);
        }
        return (int)var1_1;
    }

    public static final class Builder<E>
    extends ImmutableCollection.ArrayBasedBuilder<E> {
        public Builder() {
            this(4);
        }

        private Builder(int capacity) {
            super(4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> add(E element) {
            void var1_1;
            super.add((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> addAll(Iterator<? extends E> elements) {
            void var1_1;
            super.addAll(var1_1);
            return this;
        }
    }

    final class SubList
    extends ImmutableList<E> {
        private transient int offset;
        private transient int length;
        private /* synthetic */ ImmutableList this$0;

        /*
         * WARNING - void declaration
         */
        SubList(ImmutableList immutableList, int offset, int length) {
            void var3_3;
            void var2_2;
            this.this$0 = immutableList;
            this.offset = var2_2;
            this.length = var3_3;
        }

        @Override
        public final int size() {
            return this.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final E get(int index) {
            void var1_1;
            Ascii.checkElementIndex(index, this.length);
            return this.this$0.get((int)(var1_1 + this.offset));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ImmutableList<E> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            Ascii.checkPositionIndexes(fromIndex, toIndex, this.length);
            return this.this$0.subList((int)(var1_1 + this.offset), (int)(var2_2 + this.offset));
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }
}

