/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.collect.CollectPreconditions;
import com.github.igorsuhorukov.google.common.collect.ImmutableBiMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableCollection;
import com.github.igorsuhorukov.google.common.collect.ImmutableEnumMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableMapEntry;
import com.github.igorsuhorukov.google.common.collect.ImmutableMapKeySet;
import com.github.igorsuhorukov.google.common.collect.ImmutableMapValues;
import com.github.igorsuhorukov.google.common.collect.ImmutableSet;
import com.github.igorsuhorukov.google.common.collect.ImmutableSortedMap;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.collect.RegularImmutableMap;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ImmutableMap<K, V>
implements Serializable,
Map<K, V> {
    private static final Map.Entry<?, ?>[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;

    public static <K, V> ImmutableMap<K, V> of() {
        return ImmutableBiMap.of();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        void var1_1;
        return ImmutableBiMap.of(k1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableMapEntry.TerminalEntry<K, V> entryOf(K key, V value) {
        void var1_1;
        K k;
        CollectPreconditions.checkEntryNotNull(key, value);
        return new ImmutableMapEntry.TerminalEntry<K, void>(k, var1_1);
    }

    public static <K, V> CollectPreconditions<K, V> builder$3fa3e7a2() {
        return new CollectPreconditions();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        void var1_1;
        if (map instanceof ImmutableMap && !(map instanceof ImmutableSortedMap)) {
            ImmutableMap kvMap = (ImmutableMap)((Object)map);
            if (!kvMap.isPartialView()) {
                return kvMap;
            }
        } else if (map instanceof EnumMap) {
            map = map;
            map = new EnumMap(map);
            for (Map.Entry entry : map.entrySet()) {
                CollectPreconditions.checkEntryNotNull(entry.getKey(), entry.getValue());
            }
            return ImmutableEnumMap.asImmutable(map);
        }
        Object entries = map.entrySet().toArray(EMPTY_ENTRY_ARRAY);
        switch (((Map.Entry<?, ?>[])entries).length) {
            case 0: {
                return ImmutableBiMap.of();
            }
            case 1: {
                Map.Entry<?, ?> entry;
                Map.Entry<?, ?> onlyEntry = entries[0];
                entries = entry.getValue();
                entry = onlyEntry.getKey();
                return ImmutableBiMap.of(entry, entries);
            }
        }
        return new RegularImmutableMap((Map.Entry<?, ?>[])var1_1);
    }

    ImmutableMap() {
    }

    @Override
    @Deprecated
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(@Nullable Object key) {
        void var1_1;
        return this.get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(@Nullable Object value) {
        void var1_1;
        return ((ImmutableCollection)this.values()).contains(var1_1);
    }

    @Override
    public abstract V get(@Nullable Object var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        void var1_1;
        ImmutableSet<Map.Entry<K, V>> result = this.entrySet;
        if (result == null) {
            this.entrySet = this.createEntrySet();
            return this.entrySet;
        }
        return var1_1;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSet<K> keySet() {
        void var1_1;
        ImmutableSet<K> result = this.keySet;
        if (result == null) {
            this.keySet = this.createKeySet();
            return this.keySet;
        }
        return var1_1;
    }

    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableCollection<V> values() {
        void var1_1;
        ImmutableCollection<V> result = this.values;
        if (result == null) {
            this.values = new ImmutableMapValues(this);
            return this.values;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(@Nullable Object object) {
        void var1_1;
        return Maps.equalsImpl(this, var1_1);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return ((ImmutableSet)this.entrySet()).hashCode();
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }
}

