/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.EmptyImmutableSortedMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableCollection;
import com.github.igorsuhorukov.google.common.collect.ImmutableSet;
import com.github.igorsuhorukov.google.common.collect.ImmutableSortedMapFauxverideShim;
import com.github.igorsuhorukov.google.common.collect.ImmutableSortedSet;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.google.common.collect.Ordering;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import javax.annotation.Nullable;

public abstract class ImmutableSortedMap<K, V>
extends ImmutableSortedMapFauxverideShim<K, V>
implements NavigableMap<K, V> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private transient ImmutableSortedMap<K, V> descendingMap;

    ImmutableSortedMap() {
    }

    /*
     * WARNING - void declaration
     */
    ImmutableSortedMap(ImmutableSortedMap<K, V> descendingMap) {
        void var1_1;
        this.descendingMap = var1_1;
    }

    @Override
    public int size() {
        return ((AbstractCollection)this.values()).size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(@Nullable Object value) {
        void var1_1;
        return ((ImmutableCollection)this.values()).contains(var1_1);
    }

    @Override
    boolean isPartialView() {
        return this.keySet().isPartialView() || ((ImmutableCollection)this.values()).isPartialView();
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return super.entrySet();
    }

    @Override
    public abstract ImmutableSortedSet<K> keySet();

    @Override
    public abstract ImmutableCollection<V> values();

    @Override
    public Comparator<? super K> comparator() {
        return ((ImmutableSortedSet)this.keySet()).comparator();
    }

    @Override
    public K firstKey() {
        return (K)((ImmutableSortedSet)this.keySet()).first();
    }

    @Override
    public K lastKey() {
        return (K)((ImmutableSortedSet)this.keySet()).last();
    }

    public abstract ImmutableSortedMap<K, V> headMap$18f13784(K var1);

    /*
     * WARNING - void declaration
     */
    @Override
    private ImmutableSortedMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        void var1_1;
        void var3_3;
        Ascii.checkNotNull(fromKey);
        Ascii.checkNotNull(toKey);
        Ascii.checkArgument(this.comparator().compare(fromKey, toKey) <= 0, "expected fromKey <= toKey but %s > %s", fromKey, toKey);
        return this.headMap$18f13784(var3_3).tailMap$18f13784(var1_1);
    }

    public abstract ImmutableSortedMap<K, V> tailMap$18f13784(K var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        void var1_1;
        return this.headMap$18f13784(var1_1).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K lowerKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.lowerEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        void var1_1;
        return this.headMap$18f13784(var1_1).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K floorKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.floorEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        void var1_1;
        return this.tailMap$18f13784(var1_1).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K ceilingKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.ceilingEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        void var1_1;
        return this.tailMap$18f13784(var1_1).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K higherKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.higherEntry(var1_1));
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return (Map.Entry)((ImmutableCollection)((Object)this.entrySet())).asList().get(0);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return (Map.Entry)((ImmutableCollection)((Object)this.entrySet())).asList().get(this.size() - 1);
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    abstract ImmutableSortedMap<K, V> createDescendingMap();

    static {
        new EmptyImmutableSortedMap(NATURAL_ORDER);
    }
}

