/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.base.Optional;
import com.github.igorsuhorukov.google.common.base.Predicate;
import com.github.igorsuhorukov.google.common.collect.AbstractIterator;
import com.github.igorsuhorukov.google.common.collect.CollectPreconditions;
import com.github.igorsuhorukov.google.common.collect.Collections2;
import com.github.igorsuhorukov.google.common.collect.FluentIterable;
import com.github.igorsuhorukov.google.common.collect.ImmutableCollection;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.Multiset;
import com.github.igorsuhorukov.google.common.collect.ObjectArrays;
import com.github.igorsuhorukov.google.common.collect.TransformedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import javax.annotation.Nullable;

public final class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> unmodifiableIterable(Iterable<T> iterable) {
        Iterable<T> iterable2;
        Ascii.checkNotNull(iterable);
        if (iterable instanceof UnmodifiableIterable || iterable instanceof ImmutableCollection) {
            return iterable;
        }
        return new UnmodifiableIterable(iterable2, 0);
    }

    @Deprecated
    public static <E> Iterable<E> unmodifiableIterable(ImmutableCollection<E> iterable) {
        return Ascii.checkNotNull(iterable);
    }

    public static int size(Iterable<?> iterable) {
        Iterable<?> iterable2;
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return Iterators.size(iterable2.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(Iterable<?> iterable, @Nullable Object element) {
        void var1_1;
        Iterable<?> iterable2;
        if (iterable instanceof Collection) {
            iterable = iterable;
            return Collections2.safeContains(iterable, element);
        }
        return Iterators.contains(iterable2.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean removeAll(Iterable<?> removeFrom, Collection<?> elementsToRemove) {
        void var1_1;
        Iterable<?> iterable;
        if (removeFrom instanceof Collection) {
            return ((Collection)removeFrom).removeAll(Ascii.checkNotNull(elementsToRemove));
        }
        return Iterators.removeAll(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean retainAll(Iterable<?> removeFrom, Collection<?> elementsToRetain) {
        void var1_1;
        Iterable<?> iterable;
        if (removeFrom instanceof Collection) {
            return ((Collection)removeFrom).retainAll(Ascii.checkNotNull(elementsToRetain));
        }
        return Iterators.retainAll(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean removeIf(Iterable<T> removeFrom, Predicate<? super T> predicate) {
        void var1_1;
        Iterable<T> iterable;
        if (removeFrom instanceof RandomAccess && removeFrom instanceof List) {
            return Iterables.removeIfFromRandomAccessList((List)removeFrom, Ascii.checkNotNull(predicate));
        }
        return Iterators.removeIf(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> boolean removeIfFromRandomAccessList(List<T> list, Predicate<? super T> predicate) {
        void var3_3;
        void var2_2;
        List<T> list2;
        int to = 0;
        for (int from = 0; from < list.size(); ++from) {
            T element = list.get(from);
            if (predicate.apply(element)) continue;
            if (from > to) {
                try {
                    list.set(to, element);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Iterables.slowRemoveIfForRemainingElements(list, predicate, to, from);
                    return true;
                }
            }
            ++to;
        }
        list.subList(to, list2.size()).clear();
        return var2_2 != var3_3;
    }

    private static <T> void slowRemoveIfForRemainingElements(List<T> list, Predicate<? super T> predicate, int to, int from) {
        int n;
        for (n = list.size() - 1; n > from; --n) {
            if (!predicate.apply(list.get(n))) continue;
            list.remove(n);
        }
        for (n = var3_3 - true; n >= to; --n) {
            list.remove(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    static <T> T removeFirstMatching(Iterable<T> removeFrom, Predicate<? super T> predicate) {
        Ascii.checkNotNull(predicate);
        Iterator<T> iterator = removeFrom.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object next = iterator.next();
            if (!predicate.apply(next)) continue;
            iterator.remove();
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean elementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        void var1_1;
        Iterable<?> iterable;
        if (iterable1 instanceof Collection && iterable2 instanceof Collection) {
            void var3_3;
            void var2_2;
            Collection collection1 = (Collection)iterable1;
            Collection collection2 = (Collection)iterable2;
            if (var2_2.size() != var3_3.size()) {
                return false;
            }
        }
        return Iterators.elementsEqual(iterable.iterator(), var1_1.iterator());
    }

    public static String toString(Iterable<?> iterable) {
        return Iterators.toString(iterable.iterator());
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T getOnlyElement(Iterable<? extends T> iterable, @Nullable T defaultValue) {
        void var1_1;
        return Iterators.getOnlyElement(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        void var1_1;
        Iterable<T> iterable2;
        Iterable<T> collection = Iterables.toCollection(iterable);
        T[] array = ObjectArrays.newArray(type, collection.size());
        return iterable2.toArray((T[])var1_1);
    }

    static Object[] toArray(Iterable<?> iterable) {
        return Iterables.toCollection(iterable).toArray();
    }

    private static <E> Collection<E> toCollection(Iterable<E> iterable) {
        Iterator<E> iterator;
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        iterator = iterator.iterator();
        ArrayList arrayList = new ArrayList();
        Iterators.addAll(arrayList, iterator);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        Collection<T> collection;
        void var1_1;
        if (elementsToAdd instanceof Collection) {
            Collection<? extends T> c = Collections2.cast(elementsToAdd);
            return addTo.addAll((Collection<T>)var1_1);
        }
        return Iterators.addAll(collection, ((Iterable)Ascii.checkNotNull(var1_1)).iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static int frequency(Iterable<?> iterable, @Nullable Object element) {
        void var1_1;
        Iterable<?> iterable2;
        if (iterable instanceof Multiset) {
            return ((Multiset)iterable).count$5d527804();
        }
        if (iterable instanceof Set) {
            if (((Set)iterable).contains(element)) {
                return 1;
            }
            return 0;
        }
        return Iterators.frequency(iterable2.iterator(), var1_1);
    }

    public static <T> Iterable<T> cycle(Iterable<T> iterable) {
        Iterable<T> iterable2;
        Ascii.checkNotNull(iterable);
        return new FluentIterable<T>(iterable2){
            private /* synthetic */ Iterable val$iterable;
            {
                this.val$iterable = iterable;
            }

            @Override
            public final Iterator<T> iterator() {
                return Iterators.cycle(this.val$iterable);
            }

            @Override
            public final String toString() {
                return String.valueOf(this.val$iterable.toString()).concat(" (cycled)");
            }
        };
    }

    public static <T> Iterable<T> cycle(T ... elements) {
        T[] TArray = elements;
        Ascii.checkNotNull(elements);
        int n = CollectPreconditions.computeArrayListCapacity(TArray.length);
        ArrayList arrayList = new ArrayList(n);
        Collections.addAll(arrayList, TArray);
        return Iterables.cycle(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        void var1_1;
        return Iterables.concat(ImmutableList.of(a, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c) {
        void var2_2;
        void var1_1;
        return Iterables.concat(ImmutableList.of(a, var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c, Iterable<? extends T> d) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Iterables.concat(ImmutableList.of(a, var1_1, var2_2, var3_3));
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> ... inputs) {
        return Iterables.concat(ImmutableList.copyOf(inputs));
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> inputs) {
        Iterable<? extends Iterable<? extends T>> iterable;
        Ascii.checkNotNull(inputs);
        return new FluentIterable<T>(iterable){
            private /* synthetic */ Iterable val$inputs;
            {
                this.val$inputs = iterable;
            }

            @Override
            public final Iterator<T> iterator() {
                return Iterators.concat(Iterables.iterators(this.val$inputs));
            }
        };
    }

    private static <T> Iterator<Iterator<? extends T>> iterators(Iterable<? extends Iterable<? extends T>> iterables) {
        Iterable<Iterable<T>> iterable;
        return new TransformedIterator<Iterable<? extends T>, Iterator<? extends T>>(iterable.iterator()){
            {
                void var1_1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<List<T>> partition(Iterable<T> iterable, int size) {
        void var1_1;
        Iterable<T> iterable2;
        Ascii.checkNotNull(iterable);
        Ascii.checkArgument(size > 0);
        return new FluentIterable<List<T>>(iterable2, (int)var1_1){
            private /* synthetic */ Iterable val$iterable;
            private /* synthetic */ int val$size;
            {
                this.val$iterable = iterable;
                this.val$size = n;
            }

            @Override
            public final Iterator<List<T>> iterator() {
                return Iterators.partition(this.val$iterable.iterator(), this.val$size);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<List<T>> paddedPartition(Iterable<T> iterable, int size) {
        void var1_1;
        Iterable<T> iterable2;
        Ascii.checkNotNull(iterable);
        Ascii.checkArgument(size > 0);
        return new FluentIterable<List<T>>(iterable2, (int)var1_1){
            private /* synthetic */ Iterable val$iterable;
            private /* synthetic */ int val$size;
            {
                this.val$iterable = iterable;
                this.val$size = n;
            }

            @Override
            public final Iterator<List<T>> iterator() {
                return Iterators.paddedPartition(this.val$iterable.iterator(), this.val$size);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> filter(Iterable<T> unfiltered, Predicate<? super T> predicate) {
        void var1_1;
        Iterable<T> iterable;
        Ascii.checkNotNull(unfiltered);
        Ascii.checkNotNull(predicate);
        return new FluentIterable<T>(iterable, (Predicate)var1_1){
            private /* synthetic */ Iterable val$unfiltered;
            private /* synthetic */ Predicate val$predicate;
            {
                this.val$unfiltered = iterable;
                this.val$predicate = predicate;
            }

            @Override
            public final Iterator<T> iterator() {
                return Iterators.filter(this.val$unfiltered.iterator(), this.val$predicate);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> filter(Iterable<?> unfiltered, Class<T> type) {
        void var1_1;
        Iterable<?> iterable;
        Ascii.checkNotNull(unfiltered);
        Ascii.checkNotNull(type);
        return new FluentIterable<T>(iterable, (Class)var1_1){
            private /* synthetic */ Iterable val$unfiltered;
            private /* synthetic */ Class val$type;
            {
                this.val$unfiltered = iterable;
                this.val$type = clazz;
            }

            @Override
            public final Iterator<T> iterator() {
                return Iterators.filter(this.val$unfiltered.iterator(), this.val$type);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean any(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.any(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean all(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.all(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T find(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.find(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T find(Iterable<? extends T> iterable, Predicate<? super T> predicate, @Nullable T defaultValue) {
        void var2_2;
        void var1_1;
        return Iterators.find(iterable.iterator(), var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Optional<T> tryFind(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.tryFind(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int indexOf(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.indexOf(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> Iterable<T> transform(Iterable<F> fromIterable, Function<? super F, ? extends T> function) {
        void var1_1;
        Iterable<F> iterable;
        Ascii.checkNotNull(fromIterable);
        Ascii.checkNotNull(function);
        return new FluentIterable<T>(iterable, (Function)var1_1){
            private /* synthetic */ Iterable val$fromIterable;
            private /* synthetic */ Function val$function;
            {
                this.val$fromIterable = iterable;
                this.val$function = function;
            }

            @Override
            public final Iterator<T> iterator() {
                return Iterators.transform(this.val$fromIterable.iterator(), this.val$function);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(Iterable<T> iterable, int position) {
        void var1_1;
        Iterable<T> iterable2;
        Ascii.checkNotNull(iterable);
        if (iterable instanceof List) {
            return (T)((List)iterable).get(position);
        }
        return Iterators.get(iterable2.iterator(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T get(Iterable<? extends T> iterable, int position, @Nullable T defaultValue) {
        void var2_2;
        List list;
        void var1_1;
        List list2;
        Ascii.checkNotNull(iterable);
        Iterators.checkNonnegative(position);
        if (iterable instanceof List) {
            list2 = (List)iterable;
            if (position < list2.size()) {
                return (T)list2.get(position);
            }
            return defaultValue;
        }
        List iterator = list2.iterator();
        Iterators.advance(iterator, (int)var1_1);
        return Iterators.getNext(list, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T getFirst(Iterable<? extends T> iterable, @Nullable T defaultValue) {
        void var1_1;
        return Iterators.getNext(iterable.iterator(), var1_1);
    }

    public static <T> T getLast(Iterable<T> iterable) {
        List list;
        if (iterable instanceof List) {
            List list2 = (List)iterable;
            if (list2.isEmpty()) {
                throw new NoSuchElementException();
            }
            return Iterables.getLastInNonemptyList(list);
        }
        return Iterators.getLast(list.iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T getLast(Iterable<? extends T> iterable, @Nullable T defaultValue) {
        void var1_1;
        Iterable<T> iterable2;
        if (iterable instanceof Collection) {
            Collection<T> collection = Collections2.cast(iterable);
            if (collection.isEmpty()) {
                return defaultValue;
            }
            if (iterable instanceof List) {
                return Iterables.getLastInNonemptyList((List)iterable);
            }
        }
        return Iterators.getLast(iterable2.iterator(), var1_1);
    }

    private static <T> T getLastInNonemptyList(List<T> list) {
        List<T> list2;
        return list.get(list2.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> skip(Iterable<T> iterable, int numberToSkip) {
        void var1_1;
        List list;
        Ascii.checkNotNull(iterable);
        Ascii.checkArgument(numberToSkip >= 0, "number to skip cannot be negative");
        if (iterable instanceof List) {
            List list2 = (List)iterable;
            return new FluentIterable<T>(list, numberToSkip){
                private /* synthetic */ List val$list;
                private /* synthetic */ int val$numberToSkip;
                {
                    this.val$list = list;
                    this.val$numberToSkip = n;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Iterator<T> iterator() {
                    void var1_1;
                    int toSkip = Math.min(this.val$list.size(), this.val$numberToSkip);
                    return this.val$list.subList((int)var1_1, this.val$list.size()).iterator();
                }
            };
        }
        return new FluentIterable<T>(list, (int)var1_1){
            private /* synthetic */ Iterable val$iterable;
            private /* synthetic */ int val$numberToSkip;
            {
                this.val$iterable = iterable;
                this.val$numberToSkip = n;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final Iterator<T> iterator() {
                void var1_1;
                Iterator iterator = this.val$iterable.iterator();
                Iterators.advance(iterator, this.val$numberToSkip);
                return new Iterator<T>(this, (Iterator)var1_1){
                    private boolean atStart = true;
                    private /* synthetic */ Iterator val$iterator;
                    {
                        this.val$iterator = iterator;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.val$iterator.hasNext();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final T next() {
                        void var1_1;
                        Object result = this.val$iterator.next();
                        this.atStart = false;
                        return var1_1;
                    }

                    @Override
                    public final void remove() {
                        boolean bl = !this.atStart;
                        Ascii.checkState(bl, "no calls to next() since the last call to remove()");
                        this.val$iterator.remove();
                    }
                };
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> limit(Iterable<T> iterable, int limitSize) {
        void var1_1;
        Iterable<T> iterable2;
        Ascii.checkNotNull(iterable);
        Ascii.checkArgument(limitSize >= 0, "limit is negative");
        return new FluentIterable<T>(iterable2, (int)var1_1){
            private /* synthetic */ Iterable val$iterable;
            private /* synthetic */ int val$limitSize;
            {
                this.val$iterable = iterable;
                this.val$limitSize = n;
            }

            @Override
            public final Iterator<T> iterator() {
                return Iterators.limit(this.val$iterable.iterator(), this.val$limitSize);
            }
        };
    }

    public static <T> Iterable<T> consumingIterable(Iterable<T> iterable) {
        Iterable<T> iterable2;
        if (iterable instanceof Queue) {
            return new FluentIterable<T>(iterable){
                private /* synthetic */ Iterable val$iterable;
                {
                    this.val$iterable = iterable;
                }

                @Override
                public final Iterator<T> iterator() {
                    return new ConsumingQueueIterator((Queue)this.val$iterable, 0);
                }

                @Override
                public final String toString() {
                    return "Iterables.consumingIterable(...)";
                }
            };
        }
        Ascii.checkNotNull(iterable);
        return new FluentIterable<T>(iterable2){
            private /* synthetic */ Iterable val$iterable;
            {
                this.val$iterable = iterable;
            }

            @Override
            public final Iterator<T> iterator() {
                return Iterators.consumingIterator(this.val$iterable.iterator());
            }

            @Override
            public final String toString() {
                return "Iterables.consumingIterable(...)";
            }
        };
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        Iterable<?> iterable2;
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable2.iterator().hasNext();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> mergeSorted(Iterable<? extends Iterable<? extends T>> iterables, Comparator<? super T> comparator) {
        FluentIterable fluentIterable;
        void var1_1;
        Ascii.checkNotNull(iterables, "iterables");
        Ascii.checkNotNull(comparator, "comparator");
        FluentIterable iterable = new FluentIterable<T>(iterables, (Comparator)var1_1){
            private /* synthetic */ Iterable val$iterables;
            private /* synthetic */ Comparator val$comparator;
            {
                this.val$iterables = iterable;
                this.val$comparator = comparator;
            }

            @Override
            public final Iterator<T> iterator() {
                return Iterators.mergeSorted(Iterables.transform(this.val$iterables, Iterables.toIterator()), this.val$comparator);
            }
        };
        return new UnmodifiableIterable(fluentIterable, 0);
    }

    private static <T> Function<Iterable<? extends T>, Iterator<? extends T>> toIterator() {
        return new Function<Iterable<? extends T>, Iterator<? extends T>>(){};
    }

    static final class ConsumingQueueIterator<T>
    extends AbstractIterator<T> {
        private final Queue<T> queue;

        /*
         * WARNING - void declaration
         */
        private ConsumingQueueIterator(Queue<T> queue) {
            void var1_1;
            this.queue = var1_1;
        }

        @Override
        public final T computeNext() {
            try {
                return this.queue.remove();
            }
            catch (NoSuchElementException noSuchElementException) {
                return this.endOfData();
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ConsumingQueueIterator(Queue x0, byte by) {
            this((Queue<T>)var1_1);
            void var1_1;
        }
    }

    static final class UnmodifiableIterable<T>
    extends FluentIterable<T> {
        private final Iterable<T> iterable;

        /*
         * WARNING - void declaration
         */
        private UnmodifiableIterable(Iterable<T> iterable) {
            void var1_1;
            this.iterable = var1_1;
        }

        @Override
        public final Iterator<T> iterator() {
            return Iterators.unmodifiableIterator(this.iterable.iterator());
        }

        @Override
        public final String toString() {
            return this.iterable.toString();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ UnmodifiableIterable(Iterable x0, byte by) {
            this((Iterable<T>)var1_1);
            void var1_1;
        }
    }
}

