/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableListIterator;
import javax.annotation.Nullable;

final class RegularImmutableList<E>
extends ImmutableList<E> {
    private final transient int offset;
    private final transient int size;
    private final transient Object[] array;

    /*
     * WARNING - void declaration
     */
    private RegularImmutableList(Object[] array, int offset, int size) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.offset = var2_2;
        this.size = var3_3;
        this.array = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    RegularImmutableList(Object[] array) {
        this(array, 0, ((void)var1_1).length);
        void var1_1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    final boolean isPartialView() {
        return this.size != this.array.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int copyIntoArray(Object[] dst, int dstOff) {
        void var2_2;
        void var1_1;
        System.arraycopy(this.array, this.offset, var1_1, dstOff, this.size);
        return (int)(var2_2 + this.size);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E get(int index) {
        void var1_1;
        Ascii.checkElementIndex(index, this.size);
        return (E)this.array[var1_1 + this.offset];
    }

    @Override
    public final int indexOf(@Nullable Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.array[this.offset + i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(@Nullable Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = this.size - 1; i >= 0; --i) {
            if (!this.array[this.offset + i].equals(object)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        return new RegularImmutableList<E>(this.array, this.offset + fromIndex, (int)(var2_2 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final UnmodifiableListIterator<E> listIterator(int index) {
        void var1_1;
        return Iterators.forArray(this.array, this.offset, this.size, (int)var1_1);
    }
}

