/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.collect.CollectPreconditions;
import com.github.igorsuhorukov.google.common.collect.Hashing;
import com.github.igorsuhorukov.google.common.collect.ImmutableEntry;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.ImmutableMap;
import com.github.igorsuhorukov.google.common.collect.ImmutableMapEntry;
import com.github.igorsuhorukov.google.common.collect.ImmutableMapEntrySet;
import com.github.igorsuhorukov.google.common.collect.ImmutableSet;
import com.github.igorsuhorukov.google.common.collect.RegularImmutableAsList;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import javax.annotation.Nullable;

final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient ImmutableMapEntry<K, V>[] entries;
    private final transient ImmutableMapEntry<K, V>[] table;
    private final transient int mask;

    /*
     * WARNING - void declaration
     */
    RegularImmutableMap(int size, ImmutableMapEntry.TerminalEntry<?, ?>[] theEntries) {
        int tableSize;
        int n = size;
        this.entries = new ImmutableMapEntry[n];
        n = tableSize = Hashing.closedTableSize(size, 1.2);
        this.table = new ImmutableMapEntry[n];
        this.mask = tableSize - 1;
        for (int entryIndex = 0; entryIndex < size; ++entryIndex) {
            void var3_4;
            ImmutableMapEntry.TerminalEntry<?, ?> entry = theEntries[entryIndex];
            Object key = entry.getKey();
            int tableIndex = Hashing.smear(key.hashCode()) & this.mask;
            ImmutableMapEntry<K, V> existing = this.table[tableIndex];
            ImmutableMapEntry newEntry = existing == null ? entry : new NonTerminalMapEntry((ImmutableMapEntry<?, ?>)entry, existing);
            this.table[tableIndex] = newEntry;
            this.entries[entryIndex] = newEntry;
            RegularImmutableMap.checkNoConflictInBucket(key, var3_4, existing);
        }
    }

    /*
     * WARNING - void declaration
     */
    RegularImmutableMap(Map.Entry<?, ?>[] theEntries) {
        int tableSize;
        int size;
        int n = size = theEntries.length;
        this.entries = new ImmutableMapEntry[n];
        n = tableSize = Hashing.closedTableSize(size, 1.2);
        this.table = new ImmutableMapEntry[n];
        this.mask = tableSize - 1;
        for (int entryIndex = 0; entryIndex < size; ++entryIndex) {
            void var3_4;
            Map.Entry<?, ?> entry = theEntries[entryIndex];
            Object key = entry.getKey();
            Object value = entry.getValue();
            CollectPreconditions.checkEntryNotNull(key, value);
            int tableIndex = Hashing.smear(key.hashCode()) & this.mask;
            ImmutableMapEntry<K, V> existing = this.table[tableIndex];
            ImmutableMapEntry newEntry = existing == null ? new ImmutableMapEntry.TerminalEntry(key, value) : new NonTerminalMapEntry(key, value, existing);
            this.table[tableIndex] = newEntry;
            this.entries[entryIndex] = newEntry;
            RegularImmutableMap.checkNoConflictInBucket(key, var3_4, existing);
        }
    }

    private static void checkNoConflictInBucket(K key, ImmutableMapEntry<K, V> entry, ImmutableMapEntry<K, V> bucketHead) {
        while (bucketHead != null) {
            ImmutableMapEntry immutableMapEntry = bucketHead;
            ImmutableMapEntry immutableMapEntry2 = entry;
            String string = "key";
            boolean bl = !key.equals(((ImmutableEntry)bucketHead).getKey());
            if (!bl) {
                key = String.valueOf(String.valueOf(string));
                entry = String.valueOf(String.valueOf(immutableMapEntry2));
                bucketHead = String.valueOf(String.valueOf(immutableMapEntry));
                throw new IllegalArgumentException(new StringBuilder(34 + ((String)key).length() + ((String)entry).length() + ((String)bucketHead).length()).append("Multiple entries with same ").append((String)key).append(": ").append((String)entry).append(" and ").append((String)bucketHead).toString());
            }
            bucketHead = ((ImmutableMapEntry)bucketHead).getNextInKeyBucket();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int index = Hashing.smear(key.hashCode()) & this.mask;
        for (ImmutableMapEntry<K, V> entry = this.table[index]; entry != null; entry = entry.getNextInKeyBucket()) {
            void var3_4;
            Object candidateKey = entry.getKey();
            if (!key.equals(var3_4)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public final int size() {
        return this.entries.length;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new EntrySet(this, 0);
    }

    final class EntrySet
    extends ImmutableMapEntrySet<K, V> {
        private /* synthetic */ RegularImmutableMap this$0;

        private EntrySet(RegularImmutableMap regularImmutableMap) {
            this.this$0 = regularImmutableMap;
        }

        @Override
        final ImmutableMap<K, V> map() {
            return this.this$0;
        }

        @Override
        public final UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        final ImmutableList<Map.Entry<K, V>> createAsList() {
            return new RegularImmutableAsList(this, this.this$0.entries);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntrySet(RegularImmutableMap x0, byte by) {
            this((RegularImmutableMap)var1_1);
            void var1_1;
        }
    }

    static final class NonTerminalMapEntry<K, V>
    extends ImmutableMapEntry<K, V> {
        private final ImmutableMapEntry<K, V> nextInKeyBucket;

        /*
         * WARNING - void declaration
         */
        NonTerminalMapEntry(K key, V value, ImmutableMapEntry<K, V> nextInKeyBucket) {
            super(var1_1, var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.nextInKeyBucket = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        NonTerminalMapEntry(ImmutableMapEntry<K, V> contents, ImmutableMapEntry<K, V> nextInKeyBucket) {
            super(var1_1);
            void var2_2;
            void var1_1;
            this.nextInKeyBucket = var2_2;
        }

        @Override
        final ImmutableMapEntry<K, V> getNextInKeyBucket() {
            return this.nextInKeyBucket;
        }
    }
}

