/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.collect;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.ImmutableSet;
import com.github.igorsuhorukov.google.common.collect.Iterators;
import com.github.igorsuhorukov.google.common.collect.UnmodifiableIterator;
import java.util.Set;
import javax.annotation.Nullable;

final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    private transient E element;
    private transient int cachedHashCode;

    /*
     * WARNING - void declaration
     */
    SingletonImmutableSet(E element) {
        void var1_1;
        this.element = Ascii.checkNotNull(var1_1);
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object target) {
        void var1_1;
        return this.element.equals(var1_1);
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        dst[offset] = this.element;
        return (int)(var2_2 + true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Set) {
            void var1_1;
            Set that = (Set)object;
            return that.size() == 1 && this.element.equals(var1_1.iterator().next());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        int code = this.cachedHashCode;
        if (code == 0) {
            this.cachedHashCode = code = this.element.hashCode();
        }
        return (int)var1_1;
    }

    @Override
    final boolean isHashCodeFast() {
        return this.cachedHashCode != 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        String elementToString = this.element.toString();
        return new StringBuilder(elementToString.length() + 2).append('[').append((String)var1_1).append(']').toString();
    }
}

