/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.google.common.util.concurrent;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Function;
import com.github.igorsuhorukov.google.common.collect.Ordering;
import com.github.igorsuhorukov.google.common.util.concurrent.AbstractFuture;
import com.github.igorsuhorukov.google.common.util.concurrent.AsyncFunction;
import com.github.igorsuhorukov.google.common.util.concurrent.ListenableFuture;
import com.github.igorsuhorukov.google.common.util.concurrent.MoreExecutors$DirectExecutor;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class Futures {
    public static <V> ListenableFuture<V> immediateFuture(@Nullable V value) {
        V v;
        return new ImmediateSuccessfulFuture<V>(v);
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Throwable throwable2;
        Ascii.checkNotNull(throwable);
        return new ImmediateFailedFuture(throwable2);
    }

    /*
     * WARNING - void declaration
     */
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        void var1_1;
        ListenableFuture<I> listenableFuture;
        Ascii.checkNotNull(function);
        ChainingListenableFuture output = new ChainingListenableFuture(new AsyncFunction<I, O>(function){
            private /* synthetic */ Function val$function;
            {
                this.val$function = function;
            }

            @Override
            public final ListenableFuture<O> apply(I input) {
                Object t;
                t = this.val$function.apply(t);
                return Futures.immediateFuture(t);
            }
        }, input, 0);
        listenableFuture.addListener(output, MoreExecutors$DirectExecutor.INSTANCE);
        return var1_1;
    }

    static {
        new AsyncFunction<ListenableFuture<Object>, Object>(){};
        Ordering.natural().onResultOf(new Function<Constructor<?>, Boolean>(){}).reverse();
    }

    static final class ChainingListenableFuture<I, O>
    extends AbstractFuture<O>
    implements Runnable {
        private AsyncFunction<? super I, ? extends O> function;
        private ListenableFuture<? extends I> inputFuture;
        private volatile ListenableFuture<? extends O> outputFuture;

        /*
         * WARNING - void declaration
         */
        private ChainingListenableFuture(AsyncFunction<? super I, ? extends O> function, ListenableFuture<? extends I> inputFuture) {
            void var2_2;
            void var1_1;
            this.function = (AsyncFunction)Ascii.checkNotNull(var1_1);
            this.inputFuture = (ListenableFuture)Ascii.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            if (super.cancel(mayInterruptIfRunning)) {
                void var1_1;
                ChainingListenableFuture.cancel(this.inputFuture, mayInterruptIfRunning);
                ChainingListenableFuture.cancel(this.outputFuture, (boolean)var1_1);
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static void cancel(@Nullable Future<?> future, boolean mayInterruptIfRunning) {
            if (future != null) {
                void var1_1;
                Future<?> future2;
                future2.cancel((boolean)var1_1);
            }
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            try {
                try {
                    I sourceResult = Ascii.getUninterruptibly(this.inputFuture);
                }
                catch (CancellationException cancellationException) {
                    this.cancel(false);
                    this.function = null;
                    this.inputFuture = null;
                    return;
                }
                catch (ExecutionException e) {
                    this.setException(e.getCause());
                    this.function = null;
                    this.inputFuture = null;
                    return;
                }
                this.outputFuture = Ascii.checkNotNull(this.function.apply(e), "AsyncFunction may not return null.");
                ListenableFuture<O> outputFuture = this.outputFuture;
                if (this.isCancelled()) {
                    outputFuture.cancel(this.wasInterrupted());
                    this.outputFuture = null;
                    return;
                }
                outputFuture.addListener(new Runnable(this, outputFuture){
                    private /* synthetic */ ListenableFuture val$outputFuture;
                    private /* synthetic */ ChainingListenableFuture this$0;
                    {
                        this.this$0 = chainingListenableFuture;
                        this.val$outputFuture = listenableFuture;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final void run() {
                        try {
                            this.this$0.set(Ascii.getUninterruptibly(this.val$outputFuture));
                            return;
                        }
                        catch (CancellationException cancellationException) {
                            this.this$0.cancel(false);
                            return;
                        }
                        catch (ExecutionException e) {
                            void var1_1;
                            this.this$0.setException(var1_1.getCause());
                            return;
                        }
                        finally {
                            ChainingListenableFuture.access$302(this.this$0, null);
                        }
                    }
                }, MoreExecutors$DirectExecutor.INSTANCE);
                return;
                {
                    catch (UndeclaredThrowableException e) {
                        this.setException(e.getCause());
                        return;
                    }
                    catch (Throwable t) {
                        void var1_4;
                        this.setException((Throwable)var1_4);
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.function = null;
                this.inputFuture = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ChainingListenableFuture(AsyncFunction x0, ListenableFuture x1, byte by) {
            this((AsyncFunction<I, O>)var1_1, (ListenableFuture<I>)var2_2);
            void var2_2;
            void var1_1;
        }

        static /* synthetic */ ListenableFuture access$302(ChainingListenableFuture x0, ListenableFuture x1) {
            x0.outputFuture = null;
            return null;
        }
    }

    static final class ImmediateFailedFuture<V>
    extends ImmediateFuture<V> {
        private final Throwable thrown;

        /*
         * WARNING - void declaration
         */
        ImmediateFailedFuture(Throwable thrown) {
            super((byte)0);
            void var1_1;
            this.thrown = var1_1;
        }

        @Override
        public final V get() throws ExecutionException {
            throw new ExecutionException(this.thrown);
        }
    }

    static final class ImmediateSuccessfulFuture<V>
    extends ImmediateFuture<V> {
        @Nullable
        private final V value;

        /*
         * WARNING - void declaration
         */
        ImmediateSuccessfulFuture(@Nullable V value) {
            super((byte)0);
            void var1_1;
            this.value = var1_1;
        }

        @Override
        public final V get() {
            return this.value;
        }
    }

    static abstract class ImmediateFuture<V>
    implements ListenableFuture<V> {
        private static final Logger log = Logger.getLogger(ImmediateFuture.class.getName());

        private ImmediateFuture() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void addListener(Runnable listener, Executor executor) {
            Ascii.checkNotNull(listener, "Runnable was null.");
            Ascii.checkNotNull(executor, "Executor was null.");
            try {
                executor.execute(listener);
                return;
            }
            catch (RuntimeException e) {
                void var3_3;
                String string;
                String string2;
                string2 = String.valueOf(String.valueOf(string2));
                string = String.valueOf(String.valueOf(string));
                log.log(Level.SEVERE, new StringBuilder(57 + string2.length() + string.length()).append("RuntimeException while executing runnable ").append(string2).append(" with executor ").append(string).toString(), (Throwable)var3_3);
                return;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public abstract V get() throws ExecutionException;

        @Override
        public V get(long timeout, TimeUnit unit) throws ExecutionException {
            Ascii.checkNotNull(unit);
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        /* synthetic */ ImmediateFuture(byte by) {
            this();
        }
    }
}

