/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.jodd.util.cl;

import com.github.igorsuhorukov.jodd.util.SystemUtil;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedURLClassLoader
extends URLClassLoader {
    protected ClassLoader parentClassLoader;
    protected String[] systemPackages;
    protected String[] loaderPackages;
    protected boolean parentFirst;

    /*
     * WARNING - void declaration
     */
    public ExtendedURLClassLoader(URL[] classpath, ClassLoader parent) {
        this((URL[])var1_1, (ClassLoader)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ExtendedURLClassLoader(URL[] classpath, ClassLoader parent, boolean parentFirst) {
        super((URL[])var1_1, parent);
        void var2_2;
        void var3_3;
        void var1_1;
        this.parentFirst = var3_3;
        if (parent == null) {
            parent = ExtendedURLClassLoader.getSystemClassLoader();
        }
        this.parentClassLoader = var2_2;
        this.systemPackages = new String[0];
        this.loaderPackages = new String[0];
        this.addSystemPackage(SystemUtil.getJrePackages());
    }

    /*
     * WARNING - void declaration
     */
    public void setParentFirst(boolean parentFirst) {
        void var1_1;
        this.parentFirst = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addSystemPackage(String ... packages) {
        void var1_1;
        this.systemPackages = this.joinPackages(this.systemPackages, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addLoaderPackage(String ... packages) {
        void var1_1;
        this.loaderPackages = this.joinPackages(this.loaderPackages, (String[])var1_1);
    }

    protected String[] joinPackages(String[] dest, String[] src) {
        int len = dest.length;
        String[] result = new String[len + src.length];
        System.arraycopy(dest, 0, result, 0, len);
        for (int i = 0; i < src.length; ++i) {
            String pck = src[i];
            result[len + i] = pck = pck + (pck.endsWith(".") ? "" : ".");
        }
        return result;
    }

    protected boolean isInPackageList(String name, String[] packages) {
        String[] arr$ = packages;
        int len$ = packages.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String pck = arr$[i$];
            if (!name.startsWith(pck)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isParentFirst(String resourceName) {
        void var2_2;
        void var1_1;
        boolean useParentFirst = this.parentFirst;
        if (this.isInPackageList(resourceName, this.systemPackages)) {
            useParentFirst = true;
        }
        if (this.isInPackageList((String)var1_1, this.loaderPackages)) {
            useParentFirst = false;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected synchronized Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        void var3_3;
        void var2_2;
        Class<?> c = this.findLoadedClass(className);
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        boolean bl = this.isParentFirst(className);
        if (bl) {
            try {
                c = this.parentClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (c == null) {
                c = this.findClass(className);
            }
        } else {
            try {
                c = this.findClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (c == null) {
                void var1_1;
                c = this.parentClassLoader.loadClass((String)var1_1);
            }
        }
        if (var2_2 != false) {
            this.resolveClass(c);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URL getResource(String resourceName) {
        void var2_3;
        URL url;
        boolean bl = this.isParentFirst(resourceName);
        if (bl) {
            url = this.parentClassLoader.getResource(resourceName);
            if (url == null) {
                url = this.findResource(resourceName);
            }
        } else {
            url = this.findResource(resourceName);
            if (url == null) {
                void var1_1;
                url = this.parentClassLoader.getResource((String)var1_1);
            }
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Enumeration<URL> getResources(String resourceName) throws IOException {
        void var2_3;
        void var1_1;
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> localUrls = this.findResources(resourceName);
        Enumeration<URL> parentUrls = this.parentClassLoader.getResources(resourceName);
        boolean bl = this.isParentFirst((String)var1_1);
        if (bl) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
        } else {
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return new Enumeration<URL>(this, (List)var2_3){
            private Iterator<URL> iterator;
            private /* synthetic */ List val$urls;
            {
                this.val$urls = list;
                this.iterator = this.val$urls.iterator();
            }

            @Override
            public final boolean hasMoreElements() {
                return this.iterator.hasNext();
            }
        };
    }
}

