/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.maven;

import com.github.igorsuhorukov.maven.DependenciesResolver;
import com.github.igorsuhorukov.smreed.dropship.ClassLoaderBuilder;
import com.github.igorsuhorukov.smreed.dropship.MavenClassLoader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MavenDependenciesResolver
implements DependenciesResolver {
    @Override
    public List<URL> resolve(Set<String> dependenciesUrl) {
        ClassLoaderBuilder classLoaderBuilder = MavenClassLoader.usingCentralRepo();
        ArrayList<URL> classPath = new ArrayList<URL>();
        dependenciesUrl.stream().filter(Objects::nonNull).filter(url -> url.startsWith("mvn:/")).map(dependency -> {
            try {
                String[] protocol = dependency.replace("mvn:/", "").split("\\?");
                if (protocol.length == 2) {
                    String repository = protocol[1];
                    String artifact = protocol[0];
                    return MavenClassLoader.using(repository).getArtifactUrlsCollection(artifact, null);
                }
                return classLoaderBuilder.getArtifactUrlsCollection(protocol[0], null);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }).forEach(classPath::addAll);
        return classPath;
    }
}

