/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.service;

import com.github.igorsuhorukov.smreed.dropship.ClassLoaderBuilder;
import com.github.igorsuhorukov.smreed.dropship.MavenClassLoader;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;

public class MavenServiceLoader {
    public static <T> Collection<T> loadServices(String gav, Class<T> serviceClass) {
        return MavenServiceLoader.loadServices(gav, null, serviceClass);
    }

    public static <T> Collection<T> loadServices(String gav, String repo, Class<T> serviceClass) {
        URLClassLoader mavenClassLoader = MavenServiceLoader.getClassLoaderBuilder(repo).forMavenCoordinates(gav);
        return MavenServiceLoader.loadServices(mavenClassLoader, serviceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Collection<T> loadServices(ClassLoader classLoader, Class<T> serviceClass) {
        Thread currentThread = Thread.currentThread();
        ClassLoader prevContextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(classLoader);
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(serviceClass, classLoader);
            Iterator<T> iterator = serviceLoader.iterator();
            ArrayList<T> services = new ArrayList<T>();
            while (iterator.hasNext()) {
                T service = iterator.next();
                if (service == null) continue;
                services.add(service);
            }
            ArrayList<T> arrayList = services;
            return arrayList;
        }
        finally {
            currentThread.setContextClassLoader(prevContextClassLoader);
        }
    }

    private static ClassLoaderBuilder getClassLoaderBuilder(String repo) {
        ClassLoaderBuilder classLoaderBuilder = repo != null && !repo.isEmpty() ? MavenClassLoader.using(repo) : MavenClassLoader.usingCentralRepo();
        return classLoaderBuilder;
    }
}

