/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.smreed.dropship;

import com.github.igorsuhorukov.apache.maven.repository.internal.MavenRepositorySystemUtils;
import com.github.igorsuhorukov.codehaus.plexus.PlexusContainerException;
import com.github.igorsuhorukov.codehaus.plexus.component.repository.exception.ComponentLookupException;
import com.github.igorsuhorukov.eclipse.aether.DefaultRepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.RepositorySystem;
import com.github.igorsuhorukov.eclipse.aether.RepositorySystemSession;
import com.github.igorsuhorukov.eclipse.aether.artifact.Artifact;
import com.github.igorsuhorukov.eclipse.aether.artifact.DefaultArtifact;
import com.github.igorsuhorukov.eclipse.aether.collection.CollectRequest;
import com.github.igorsuhorukov.eclipse.aether.collection.DependencyCollectionException;
import com.github.igorsuhorukov.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import com.github.igorsuhorukov.eclipse.aether.graph.Dependency;
import com.github.igorsuhorukov.eclipse.aether.graph.DependencyFilter;
import com.github.igorsuhorukov.eclipse.aether.graph.DependencyNode;
import com.github.igorsuhorukov.eclipse.aether.impl.DefaultServiceLocator;
import com.github.igorsuhorukov.eclipse.aether.internal.impl.DefaultRepositorySystem;
import com.github.igorsuhorukov.eclipse.aether.repository.LocalRepository;
import com.github.igorsuhorukov.eclipse.aether.repository.LocalRepositoryManager;
import com.github.igorsuhorukov.eclipse.aether.repository.RemoteRepository;
import com.github.igorsuhorukov.eclipse.aether.resolution.ArtifactRequest;
import com.github.igorsuhorukov.eclipse.aether.resolution.ArtifactResolutionException;
import com.github.igorsuhorukov.eclipse.aether.resolution.ArtifactResult;
import com.github.igorsuhorukov.eclipse.aether.resolution.DependencyRequest;
import com.github.igorsuhorukov.eclipse.aether.resolution.DependencyResolutionException;
import com.github.igorsuhorukov.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import com.github.igorsuhorukov.eclipse.aether.spi.connector.transport.TransporterFactory;
import com.github.igorsuhorukov.eclipse.aether.transport.file.FileTransporterFactory;
import com.github.igorsuhorukov.eclipse.aether.transport.http.HttpTransporterFactory;
import com.github.igorsuhorukov.eclipse.aether.util.filter.AndDependencyFilter;
import com.github.igorsuhorukov.eclipse.aether.util.filter.PatternExclusionsDependencyFilter;
import com.github.igorsuhorukov.eclipse.aether.util.filter.ScopeDependencyFilter;
import com.github.igorsuhorukov.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.collect.CollectPreconditions;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.Iterables;
import com.github.igorsuhorukov.smreed.dropship.LoggingRepositoryListener;
import com.github.igorsuhorukov.smreed.dropship.MavenDependency;
import com.github.igorsuhorukov.smreed.dropship.NotLogger;
import com.github.igorsuhorukov.smreed.dropship.RepositoryUtils;
import com.github.igorsuhorukov.smreed.dropship.Settings;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.grape.SettingsXmlRepositorySystemSessionAutoConfiguration;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ClassLoaderBuilder {
    private static final String COMPILE_SCOPE = "compile";
    private static final ClassLoader SHARE_NOTHING = null;
    private final List<RemoteRepository> repositories;

    /*
     * WARNING - void declaration
     */
    ClassLoaderBuilder(String repository) {
        this(new RemoteRepository.Builder("custom", "default", (String)var1_1).build());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ClassLoaderBuilder(RemoteRepository ... repositories) {
        void var1_1;
        Ascii.checkNotNull(repositories);
        Ascii.checkArgument(repositories.length > 0, "Must specify at least one remote repository.");
        this.repositories = ImmutableList.copyOf(var1_1);
    }

    public URLClassLoader forMavenCoordinates(String groupArtifactVersion) {
        Exception exception;
        try {
            return new URLClassLoader(this.getArtifactUrls((String)((Object)exception)), SHARE_NOTHING);
        }
        catch (Exception exception2) {
            exception = exception2;
            throw Ascii.propagate(exception2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public URLClassLoader forMavenCoordinates(String groupArtifactVersion, ClassLoader parent) {
        Exception exception;
        try {
            void var2_2;
            return new URLClassLoader(this.getArtifactUrls((String)((Object)exception)), (ClassLoader)var2_2);
        }
        catch (Exception exception2) {
            exception = exception2;
            throw Ascii.propagate(exception2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public URLClassLoader forMavenCoordinates(MavenDependency[] dependencies, ClassLoader parent) {
        Ascii.checkNotNull(dependencies);
        try {
            void var2_2;
            void var3_3;
            void var1_1;
            ArrayList<URL> urls = new ArrayList<URL>();
            for (void mavenDependency : var1_1) {
                urls.addAll(this.getArtifactUrlsCollection(mavenDependency.getGroupArtifactVersion(), mavenDependency.getExcludes()));
            }
            return new URLClassLoader(Iterables.toArray(var3_3, URL.class), (ClassLoader)var2_2);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Ascii.propagate(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<URL> getArtifactUrlsCollection(String groupArtifactVersion, Collection<String> excludes) throws Exception {
        void var1_1;
        Iterator<Object> iterator;
        NotLogger.info("Collecting maven metadata.");
        CollectRequest collectRequest = this.createCollectRequestForGAV(groupArtifactVersion);
        NotLogger.info("Resolving dependencies.");
        List<Artifact> artifacts = this.collectDependenciesIntoArtifacts(collectRequest, excludes);
        NotLogger.info("Building classpath for %s from %d URLs.", groupArtifactVersion, artifacts.size());
        ArrayList<URL> urls = CollectPreconditions.newArrayListWithExpectedSize(artifacts.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            urls.add(artifact.getFile().toURI().toURL());
        }
        for (String path : Settings.additionalClasspathPaths()) {
            void var3_3;
            NotLogger.info("Adding \"%s\" to classpath.", path, new Object[0]);
            urls.add(new File((String)var3_3).toURI().toURL());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private URL[] getArtifactUrls(String groupArtifactVersion) throws Exception {
        void var1_1;
        return Iterables.toArray(this.getArtifactUrlsCollection((String)var1_1, null), URL.class);
    }

    /*
     * WARNING - void declaration
     */
    protected CollectRequest createCollectRequestForGAV(String gav) {
        void var2_2;
        Iterator<RemoteRepository> iterator;
        DefaultArtifact artifact = new DefaultArtifact(gav);
        Dependency dependency = new Dependency(artifact, this.getScope());
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot((Dependency)((Object)iterator));
        for (RemoteRepository repository : this.repositories) {
            void var3_3;
            collectRequest.addRepository((RemoteRepository)var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected List<Artifact> collectDependenciesIntoArtifacts(CollectRequest collectRequest, Collection<String> excludes) throws PlexusContainerException, ComponentLookupException, DependencyCollectionException, ArtifactResolutionException, DependencyResolutionException {
        void var2_2;
        void var1_1;
        void var3_3;
        RepositorySystem repositorySystem = this.newRepositorySystem();
        RepositorySystemSession session = this.newSession(repositorySystem);
        RepositoryUtils.configureRepositories(collectRequest, session);
        DependencyNode node = repositorySystem.collectDependencies(session, collectRequest).getRoot();
        DependencyFilter filter = excludes != null && !excludes.isEmpty() ? new AndDependencyFilter(new ScopeDependencyFilter(new String[0]), new PatternExclusionsDependencyFilter(excludes)) : new ScopeDependencyFilter(new String[0]);
        DependencyRequest request = new DependencyRequest(node, filter);
        var3_3.resolveDependencies(session, request);
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        var1_1.accept(nlg);
        return var2_2.getArtifacts(false);
    }

    /*
     * WARNING - void declaration
     */
    protected RepositorySystem newRepositorySystem() throws PlexusContainerException, ComponentLookupException {
        void var1_1;
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositorySystem.class, DefaultRepositorySystem.class);
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        return var1_1.getService(RepositorySystem.class);
    }

    /*
     * WARNING - void declaration
     */
    protected RepositorySystemSession newSession(RepositorySystem system) {
        void var2_2;
        void var1_1;
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        this.applySettings((RepositorySystem)var1_1, session);
        session.setRepositoryListener(new LoggingRepositoryListener());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void applySettings(RepositorySystem system, DefaultRepositorySystemSession session) {
        SettingsXmlRepositorySystemSessionAutoConfiguration settingsXmlRepositorySystemSessionAutoConfiguration;
        if (!Boolean.getBoolean("skipMavenSettings")) {
            settingsXmlRepositorySystemSessionAutoConfiguration = new SettingsXmlRepositorySystemSessionAutoConfiguration();
            settingsXmlRepositorySystemSessionAutoConfiguration.apply(session, system);
        }
        if (session.getLocalRepositoryManager() == null) {
            void var1_1;
            void var2_2;
            LocalRepository localRepository = new LocalRepository(Settings.localRepoPath());
            LocalRepositoryManager localRepositoryManager = system.newLocalRepositoryManager(session, (LocalRepository)((Object)settingsXmlRepositorySystemSessionAutoConfiguration));
            var2_2.setLocalRepositoryManager((LocalRepositoryManager)var1_1);
        }
    }

    protected String getScope() {
        return COMPILE_SCOPE;
    }

    /*
     * WARNING - void declaration
     */
    public URL resolveArtifact(String gav) throws PlexusContainerException, ComponentLookupException, ArtifactResolutionException, MalformedURLException {
        void var3_3;
        void var2_2;
        void var1_1;
        RepositorySystem repositorySystem = this.newRepositorySystem();
        RepositorySystemSession session = this.newSession(repositorySystem);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        for (RemoteRepository repository : this.repositories) {
            artifactRequest.addRepository(RepositoryUtils.applySessionSettingsToRepository(session, repository));
        }
        artifactRequest.setArtifact(new DefaultArtifact((String)var1_1));
        ArtifactResult artifactResult = var2_2.resolveArtifact((RepositorySystemSession)var3_3, artifactRequest);
        return artifactResult.getArtifact().getFile().toURI().toURL();
    }
}

