/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.smreed.dropship;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.Optional;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.collect.Iterables;
import com.github.igorsuhorukov.smreed.dropship.ClassLoaderBuilder;
import com.github.igorsuhorukov.smreed.dropship.MavenClassLoader;
import com.github.igorsuhorukov.smreed.dropship.NotLogger;
import com.github.igorsuhorukov.smreed.dropship.Settings;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Properties;

public final class Dropship {
    /*
     * WARNING - void declaration
     */
    private static ClassLoaderBuilder classLoaderBuilder() {
        Optional<String> override = Settings.mavenRepoUrl();
        if (override.isPresent()) {
            void var0;
            NotLogger.info("Will load artifacts from %s", override, new Object[0]);
            return MavenClassLoader.using((String)var0.get());
        }
        return MavenClassLoader.usingCentralRepo();
    }

    /*
     * WARNING - void declaration
     */
    private static String resolveGav(String gav) {
        void var1_1;
        ImmutableList<String> tokens = ImmutableList.copyOf(Settings.GAV_SPLITTER.split(gav));
        Ascii.checkArgument(tokens.size() > 1, "Require groupId:artifactId[:version]");
        Ascii.checkArgument(tokens.size() < 4, "Require groupId:artifactId[:version]");
        if (tokens.size() > 2) {
            return gav;
        }
        Properties settings = Settings.loadBootstrapPropertiesUnchecked();
        if (settings.containsKey(gav)) {
            String string;
            void var2_2;
            return Settings.GAV_JOINER$7418a432.join(tokens.get(0), tokens.get(1), var2_2.getProperty(string));
        }
        return Settings.GAV_JOINER$7418a432.join(tokens.get(0), var1_1.get(1), "[0,)");
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        Object object;
        void var1_1;
        void var2_2;
        Ascii.checkArgument((args = Ascii.checkNotNull(args)).length >= 2, "Must specify groupId:artifactId[:version] and classname!");
        NotLogger.info("Starting Dropship v%s", Settings.dropshipVersion(), new Object[0]);
        String gav = Dropship.resolveGav(args[0]);
        NotLogger.info("Requested %s, will load artifact and dependencies for %s.", args[0], gav);
        URLClassLoader loader = Dropship.classLoaderBuilder().forMavenCoordinates(gav);
        System.setProperty("dropship.running", "true");
        Class<?> mainClass = loader.loadClass(args[1]);
        Thread.currentThread().setContextClassLoader(loader);
        Method mainMethod = var2_2.getMethod("main", String[].class);
        Object mainArgs = Iterables.skip(ImmutableList.copyOf(args), 2);
        var1_1.invoke(null, new Object[]{Iterables.toArray(object, String.class)});
    }
}

