/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.smreed.dropship;

import com.github.igorsuhorukov.eclipse.aether.AbstractRepositoryListener;
import com.github.igorsuhorukov.eclipse.aether.RepositoryEvent;
import com.github.igorsuhorukov.eclipse.aether.artifact.Artifact;
import com.github.igorsuhorukov.google.common.collect.Maps;
import com.github.igorsuhorukov.smreed.dropship.NotLogger;
import com.github.igorsuhorukov.smreed.dropship.Settings;
import java.util.Map;
import java.util.concurrent.TimeUnit;

final class LoggingRepositoryListener
extends AbstractRepositoryListener {
    private Map<String, Long> startTimes = Maps.newHashMap();

    LoggingRepositoryListener() {
    }

    private static String artifactAsString(Artifact artifact) {
        Artifact artifact2;
        return Settings.GAV_JOINER$7418a432.join(artifact.getGroupId(), artifact.getArtifactId(), artifact2.getVersion());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void artifactDownloading(RepositoryEvent event) {
        void var1_1;
        super.artifactDownloading((RepositoryEvent)event);
        event = ((RepositoryEvent)event).getArtifact();
        String key = LoggingRepositoryListener.artifactAsString((Artifact)event);
        this.startTimes.put((String)var1_1, System.nanoTime());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void artifactDownloaded(RepositoryEvent event) {
        void var2_2;
        void var1_1;
        void var3_3;
        super.artifactDownloaded(event);
        Artifact artifact = event.getArtifact();
        String key = LoggingRepositoryListener.artifactAsString(artifact);
        long downloadTimeNanos = System.nanoTime() - this.startTimes.remove(key);
        double downloadTimeMs = TimeUnit.NANOSECONDS.toMillis(downloadTimeNanos);
        double downloadTimeSec = TimeUnit.NANOSECONDS.toSeconds((long)var3_3);
        long size = var1_1.getFile().length();
        double d = 9.765625E-4 * (double)size;
        double downloadRateKBytesPerSecond = d / downloadTimeSec;
        NotLogger.info("Downloaded %s (%d bytes) in %gms (%g kbytes/sec).", var2_2, size, downloadTimeMs, downloadRateKBytesPerSecond);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void artifactResolved(RepositoryEvent event) {
        void var1_1;
        super.artifactResolved(event);
        NotLogger.debug("Resolved %s.", LoggingRepositoryListener.artifactAsString(var1_1.getArtifact()), new Object[0]);
    }
}

