/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.smreed.dropship;

import com.github.igorsuhorukov.google.common.base.Ascii;
import com.github.igorsuhorukov.google.common.base.CaseFormat;
import com.github.igorsuhorukov.google.common.base.CharMatcher;
import com.github.igorsuhorukov.google.common.base.Optional;
import com.github.igorsuhorukov.google.common.base.Splitter;
import com.github.igorsuhorukov.google.common.collect.ImmutableList;
import com.github.igorsuhorukov.google.common.io.Resources;
import com.github.igorsuhorukov.smreed.dropship.Dropship;
import com.github.igorsuhorukov.smreed.dropship.NotLogger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Manifest;

final class Settings {
    static final Ascii GAV_JOINER$7418a432 = Ascii.on$27f19060(':');
    static final boolean DEBUG = System.getProperty("verbose") != null;
    private static CharMatcher GAV_DELIMITER = CharMatcher.is(':');
    static final Splitter GAV_SPLITTER = Splitter.on(GAV_DELIMITER).trimResults().omitEmptyStrings();
    private static final Properties CACHE = new Properties();
    private static final Splitter CSV = Splitter.on(',').trimResults().omitEmptyStrings();
    private static volatile boolean loaded = false;

    static Optional<String> mavenRepoUrl() {
        return Settings.loadProperty("repo.remote.url");
    }

    static String localRepoPath() {
        return Settings.loadProperty("repo.local.path", System.getProperty("user.home") + "/.m2/repository");
    }

    static String dropshipVersion() {
        return Settings.loadProperty("dropship.xArtifactVersion", "0.0");
    }

    /*
     * WARNING - void declaration
     */
    static List<String> additionalClasspathPaths() {
        Optional<String> additionalClasspathPathsString = Settings.loadProperty("dropship.additional.paths");
        if (additionalClasspathPathsString.isPresent()) {
            void var0;
            return ImmutableList.copyOf(CSV.split((CharSequence)var0.get()));
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - void declaration
     */
    private static String loadProperty(String name, String defaultValue) {
        void var1_1;
        String string;
        Ascii.checkNotNull(defaultValue);
        return Settings.loadProperty(string).or((String)var1_1);
    }

    private static Optional<String> loadProperty(String name) {
        String string;
        return Optional.fromNullable(Settings.loadBootstrapPropertiesUnchecked().getProperty(string));
    }

    /*
     * WARNING - void declaration
     */
    private static synchronized Properties loadBootstrapProperties() throws IOException {
        if (loaded) {
            return CACHE;
        }
        URL url = Dropship.class.getClassLoader().getResource("dropship.properties");
        if (url == null) {
            NotLogger.warn("No dropship.properties found! Using .dropship-prefixed system properties (-D)");
            for (Object e : System.getProperties().keySet()) {
                void var2_7;
                String e2 = String.valueOf(e);
                if (!e2.startsWith("dropship.")) continue;
                String kkey = e2.substring(9);
                NotLogger.warn("Using " + kkey + "=" + System.getProperty(e2));
                CACHE.put((Object)var2_7, System.getProperty(e2));
            }
        } else {
            Iterator<Map.Entry<Object, Object>> iterator;
            NotLogger.debug("Loading configuration from %s.", iterator, new Object[0]);
            CACHE.load(Dropship.class.getClassLoader().getResourceAsStream("dropship.properties"));
            for (Map.Entry<Object, Object> entry : CACHE.entrySet()) {
                NotLogger.debug("  %s: %s = %s", "dropship.properties", entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : Settings.loadPackageInformation().entrySet()) {
            CACHE.put(entry.getKey(), entry.getValue());
            NotLogger.debug("  MANIFEST: %s = %s", entry.getKey(), entry.getValue());
        }
        loaded = true;
        return CACHE;
    }

    static Properties loadBootstrapPropertiesUnchecked() {
        try {
            return Settings.loadBootstrapProperties();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Ascii.propagate(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Properties loadPackageInformation() {
        void var0;
        Properties versionProperties = new Properties();
        Optional<Manifest> manifest = Settings.loadManifest();
        if (manifest.isPresent()) {
            Iterator<Map.Entry<Object, Object>> iterator;
            for (Map.Entry<Object, Object> attributeEntry : ((Manifest)((Optional)((Object)iterator)).get()).getMainAttributes().entrySet()) {
                void var2_2;
                void var3_3;
                String manifestEntryKey = attributeEntry.getKey().toString().toLowerCase();
                if (manifestEntryKey.startsWith("X-")) {
                    manifestEntryKey = manifestEntryKey.substring(2);
                }
                String versionPropertiesKey = "dropship." + CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, manifestEntryKey);
                System.setProperty(versionPropertiesKey, attributeEntry.getValue().toString());
                versionProperties.setProperty((String)var3_3, var2_2.getValue().toString());
            }
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static Optional<Manifest> loadManifest() {
        Optional<URL> location = Optional.fromNullable(Resources.getResource(CharMatcher.is('.').replaceFrom(Dropship.class.getName(), '/') + ".class"));
        if (!location.isPresent()) {
            return Optional.absent();
        }
        try {
            void var0;
            String classPath = location.get().toString();
            if (!classPath.startsWith("jar")) {
                return Optional.absent();
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            return Optional.of(new Manifest(new URL((String)var0).openStream()));
        }
        catch (MalformedURLException malformedURLException) {
            return Optional.absent();
        }
        catch (IOException iOException) {
            return Optional.absent();
        }
    }
}

