/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.springframework.boot.cli.compiler;

import com.github.igorsuhorukov.apache.maven.settings.Profile;
import com.github.igorsuhorukov.apache.maven.settings.Repository;
import com.github.igorsuhorukov.codehaus.plexus.interpolation.InterpolationException;
import com.github.igorsuhorukov.codehaus.plexus.interpolation.Interpolator;
import com.github.igorsuhorukov.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import com.github.igorsuhorukov.codehaus.plexus.interpolation.RegexBasedInterpolator;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.grape.RepositoryConfiguration;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.maven.MavenSettings;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.maven.MavenSettingsReader;
import com.github.igorsuhorukov.springframework.util.StringUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class RepositoryConfigurationFactory {
    private static final RepositoryConfiguration MAVEN_CENTRAL = new RepositoryConfiguration("central", URI.create("http://repo1.maven.org/maven2/"), false);
    private static final RepositoryConfiguration SPRING_MILESTONE = new RepositoryConfiguration("spring-milestone", URI.create("http://repo.spring.io/milestone"), false);
    private static final RepositoryConfiguration SPRING_SNAPSHOT = new RepositoryConfiguration("spring-snapshot", URI.create("http://repo.spring.io/snapshot"), true);

    private RepositoryConfigurationFactory() {
    }

    /*
     * WARNING - void declaration
     */
    public static List<RepositoryConfiguration> createDefaultRepositoryConfiguration() {
        void var1_1;
        void var0;
        MavenSettings mavenSettings = new MavenSettingsReader().readSettings();
        ArrayList<RepositoryConfiguration> repositoryConfiguration = new ArrayList<RepositoryConfiguration>();
        repositoryConfiguration.add(MAVEN_CENTRAL);
        if (!Boolean.getBoolean("disableSpringSnapshotRepos")) {
            repositoryConfiguration.add(SPRING_MILESTONE);
            repositoryConfiguration.add(SPRING_SNAPSHOT);
        }
        RepositoryConfigurationFactory.addDefaultCacheAsRepository(mavenSettings.getLocalRepository(), repositoryConfiguration);
        RepositoryConfigurationFactory.addActiveProfileRepositories(var0.getActiveProfiles(), repositoryConfiguration);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static void addDefaultCacheAsRepository(String localRepository, List<RepositoryConfiguration> repositoryConfiguration) {
        RepositoryConfiguration repository = new RepositoryConfiguration("local", RepositoryConfigurationFactory.getLocalRepositoryDirectory(localRepository).toURI(), true);
        if (!repositoryConfiguration.contains(repository)) {
            RepositoryConfiguration repositoryConfiguration2;
            void var1_1;
            var1_1.add(0, repositoryConfiguration2);
        }
    }

    private static void addActiveProfileRepositories(List<Profile> activeProfiles, List<RepositoryConfiguration> configurations) {
        for (Profile activeProfile : activeProfiles) {
            Iterator<Repository> iterator;
            RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
            interpolator.addValueSource(new PropertiesBasedValueSource(activeProfile.getProperties()));
            for (Repository repository : ((Profile)((Object)iterator)).getRepositories()) {
                configurations.add(RepositoryConfigurationFactory.getRepositoryConfiguration(interpolator, repository));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static RepositoryConfiguration getRepositoryConfiguration(Interpolator interpolator, Repository repository) {
        void var3_3;
        String string;
        void var2_2;
        String name = RepositoryConfigurationFactory.interpolate(interpolator, repository.getId());
        String url = RepositoryConfigurationFactory.interpolate(interpolator, repository.getUrl());
        boolean snapshotsEnabled = false;
        if (repository.getSnapshots() != null) {
            void var1_1;
            snapshotsEnabled = var1_1.getSnapshots().isEnabled();
        }
        return new RepositoryConfiguration((String)var2_2, URI.create(string), (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static String interpolate(Interpolator interpolator, String value) {
        try {
            return interpolator.interpolate(value);
        }
        catch (InterpolationException interpolationException) {
            void var1_1;
            return var1_1;
        }
    }

    private static File getLocalRepositoryDirectory(String localRepository) {
        if (StringUtils.hasText(localRepository)) {
            String string;
            return new File(string);
        }
        return new File(RepositoryConfigurationFactory.getM2HomeDirectory(), "repository");
    }

    /*
     * WARNING - void declaration
     */
    private static File getM2HomeDirectory() {
        String mavenRoot = System.getProperty("maven.home");
        if (StringUtils.hasLength(mavenRoot)) {
            void var0;
            return new File((String)var0);
        }
        return new File(System.getProperty("user.home"), ".m2");
    }
}

