/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.springframework.boot.cli.compiler.dependencies;

import com.github.igorsuhorukov.springframework.util.Assert;
import java.util.Collections;
import java.util.List;

public final class Dependency {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final List<Exclusion> exclusions;

    /*
     * WARNING - void declaration
     */
    public Dependency(String groupId, String artifactId, String version, List<Exclusion> exclusions) {
        void var3_3;
        void var2_2;
        void var1_1;
        Assert.notNull(groupId, "GroupId must not be null");
        Assert.notNull(artifactId, "ArtifactId must not be null");
        Assert.notNull(version, "Version must not be null");
        Assert.notNull(exclusions, "Exclusions must not be null");
        this.groupId = var1_1;
        this.artifactId = var2_2;
        this.version = var3_3;
        this.exclusions = Collections.unmodifiableList(exclusions);
    }

    public final String getGroupId() {
        return this.groupId;
    }

    public final String getArtifactId() {
        return this.artifactId;
    }

    public final String getVersion() {
        return this.version;
    }

    public final List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public final String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = 31 + this.groupId.hashCode();
        result = result * 31 + this.artifactId.hashCode();
        result = result * 31 + this.version.hashCode();
        var1_1 = var1_1 * 31 + this.exclusions.hashCode();
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            void var1_1;
            Dependency other = (Dependency)obj;
            boolean bl = true & this.groupId.equals(other.groupId);
            bl &= this.artifactId.equals(other.artifactId);
            bl &= this.version.equals(other.version);
            return bl &= this.exclusions.equals(var1_1.exclusions);
        }
        return false;
    }

    public static final class Exclusion {
        private final String groupId;
        private final String artifactId;

        /*
         * WARNING - void declaration
         */
        Exclusion(String groupId, String artifactId) {
            void var2_2;
            void var1_1;
            Assert.notNull(groupId, "GroupId must not be null");
            Assert.notNull(groupId, "ArtifactId must not be null");
            this.groupId = var1_1;
            this.artifactId = var2_2;
        }

        public final String getArtifactId() {
            return this.artifactId;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final String toString() {
            return this.groupId + ":" + this.artifactId;
        }

        public final int hashCode() {
            return this.groupId.hashCode() * 31 + this.artifactId.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                void var1_1;
                Exclusion other = (Exclusion)obj;
                boolean bl = true & this.groupId.equals(other.groupId);
                return bl &= this.artifactId.equals(var1_1.artifactId);
            }
            return false;
        }
    }
}

