/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.springframework.boot.cli.compiler.grape;

import com.github.igorsuhorukov.eclipse.aether.artifact.Artifact;
import com.github.igorsuhorukov.eclipse.aether.artifact.DefaultArtifact;
import com.github.igorsuhorukov.eclipse.aether.graph.Dependency;
import com.github.igorsuhorukov.eclipse.aether.graph.Exclusion;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.dependencies.ArtifactCoordinatesResolver;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.dependencies.CompositeDependencyManagement;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.dependencies.Dependency;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.dependencies.DependencyManagement;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.dependencies.SpringBootDependenciesDependencyManagement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DependencyResolutionContext {
    private final Map<String, Dependency> managedDependencyByGroupAndArtifact = new HashMap<String, Dependency>();
    private final List<Dependency> managedDependencies = new ArrayList<Dependency>();
    private DependencyManagement dependencyManagement = null;
    private ArtifactCoordinatesResolver artifactCoordinatesResolver;

    public DependencyResolutionContext() {
        this.addDependencyManagement(new SpringBootDependenciesDependencyManagement());
    }

    /*
     * WARNING - void declaration
     */
    private String getIdentifier(Dependency dependency) {
        void var1_1;
        return this.getIdentifier(dependency.getArtifact().getGroupId(), var1_1.getArtifact().getArtifactId());
    }

    /*
     * WARNING - void declaration
     */
    private String getIdentifier(String groupId, String artifactId) {
        void var2_2;
        void var1_1;
        return (String)var1_1 + ":" + (String)var2_2;
    }

    public ArtifactCoordinatesResolver getArtifactCoordinatesResolver() {
        return this.artifactCoordinatesResolver;
    }

    /*
     * WARNING - void declaration
     */
    public String getManagedVersion(String groupId, String artifactId) {
        Dependency dependency = this.getManagedDependency(groupId, artifactId);
        if (dependency == null) {
            void var2_2;
            void var1_1;
            dependency = this.managedDependencyByGroupAndArtifact.get(this.getIdentifier((String)var1_1, (String)var2_2));
        }
        if (dependency != null) {
            void var3_3;
            return var3_3.getArtifact().getVersion();
        }
        return null;
    }

    public List<Dependency> getManagedDependencies() {
        return Collections.unmodifiableList(this.managedDependencies);
    }

    /*
     * WARNING - void declaration
     */
    private Dependency getManagedDependency(String group, String artifact) {
        void var2_2;
        void var1_1;
        return this.managedDependencyByGroupAndArtifact.get(this.getIdentifier((String)var1_1, (String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    void addManagedDependencies(List<Dependency> dependencies) {
        Iterator iterator;
        this.managedDependencies.addAll(dependencies);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Dependency dependency = (Dependency)iterator.next();
            this.managedDependencyByGroupAndArtifact.put(this.getIdentifier(dependency), (Dependency)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addDependencyManagement(DependencyManagement dependencyManagement) {
        void var1_1;
        for (com.github.igorsuhorukov.springframework.boot.cli.compiler.dependencies.Dependency dependency : dependencyManagement.getDependencies()) {
            void var3_3;
            ArrayList<Exclusion> aetherExclusions = new ArrayList<Exclusion>();
            for (Dependency.Exclusion exclusion : dependency.getExclusions()) {
                aetherExclusions.add(new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*"));
            }
            Dependency aetherDependency = new Dependency((Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), "jar", var3_3.getVersion()), "compile", false, aetherExclusions);
            this.managedDependencies.add(0, aetherDependency);
            this.managedDependencyByGroupAndArtifact.put(this.getIdentifier(aetherDependency), aetherDependency);
        }
        this.dependencyManagement = this.dependencyManagement == null ? dependencyManagement : new CompositeDependencyManagement(new DependencyManagement[]{var1_1, this.dependencyManagement});
        this.artifactCoordinatesResolver = new ArtifactCoordinatesResolver(this.dependencyManagement);
    }
}

