/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.springframework.boot.cli.compiler.maven;

import com.github.igorsuhorukov.apache.maven.model.Activation;
import com.github.igorsuhorukov.apache.maven.model.ActivationFile;
import com.github.igorsuhorukov.apache.maven.model.ActivationOS;
import com.github.igorsuhorukov.apache.maven.model.ActivationProperty;
import com.github.igorsuhorukov.apache.maven.model.Profile;
import com.github.igorsuhorukov.apache.maven.model.building.ModelProblemCollector;
import com.github.igorsuhorukov.apache.maven.model.building.ModelProblemCollectorRequest;
import com.github.igorsuhorukov.apache.maven.model.path.DefaultPathTranslator;
import com.github.igorsuhorukov.apache.maven.model.profile.DefaultProfileSelector;
import com.github.igorsuhorukov.apache.maven.model.profile.ProfileActivationContext;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.FileProfileActivator;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import com.github.igorsuhorukov.apache.maven.model.profile.activation.PropertyProfileActivator;
import com.github.igorsuhorukov.apache.maven.settings.Mirror;
import com.github.igorsuhorukov.apache.maven.settings.Server;
import com.github.igorsuhorukov.apache.maven.settings.Settings;
import com.github.igorsuhorukov.apache.maven.settings.crypto.SettingsDecryptionResult;
import com.github.igorsuhorukov.eclipse.aether.repository.Authentication;
import com.github.igorsuhorukov.eclipse.aether.repository.AuthenticationSelector;
import com.github.igorsuhorukov.eclipse.aether.repository.MirrorSelector;
import com.github.igorsuhorukov.eclipse.aether.repository.Proxy;
import com.github.igorsuhorukov.eclipse.aether.repository.ProxySelector;
import com.github.igorsuhorukov.eclipse.aether.util.repository.AuthenticationBuilder;
import com.github.igorsuhorukov.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import com.github.igorsuhorukov.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import com.github.igorsuhorukov.eclipse.aether.util.repository.DefaultMirrorSelector;
import com.github.igorsuhorukov.eclipse.aether.util.repository.DefaultProxySelector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MavenSettings {
    private final boolean offline;
    private final MirrorSelector mirrorSelector;
    private final AuthenticationSelector authenticationSelector;
    private final ProxySelector proxySelector;
    private final String localRepository;
    private final List<com.github.igorsuhorukov.apache.maven.settings.Profile> activeProfiles;

    /*
     * WARNING - void declaration
     */
    public MavenSettings(Settings settings, SettingsDecryptionResult decryptedSettings) {
        void var1_1;
        void var2_2;
        this.offline = settings.isOffline();
        this.mirrorSelector = MavenSettings.createMirrorSelector(settings);
        this.authenticationSelector = MavenSettings.createAuthenticationSelector(decryptedSettings);
        this.proxySelector = MavenSettings.createProxySelector((SettingsDecryptionResult)var2_2);
        this.localRepository = settings.getLocalRepository();
        this.activeProfiles = this.determineActiveProfiles((Settings)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static MirrorSelector createMirrorSelector(Settings settings) {
        void var1_1;
        Object object;
        DefaultMirrorSelector selector = new DefaultMirrorSelector();
        for (Mirror mirror : ((Settings)object).getMirrors()) {
            void var2_2;
            selector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), var2_2.getMirrorOfLayouts());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static AuthenticationSelector createAuthenticationSelector(SettingsDecryptionResult decryptedSettings) {
        void var1_1;
        Object object;
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        for (Server server : object.getServers()) {
            void var3_3;
            void var2_2;
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(server.getUsername()).addPassword(server.getPassword());
            auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            selector.add(var2_2.getId(), var3_3.build());
        }
        return new ConservativeAuthenticationSelector((AuthenticationSelector)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static ProxySelector createProxySelector(SettingsDecryptionResult decryptedSettings) {
        void var1_1;
        Object object;
        DefaultProxySelector selector = new DefaultProxySelector();
        for (com.github.igorsuhorukov.apache.maven.settings.Proxy proxy : object.getProxies()) {
            void var2_2;
            void var3_3;
            Authentication authentication = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
            selector.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), (Authentication)var3_3), var2_2.getNonProxyHosts());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private List<com.github.igorsuhorukov.apache.maven.settings.Profile> determineActiveProfiles(Settings settings) {
        void var2_2;
        SpringBootCliModelProblemCollector problemCollector = new SpringBootCliModelProblemCollector(0);
        Object object = new DefaultProfileSelector();
        ((DefaultProfileSelector)object).addProfileActivator(new FileProfileActivator().setPathTranslator(new DefaultPathTranslator()));
        ((DefaultProfileSelector)object).addProfileActivator(new JdkVersionProfileActivator());
        ((DefaultProfileSelector)object).addProfileActivator(new PropertyProfileActivator());
        ((DefaultProfileSelector)object).addProfileActivator(new OperatingSystemProfileActivator());
        List<Profile> activeModelProfiles = ((DefaultProfileSelector)object).getActiveProfiles(this.createModelProfiles(settings.getProfiles()), new SpringBootCliProfileActivationContext(settings.getActiveProfiles()), problemCollector);
        if (!problemCollector.getProblems().isEmpty()) {
            throw new IllegalStateException(this.createFailureMessage(problemCollector));
        }
        ArrayList<com.github.igorsuhorukov.apache.maven.settings.Profile> activeProfiles = new ArrayList<com.github.igorsuhorukov.apache.maven.settings.Profile>();
        Map<String, com.github.igorsuhorukov.apache.maven.settings.Profile> profiles = settings.getProfilesAsMap();
        object = object.iterator();
        while (object.hasNext()) {
            Profile modelProfile = (Profile)object.next();
            activeProfiles.add(profiles.get(modelProfile.getId()));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String createFailureMessage(SpringBootCliModelProblemCollector problemCollector) {
        void var2_2;
        Iterator<ModelProblemCollectorRequest> iterator;
        StringWriter message = new StringWriter();
        PrintWriter printer = new PrintWriter(message);
        printer.println("Failed to determine active profiles:");
        for (ModelProblemCollectorRequest problem : ((SpringBootCliModelProblemCollector)((Object)iterator)).getProblems()) {
            printer.println("    " + problem.getMessage() + (problem.getLocation() != null ? " at " + problem.getLocation() : ""));
            if (problem.getException() == null) continue;
            String string = "        ";
            Object object = problem.getException();
            Object object2 = this;
            object2 = object;
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            ((Throwable)object2).printStackTrace(printWriter);
            printer.println(MavenSettings.indentLines(((StringWriter)object).toString(), string));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String indentLines(String input, String indent) {
        void var2_2;
        StringWriter indented = new StringWriter();
        PrintWriter writer = new PrintWriter(indented);
        BufferedReader reader = new BufferedReader(new StringReader(input));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                writer.println(indent + line);
            }
        }
        catch (IOException iOException) {
            String string;
            return string;
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private List<Profile> createModelProfiles(List<com.github.igorsuhorukov.apache.maven.settings.Profile> profiles) {
        void var2_2;
        Iterator iterator;
        ArrayList<Profile> modelProfiles = new ArrayList<Profile>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            com.github.igorsuhorukov.apache.maven.settings.Profile profile = (com.github.igorsuhorukov.apache.maven.settings.Profile)iterator.next();
            Profile modelProfile = new Profile();
            modelProfile.setId(profile.getId());
            if (profile.getActivation() != null) {
                Cloneable cloneable;
                com.github.igorsuhorukov.apache.maven.settings.Activation activation;
                activation = ((com.github.igorsuhorukov.apache.maven.settings.Profile)((Object)activation)).getActivation();
                Activation activation2 = new Activation();
                activation2.setActiveByDefault(activation.isActiveByDefault());
                if (activation.getFile() != null) {
                    cloneable = new ActivationFile();
                    ((ActivationFile)cloneable).setExists(activation.getFile().getExists());
                    ((ActivationFile)cloneable).setMissing(activation.getFile().getMissing());
                    activation2.setFile((ActivationFile)cloneable);
                }
                activation2.setJdk(activation.getJdk());
                if (activation.getOs() != null) {
                    cloneable = new ActivationOS();
                    ((ActivationOS)cloneable).setArch(activation.getOs().getArch());
                    ((ActivationOS)cloneable).setFamily(activation.getOs().getFamily());
                    ((ActivationOS)cloneable).setName(activation.getOs().getName());
                    ((ActivationOS)cloneable).setVersion(activation.getOs().getVersion());
                    activation2.setOs((ActivationOS)cloneable);
                }
                if (activation.getProperty() != null) {
                    cloneable = new ActivationProperty();
                    ((ActivationProperty)cloneable).setName(activation.getProperty().getName());
                    ((ActivationProperty)cloneable).setValue(activation.getProperty().getValue());
                    activation2.setProperty((ActivationProperty)cloneable);
                }
                modelProfile.setActivation(activation2);
            }
            modelProfiles.add(modelProfile);
        }
        return var2_2;
    }

    public final boolean getOffline() {
        return this.offline;
    }

    public final MirrorSelector getMirrorSelector() {
        return this.mirrorSelector;
    }

    public final AuthenticationSelector getAuthenticationSelector() {
        return this.authenticationSelector;
    }

    public final ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    public final String getLocalRepository() {
        return this.localRepository;
    }

    public final List<com.github.igorsuhorukov.apache.maven.settings.Profile> getActiveProfiles() {
        return this.activeProfiles;
    }

    static final class SpringBootCliModelProblemCollector
    implements ModelProblemCollector {
        private final List<ModelProblemCollectorRequest> problems = new ArrayList<ModelProblemCollectorRequest>();

        private SpringBootCliModelProblemCollector() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void add(ModelProblemCollectorRequest req) {
            void var1_1;
            this.problems.add((ModelProblemCollectorRequest)var1_1);
        }

        final List<ModelProblemCollectorRequest> getProblems() {
            return this.problems;
        }

        /* synthetic */ SpringBootCliModelProblemCollector(byte by) {
            this();
        }
    }

    static final class SpringBootCliProfileActivationContext
    implements ProfileActivationContext {
        private final List<String> activeProfiles;

        /*
         * WARNING - void declaration
         */
        SpringBootCliProfileActivationContext(List<String> activeProfiles) {
            void var1_1;
            this.activeProfiles = var1_1;
        }

        @Override
        public final List<String> getActiveProfileIds() {
            return this.activeProfiles;
        }

        @Override
        public final List<String> getInactiveProfileIds() {
            return Collections.emptyList();
        }

        @Override
        public final Map<String, String> getSystemProperties() {
            return System.getProperties();
        }

        @Override
        public final Map<String, String> getUserProperties() {
            return Collections.emptyMap();
        }

        @Override
        public final File getProjectDirectory() {
            return new File(".");
        }

        @Override
        public final Map<String, String> getProjectProperties() {
            return Collections.emptyMap();
        }
    }
}

