/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.springframework.boot.cli.compiler.maven;

import com.github.igorsuhorukov.apache.maven.settings.Settings;
import com.github.igorsuhorukov.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import com.github.igorsuhorukov.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import com.github.igorsuhorukov.apache.maven.settings.building.SettingsBuildingException;
import com.github.igorsuhorukov.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import com.github.igorsuhorukov.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import com.github.igorsuhorukov.apache.maven.settings.crypto.SettingsDecryptionRequest;
import com.github.igorsuhorukov.apache.maven.settings.crypto.SettingsDecryptionResult;
import com.github.igorsuhorukov.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import com.github.igorsuhorukov.sonatype.plexus.components.cipher.PlexusCipherException;
import com.github.igorsuhorukov.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import com.github.igorsuhorukov.springframework.boot.cli.compiler.maven.MavenSettings;
import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;

public final class MavenSettingsReader {
    private final String homeDir;

    public MavenSettingsReader() {
        this(System.getProperty("user.home"));
    }

    /*
     * WARNING - void declaration
     */
    private MavenSettingsReader(String homeDir) {
        void var1_1;
        this.homeDir = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final MavenSettings readSettings() {
        void var1_1;
        Settings settings = this.loadSettings();
        Object object = settings;
        Object object2 = this;
        object = new DefaultSettingsDecryptionRequest((Settings)object);
        DefaultSettingsDecrypter defaultSettingsDecrypter = new DefaultSettingsDecrypter();
        MavenSettingsReader.setField(DefaultSettingsDecrypter.class, "securityDispatcher", defaultSettingsDecrypter, new SpringBootSecDispatcher((MavenSettingsReader)object2));
        SettingsDecryptionResult decrypted = defaultSettingsDecrypter.decrypt((SettingsDecryptionRequest)object);
        if (!decrypted.getProblems().isEmpty()) {
            object2 = "Maven settings decryption failed. Some Maven repositories may be inaccessible";
            System.err.println((String)object2);
        }
        if (Boolean.getBoolean("mavenSettings.offline")) {
            settings.setOffline(true);
        }
        return new MavenSettings((Settings)var1_1, (SettingsDecryptionResult)object);
    }

    /*
     * WARNING - void declaration
     */
    private Settings loadSettings() {
        MavenSettingsReader mavenSettingsReader = this;
        String string = System.getProperty("mavenSettings");
        File settingsFile = string != null && !string.isEmpty() ? new File(string) : new File(mavenSettingsReader.homeDir, ".m2/settings.xml");
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        request.setUserSettingsFile(settingsFile);
        request.setSystemProperties(System.getProperties());
        try {
            return new DefaultSettingsBuilderFactory().newInstance().build(request).getEffectiveSettings();
        }
        catch (SettingsBuildingException ex) {
            void var2_3;
            throw new IllegalStateException("Failed to build settings from " + mavenSettingsReader, (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void setField(Class<?> sourceClass, String fieldName, Object target, Object value) {
        try {
            void var3_4;
            AnnotatedElement field = sourceClass.getDeclaredField(fieldName);
            ((Field)field).setAccessible(true);
            ((Field)field).set(target, var3_4);
            return;
        }
        catch (Exception ex) {
            void var0_1;
            void var2_3;
            void var1_2;
            throw new IllegalStateException("Failed to set field '" + (String)var1_2 + "' on '" + var2_3 + "'", (Throwable)var0_1);
        }
    }

    static /* synthetic */ File access$000(MavenSettingsReader x0) {
        MavenSettingsReader mavenSettingsReader = x0;
        String string = System.getProperty("mavenSettingsSecurity");
        if (string != null && !string.isEmpty()) {
            return new File(string);
        }
        return new File(mavenSettingsReader.homeDir, ".m2/settings-security.xml");
    }

    final class SpringBootSecDispatcher
    extends DefaultSecDispatcher {
        /*
         * WARNING - void declaration
         */
        SpringBootSecDispatcher(MavenSettingsReader mavenSettingsReader) {
            File file = MavenSettingsReader.access$000(mavenSettingsReader);
            this._configurationFile = file.getAbsolutePath();
            try {
                this._cipher = new DefaultPlexusCipher();
                return;
            }
            catch (PlexusCipherException e) {
                void var1_2;
                throw new IllegalStateException((Throwable)var1_2);
            }
        }
    }
}

