/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.url.handler.loadable;

import com.github.igorsuhorukov.google.common.cache.CacheBuilder;
import com.github.igorsuhorukov.google.common.cache.CacheLoader;
import com.github.igorsuhorukov.google.common.cache.LoadingCache;
import com.github.igorsuhorukov.service.MavenServiceLoader;
import com.github.igorsuhorukov.url.handler.ChainURLStreamHandlerFactory;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;

public class LoadableURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Logger logger = Logger.getLogger(LoadableURLStreamHandlerFactory.class.getName());
    public static final String HANDLER_FACTORT_ARTIFACT = "com.github.igor-suhorukov:%s-url-handler:LATEST";
    static final Set<String> SKIP_LIST = new TreeSet<String>(){
        {
            this.add("mvn");
            this.add("file");
            this.add("jar");
            this.add("http");
            this.add("https");
            this.add("ftp");
            this.add("mailto");
        }
    };
    private static LoadingCache<String, URLStreamHandlerFactory> urlStreamHandlerFactoryLoadingCache = CacheBuilder.newBuilder().build(new CacheLoader<String, URLStreamHandlerFactory>(){

        @Override
        public URLStreamHandlerFactory load(String protocol) throws Exception {
            return LoadableURLStreamHandlerFactory.loadUrlStreamHandlerFactory(protocol);
        }
    });

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol != null && !SKIP_LIST.contains(protocol.toLowerCase())) {
            try {
                URLStreamHandlerFactory urlStreamHandlerFactory = urlStreamHandlerFactoryLoadingCache.get(protocol);
                return urlStreamHandlerFactory != null ? urlStreamHandlerFactory.createURLStreamHandler(protocol) : null;
            }
            catch (ExecutionException e) {
                logger.severe(e.getMessage());
            }
        }
        return null;
    }

    static URLStreamHandlerFactory loadUrlStreamHandlerFactory(String protocol) {
        String artifact = System.getProperty(protocol + "MvnUrlHandler", String.format(HANDLER_FACTORT_ARTIFACT, protocol));
        Collection<URLStreamHandlerFactory> urlStreamHandlerFactories = MavenServiceLoader.loadServices(artifact, URLStreamHandlerFactory.class);
        if (urlStreamHandlerFactories.isEmpty()) {
            return null;
        }
        if (urlStreamHandlerFactories.size() == 1) {
            return urlStreamHandlerFactories.iterator().next();
        }
        URLStreamHandlerFactory[] streamHandlerFactories = urlStreamHandlerFactories.toArray(new URLStreamHandlerFactory[urlStreamHandlerFactories.size()]);
        return new ChainURLStreamHandlerFactory(streamHandlerFactories);
    }
}

