/*
 * Decompiled with CFR 0.152.
 */
package com.github.igorsuhorukov.url.handler.mvn;

import com.github.igorsuhorukov.url.handler.mvn.Handler;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.logging.Logger;

public class MavenURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Logger logger = Logger.getLogger(MavenURLStreamHandlerFactory.class.getName());
    public static final String MVN_PROTOCOL = "mvn";
    protected URLStreamHandlerFactory urlStreamHandlerFactory;

    public MavenURLStreamHandlerFactory() {
    }

    public MavenURLStreamHandlerFactory(URLStreamHandlerFactory urlStreamHandlerFactory) {
        this.urlStreamHandlerFactory = urlStreamHandlerFactory;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (MVN_PROTOCOL.equals(protocol)) {
            return new Handler();
        }
        if (this.urlStreamHandlerFactory != null) {
            try {
                return this.urlStreamHandlerFactory.createURLStreamHandler(protocol);
            }
            catch (Exception ignore) {
                logger.warning(ignore.getMessage());
                return null;
            }
        }
        return null;
    }
}

