/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore.lodash;

import com.github.underscore.BiFunction;
import com.github.underscore.Function;
import com.github.underscore.lodash.Base32;
import com.github.underscore.lodash.U;
import com.sun.org.apache.xerces.internal.util.XMLChar;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Xml {
    private static final String NULL = "null";
    private static final String ELEMENT_TEXT = "element";
    private static final String CDATA = "#cdata-section";
    private static final String COMMENT = "#comment";
    private static final String ENCODING = "#encoding";
    private static final String STANDALONE = "#standalone";
    private static final String OMITXMLDECLARATION = "#omit-xml-declaration";
    private static final String YES = "yes";
    private static final String TEXT = "#text";
    private static final String NUMBER = "-number";
    private static final String ELEMENT = "<element>";
    private static final String CLOSED_ELEMENT = "</element>";
    private static final String EMPTY_ELEMENT = "<element></element>";
    private static final String NULL_TRUE = " null=\"true\"/>";
    private static final String NUMBER_TEXT = " number=\"true\"";
    private static final String NUMBER_TRUE = " number=\"true\">";
    private static final String ARRAY = "-array";
    private static final String ARRAY_TRUE = " array=\"true\"";
    private static final String NULL_ELEMENT = "<element null=\"true\"/>";
    private static final String BOOLEAN = "-boolean";
    private static final String TRUE = "true";
    private static final String SELF_CLOSING = "-self-closing";
    private static final String STRING = "-string";
    private static final String NULL_ATTR = "-null";
    private static final String EMPTY_ARRAY = "-empty-array";
    private static final String QUOT = "&quot;";
    private static final String XML_HEADER = "<?xml ";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Pattern ATTRS = Pattern.compile("((?:(?!\\s|=).)*)\\s*?=\\s*?[\"']?((?:(?<=\")(?:(?<=\\\\)\"|[^\"])*|(?<=')(?:(?<=\\\\)'|[^'])*)|(?:(?!\"|')(?:(?!\\/>|>|\\s).)+))");
    private static final Map<String, String> XML_UNESCAPE = new HashMap<String, String>();

    public static String toXml(Collection collection, XmlStringBuilder.Step identStep) {
        XmlStringBuilderWithoutRoot builder = new XmlStringBuilderWithoutRoot(identStep, UTF_8.name(), "");
        Xml.writeArray(collection, builder);
        return ((XmlStringBuilder)builder).toString();
    }

    public static String toXml(Collection collection) {
        return Xml.toXml(collection, XmlStringBuilder.Step.TWO_SPACES);
    }

    public static String toXml(Map map, XmlStringBuilder.Step identStep) {
        XmlStringBuilder builder;
        Map localMap;
        if (map != null && map.containsKey(ENCODING)) {
            localMap = (Map)U.clone(map);
            builder = Xml.checkStandalone(String.valueOf(localMap.remove(ENCODING)), identStep, localMap);
        } else if (map != null && map.containsKey(STANDALONE)) {
            localMap = (Map)U.clone(map);
            builder = new XmlStringBuilderWithoutRoot(identStep, UTF_8.name(), " standalone=\"" + (YES.equals(map.get(STANDALONE)) ? YES : "no") + "\"");
            localMap.remove(STANDALONE);
        } else if (map != null && map.containsKey(OMITXMLDECLARATION)) {
            localMap = (Map)U.clone(map);
            builder = new XmlStringBuilderWithoutHeader(identStep, 0);
            localMap.remove(OMITXMLDECLARATION);
        } else {
            builder = new XmlStringBuilderWithoutRoot(identStep, UTF_8.name(), "");
            localMap = map;
        }
        Xml.checkLocalMap(builder, localMap);
        return builder.toString();
    }

    private static void checkLocalMap(XmlStringBuilder builder, Map localMap) {
        if (localMap == null || localMap.size() != 1 || XmlValue.getMapKey(localMap).startsWith("-") || XmlValue.getMapValue(localMap) instanceof List) {
            if ("root".equals(XmlValue.getMapKey(localMap))) {
                Xml.writeArray((List)XmlValue.getMapValue(localMap), builder);
            } else {
                XmlObject.writeXml(localMap, Xml.getRootName(localMap), builder, false, U.<String>newLinkedHashSet(), false);
            }
        } else {
            XmlObject.writeXml(localMap, null, builder, false, U.<String>newLinkedHashSet(), false);
        }
    }

    private static void writeArray(Collection collection, XmlStringBuilder builder) {
        builder.append("<root");
        if (collection != null && collection.isEmpty()) {
            builder.append(" empty-array=\"true\"");
        }
        builder.append(">").incIdent();
        if (collection != null && !collection.isEmpty()) {
            builder.newLine();
        }
        XmlArray.writeXml(collection, null, builder, false, U.<String>newLinkedHashSet(), false);
        if (collection != null && !collection.isEmpty()) {
            builder.newLine();
        }
        builder.append("</root>");
    }

    private static XmlStringBuilder checkStandalone(String encoding, XmlStringBuilder.Step identStep, Map localMap) {
        XmlStringBuilderWithoutRoot builder;
        if (localMap.containsKey(STANDALONE)) {
            builder = new XmlStringBuilderWithoutRoot(identStep, encoding, " standalone=\"" + (YES.equals(localMap.get(STANDALONE)) ? YES : "no") + "\"");
            localMap.remove(STANDALONE);
        } else {
            builder = new XmlStringBuilderWithoutRoot(identStep, encoding, "");
        }
        return builder;
    }

    private static String getRootName(Map localMap) {
        int foundAttrs = 0;
        int foundElements = 0;
        if (localMap != null) {
            for (Map.Entry entry : localMap.entrySet()) {
                if (String.valueOf(entry.getKey()).startsWith("-")) {
                    ++foundAttrs;
                    continue;
                }
                if (String.valueOf(entry.getKey()).startsWith(COMMENT) || entry.getValue() instanceof List && ((List)entry.getValue()).size() > 1) continue;
                ++foundElements;
            }
        }
        return foundAttrs == 0 && foundElements == 1 ? null : "root";
    }

    public static String toXml(Map map) {
        return Xml.toXml(map, XmlStringBuilder.Step.TWO_SPACES);
    }

    private static Object getValue(Object value) {
        Map.Entry entry;
        Object localValue = value instanceof Map && ((Map)value).entrySet().size() == 1 ? (TEXT.equals((entry = ((Map)value).entrySet().iterator().next()).getKey()) || ((String)entry.getKey()).equals(ELEMENT_TEXT) ? entry.getValue() : value) : value;
        return localValue instanceof String ? XmlValue.unescape((String)localValue) : localValue;
    }

    private static Object stringToNumber(String number) {
        Number localValue = number.contains(".") || number.contains("e") || number.contains("E") ? (Number)(number.length() > 9 ? new BigDecimal(number) : Double.valueOf(number)) : (Number)(number.length() > 20 ? new BigInteger(number) : Long.valueOf(number));
        return localValue;
    }

    private static Object createMap(Node node, BiFunction<Object, Set<String>, String> elementMapper, Function<Object, Object> nodeMapper, Map<String, Object> attrMap, int[] uniqueIds, String source, int[] sourceIndex, Set<String> namespaces) {
        Map<String, Object> map = U.newLinkedHashMap();
        map.putAll(attrMap);
        NodeList nodeList = node.getChildNodes();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Object value;
            Node currentNode = nodeList.item(index);
            String name = currentNode.getNodeType() == 7 ? "?" + currentNode.getNodeName() : currentNode.getNodeName();
            if (currentNode.getNodeType() == 1) {
                sourceIndex[0] = source.indexOf("<" + name, sourceIndex[0]) + name.length() + 1;
                value = Xml.addElement(sourceIndex, source, elementMapper, nodeMapper, uniqueIds, currentNode, namespaces);
            } else {
                if (COMMENT.equals(name)) {
                    sourceIndex[0] = source.indexOf("-->", sourceIndex[0]) + 3;
                } else if (CDATA.equals(name)) {
                    sourceIndex[0] = source.indexOf("]]>", sourceIndex[0]) + 3;
                }
                value = currentNode.getTextContent();
            }
            if (TEXT.equals(name) && node.getChildNodes().getLength() > 1 && String.valueOf(value).trim().isEmpty() || currentNode.getNodeType() == 10) continue;
            Xml.addNodeValue(map, name, value, elementMapper, nodeMapper, uniqueIds, namespaces);
        }
        return Xml.checkNumberAndBoolean(map, node.getNodeName());
    }

    private static Object checkNumberAndBoolean(Map<String, Object> map, String name) {
        Map localMap2;
        Map localMap;
        if (map.containsKey(NUMBER) && TRUE.equals(map.get(NUMBER)) && map.containsKey(TEXT)) {
            localMap = (Map)((LinkedHashMap)map).clone();
            localMap.remove(NUMBER);
            localMap.put(TEXT, Xml.stringToNumber(String.valueOf(localMap.get(TEXT))));
        } else {
            localMap = map;
        }
        if (map.containsKey(BOOLEAN) && TRUE.equals(map.get(BOOLEAN)) && map.containsKey(TEXT)) {
            localMap2 = (Map)((LinkedHashMap)localMap).clone();
            localMap2.remove(BOOLEAN);
            localMap2.put(TEXT, Boolean.valueOf(String.valueOf(localMap.get(TEXT))));
        } else {
            localMap2 = localMap;
        }
        return Xml.checkArray(localMap2, name);
    }

    private static Object checkArray(Map<String, Object> map, String name) {
        List object2;
        Object object;
        Map<String, Object> localMap = Xml.checkNullAndString(map);
        if (map.containsKey(ARRAY) && TRUE.equals(map.get(ARRAY))) {
            Map localMap4 = (Map)((LinkedHashMap)localMap).clone();
            localMap4.remove(ARRAY);
            object = name.equals(XmlValue.getMapKey(localMap4)) ? U.newArrayList(Arrays.asList(Xml.getValue(XmlValue.getMapValue(localMap4)))) : U.newArrayList(Arrays.asList(Xml.getValue(localMap4)));
        } else {
            object = localMap;
        }
        if (map.containsKey(EMPTY_ARRAY) && TRUE.equals(map.get(EMPTY_ARRAY))) {
            Map localMap4 = (Map)((LinkedHashMap)map).clone();
            localMap4.remove(EMPTY_ARRAY);
            if (localMap4.containsKey(ARRAY) && TRUE.equals(localMap4.get(ARRAY)) && localMap4.size() == 1) {
                object2 = U.newArrayList();
                object2.add(U.newArrayList());
            } else {
                object2 = localMap4.isEmpty() ? U.newArrayList() : localMap4;
            }
        } else {
            object2 = object;
        }
        return object2;
    }

    private static Map<String, Object> checkNullAndString(Map<String, Object> map) {
        Map localMap2;
        Map localMap;
        if (map.containsKey(NULL_ATTR) && TRUE.equals(map.get(NULL_ATTR))) {
            localMap = (Map)((LinkedHashMap)map).clone();
            localMap.remove(NULL_ATTR);
            if (!map.containsKey(TEXT)) {
                localMap.put(TEXT, null);
            }
        } else {
            localMap = map;
        }
        if (map.containsKey(STRING) && TRUE.equals(map.get(STRING))) {
            localMap2 = (Map)((LinkedHashMap)localMap).clone();
            localMap2.remove(STRING);
            if (!map.containsKey(TEXT)) {
                localMap2.put(TEXT, "");
            }
        } else {
            localMap2 = localMap;
        }
        return localMap2;
    }

    private static Object addElement(int[] sourceIndex, String source, BiFunction<Object, Set<String>, String> elementMapper, Function<Object, Object> nodeMapper, int[] uniqueIds, Node currentNode, Set<String> namespaces) {
        Map<String, Object> attrMapLocal = U.newLinkedHashMap();
        if (currentNode.getAttributes().getLength() > 0) {
            Matcher matcher = ATTRS.matcher(Xml.getAttributes(sourceIndex[0], source));
            while (matcher.find()) {
                if (!matcher.group(1).startsWith("xmlns:")) continue;
                namespaces.add(matcher.group(1).substring(6));
            }
            matcher.reset();
            while (matcher.find()) {
                Xml.addNodeValue(attrMapLocal, '-' + matcher.group(1), matcher.group(2), elementMapper, nodeMapper, uniqueIds, namespaces);
            }
        }
        if (!(!Xml.getAttributes(sourceIndex[0], source).endsWith("/") || attrMapLocal.containsKey(SELF_CLOSING) || attrMapLocal.size() == 1 && (attrMapLocal.containsKey(STRING) && TRUE.equals(attrMapLocal.get(STRING)) || attrMapLocal.containsKey(NULL_ATTR) && TRUE.equals(attrMapLocal.get(NULL_ATTR))))) {
            attrMapLocal.put(SELF_CLOSING, TRUE);
        }
        return Xml.createMap(currentNode, elementMapper, nodeMapper, attrMapLocal, uniqueIds, source, sourceIndex, namespaces);
    }

    static String getAttributes(int sourceIndex, String source) {
        boolean scanQuote = false;
        for (int index = sourceIndex; index < source.length(); ++index) {
            if (source.charAt(index) == '\"') {
                scanQuote = !scanQuote;
                continue;
            }
            if (scanQuote || source.charAt(index) != '>') continue;
            return source.substring(sourceIndex, index);
        }
        return "";
    }

    private static void addNodeValue(Map<String, Object> map, String name, Object value, BiFunction<Object, Set<String>, String> elementMapper, Function<Object, Object> nodeMapper, int[] uniqueIds, Set<String> namespaces) {
        if (map.containsKey(name)) {
            if (TEXT.equals(name)) {
                map.put(name + uniqueIds[0], nodeMapper.apply(Xml.getValue(value)));
                uniqueIds[0] = uniqueIds[0] + 1;
            } else if (COMMENT.equals(name)) {
                map.put(name + uniqueIds[1], nodeMapper.apply(Xml.getValue(value)));
                uniqueIds[1] = uniqueIds[1] + 1;
            } else if (CDATA.equals(name)) {
                map.put(name + uniqueIds[2], nodeMapper.apply(Xml.getValue(value)));
                uniqueIds[2] = uniqueIds[2] + 1;
            } else {
                Object object = map.get(name);
                if (object instanceof List) {
                    Xml.addText(map, name, (List)object, value);
                } else {
                    List<Object> objects = U.newArrayList();
                    objects.add(object);
                    Xml.addText(map, name, objects, value);
                    map.put(name, objects);
                }
            }
        } else {
            String elementName = elementMapper.apply(name, namespaces);
            if (elementName != null) {
                map.put(elementName, nodeMapper.apply(Xml.getValue(value)));
            }
        }
    }

    private static void addText(Map<String, Object> map, String name, List<Object> objects, Object value) {
        Map.Entry lastElement;
        int lastIndex = map.size() - 1;
        int index = objects.size();
        while (!name.equals(String.valueOf((lastElement = (Map.Entry)map.entrySet().toArray()[lastIndex]).getKey()))) {
            Map item = U.newLinkedHashMap();
            Map text = U.newLinkedHashMap();
            text.put(String.valueOf(lastElement.getKey()), map.remove(lastElement.getKey()));
            item.put("#item", text);
            objects.add(index, item);
            --lastIndex;
        }
        Object newValue = Xml.getValue(value);
        if (newValue instanceof List) {
            objects.add(((List)newValue).get(0));
        } else {
            objects.add(newValue);
        }
    }

    public static Object fromXml(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            Document document = Xml.createDocument(xml);
            Object result = Xml.createMap(document, new BiFunction<Object, Set<String>, String>(){

                @Override
                public String apply(Object object, Set<String> namespaces) {
                    return String.valueOf(object);
                }
            }, new Function<Object, Object>(){

                @Override
                public Object apply(Object object) {
                    return object;
                }
            }, Collections.<String, Object>emptyMap(), new int[]{1, 1, 1}, xml, new int[]{0}, U.<String>newLinkedHashSet());
            if (Xml.checkResult(xml, document, result)) {
                return ((Map)result).entrySet().iterator().next().getValue();
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static boolean checkResult(String xml, Document document, Object result) {
        Map<String, String> headerAttributes = Xml.getHeaderAttributes(xml);
        if (document.getXmlEncoding() != null && !"UTF-8".equalsIgnoreCase(document.getXmlEncoding())) {
            ((Map)result).put(ENCODING, document.getXmlEncoding());
            if (headerAttributes.containsKey(STANDALONE.substring(1))) {
                ((Map)result).put(STANDALONE, headerAttributes.get(STANDALONE.substring(1)));
            }
        } else if (headerAttributes.containsKey(STANDALONE.substring(1))) {
            ((Map)result).put(STANDALONE, headerAttributes.get(STANDALONE.substring(1)));
        } else if (((Map)result).entrySet().iterator().next().getKey().equals("root") && (((Map)result).entrySet().iterator().next().getValue() instanceof List || ((Map)result).entrySet().iterator().next().getValue() instanceof Map)) {
            if (xml.startsWith(XML_HEADER)) {
                return true;
            }
            ((Map)result).put(OMITXMLDECLARATION, YES);
        } else if (!xml.startsWith(XML_HEADER)) {
            ((Map)result).put(OMITXMLDECLARATION, YES);
        }
        return false;
    }

    private static Map<String, String> getHeaderAttributes(String xml) {
        Map<String, String> result = U.newLinkedHashMap();
        if (xml.startsWith(XML_HEADER)) {
            String xmlLocal = xml.substring(XML_HEADER.length(), Math.max(XML_HEADER.length(), xml.indexOf("?>", XML_HEADER.length())));
            Matcher matcher = ATTRS.matcher(xmlLocal);
            while (matcher.find()) {
                result.put(matcher.group(1), matcher.group(2));
            }
        }
        return result;
    }

    private static Document createDocument(String xml) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new DefaultHandler());
        return builder.parse(new InputSource(new StringReader(xml)));
    }

    public static Object fromXmlMakeArrays(String xml) {
        try {
            Document document = Xml.createDocument(xml);
            Object result = Xml.createMap(document, new BiFunction<Object, Set<String>, String>(){

                @Override
                public String apply(Object object, Set<String> namespaces) {
                    return String.valueOf(object);
                }
            }, new Function<Object, Object>(){

                @Override
                public Object apply(Object object) {
                    return object instanceof List ? object : U.newArrayList(Arrays.asList(object));
                }
            }, Collections.<String, Object>emptyMap(), new int[]{1, 1, 1}, xml, new int[]{0}, U.<String>newLinkedHashSet());
            if (Xml.checkResult(xml, document, result)) {
                return ((Map)result).entrySet().iterator().next().getValue();
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static Object fromXmlWithElementMapper(String xml, BiFunction<Object, Set<String>, String> elementMapper) {
        try {
            Document document = Xml.createDocument(xml);
            Object result = Xml.createMap(document, elementMapper, new Function<Object, Object>(){

                @Override
                public Object apply(Object object) {
                    return object;
                }
            }, Collections.<String, Object>emptyMap(), new int[]{1, 1, 1}, xml, new int[]{0}, U.<String>newLinkedHashSet());
            if (Xml.checkResult(xml, document, result)) {
                return ((Map)result).entrySet().iterator().next().getValue();
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static Object fromXmlWithoutNamespaces(String xml) {
        return Xml.fromXmlWithElementMapper(xml, new BiFunction<Object, Set<String>, String>(){

            @Override
            public String apply(Object object, Set<String> namespaces) {
                String localString = String.valueOf(object);
                String result = localString.startsWith("-") && namespaces.contains(localString.substring(1, Math.max(1, localString.indexOf(58)))) ? "-" + localString.substring(Math.max(0, localString.indexOf(58) + 1)) : (namespaces.contains(localString.substring(0, Math.max(0, localString.indexOf(58)))) ? localString.substring(Math.max(0, localString.indexOf(58) + 1)) : String.valueOf(object));
                return result;
            }
        });
    }

    public static Object fromXmlWithoutAttributes(String xml) {
        return Xml.fromXmlWithElementMapper(xml, new BiFunction<Object, Set<String>, String>(){

            @Override
            public String apply(Object object, Set<String> namespaces) {
                return String.valueOf(object).startsWith("-") ? null : String.valueOf(object);
            }
        });
    }

    public static Object fromXmlWithoutNamespacesAndAttributes(String xml) {
        return Xml.fromXmlWithElementMapper(xml, new BiFunction<Object, Set<String>, String>(){

            @Override
            public String apply(Object object, Set<String> namespaces) {
                String localString = String.valueOf(object);
                String result = localString.startsWith("-") ? null : (namespaces.contains(localString.substring(0, Math.max(0, localString.indexOf(58)))) ? localString.substring(Math.max(0, localString.indexOf(58) + 1)) : String.valueOf(object));
                return result;
            }
        });
    }

    public static String formatXml(String xml, XmlStringBuilder.Step identStep) {
        Object result = Xml.fromXml(xml);
        if (result instanceof Map) {
            return Xml.toXml((Map)result, identStep);
        }
        return Xml.toXml((List)result, identStep);
    }

    public static String formatXml(String xml) {
        return Xml.formatXml(xml, XmlStringBuilder.Step.THREE_SPACES);
    }

    static {
        XML_UNESCAPE.put(QUOT, "\"");
        XML_UNESCAPE.put("&amp;", "&");
        XML_UNESCAPE.put("&lt;", "<");
        XML_UNESCAPE.put("&gt;", ">");
        XML_UNESCAPE.put("&apos;", "'");
    }

    public static class XmlValue {
        public static void writeXml(Object value, String name, XmlStringBuilder builder, boolean parentTextFound, Set<String> namespaces, boolean addArray) {
            if (value instanceof Map) {
                XmlObject.writeXml((Map)value, name, builder, parentTextFound, namespaces, addArray);
                return;
            }
            if (value instanceof Collection) {
                XmlArray.writeXml((Collection)value, name, builder, parentTextFound, namespaces, addArray);
                return;
            }
            if (!parentTextFound) {
                builder.fillSpaces();
            }
            if (value == null) {
                builder.append("<" + XmlValue.escapeName(name, namespaces) + Xml.NULL_TRUE);
            } else if (value instanceof String) {
                if (((String)value).isEmpty()) {
                    builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? Xml.ARRAY_TRUE : "") + " string=\"true\"/>");
                } else {
                    builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? Xml.ARRAY_TRUE : "") + (name.startsWith("?") ? " " : ">"));
                    builder.append(XmlValue.escape((String)value));
                    if (name.startsWith("?")) {
                        builder.append("?>");
                    } else {
                        builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
                    }
                }
            } else {
                XmlValue.processArrays(value, builder, name, parentTextFound, namespaces, addArray);
            }
        }

        private static void processArrays(Object value, XmlStringBuilder builder, String name, boolean parentTextFound, Set<String> namespaces, boolean addArray) {
            if (value instanceof Double) {
                if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                    builder.append(Xml.NULL_ELEMENT);
                } else {
                    builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? Xml.ARRAY_TRUE : "") + Xml.NUMBER_TRUE);
                    builder.append(value.toString());
                    builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
                }
            } else if (value instanceof Float) {
                if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                    builder.append(Xml.NULL_ELEMENT);
                } else {
                    builder.append("<" + XmlValue.escapeName(name, namespaces) + Xml.NUMBER_TRUE);
                    builder.append(value.toString());
                    builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
                }
            } else if (value instanceof Number) {
                builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? Xml.ARRAY_TRUE : "") + Xml.NUMBER_TRUE);
                builder.append(value.toString());
                builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
            } else if (value instanceof Boolean) {
                builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? Xml.ARRAY_TRUE : "") + " boolean=\"true\">");
                builder.append(value.toString());
                builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
            } else {
                builder.append("<" + XmlValue.escapeName(name, namespaces) + ">");
                if (value instanceof byte[]) {
                    builder.newLine().incIdent();
                    XmlArray.writeXml((byte[])value, builder);
                    builder.decIdent().newLine().fillSpaces();
                } else if (value instanceof short[]) {
                    builder.newLine().incIdent();
                    XmlArray.writeXml((short[])value, builder);
                    builder.decIdent().newLine().fillSpaces();
                } else {
                    XmlValue.processArrays2(value, builder, name, parentTextFound, namespaces);
                }
                builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
            }
        }

        private static void processArrays2(Object value, XmlStringBuilder builder, String name, boolean parentTextFound, Set<String> namespaces) {
            if (value instanceof int[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((int[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof long[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((long[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof float[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((float[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof double[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((double[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof boolean[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((boolean[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof char[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((char[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof Object[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((Object[])value, name, builder, parentTextFound, namespaces);
                builder.decIdent().newLine().fillSpaces();
            } else {
                builder.append(value.toString());
            }
        }

        public static String escapeName(String name, Set<String> namespaces) {
            int length = name.length();
            if (length == 0) {
                return "__EE__EMPTY__EE__";
            }
            StringBuilder result = new StringBuilder();
            char ch = name.charAt(0);
            if (XMLChar.isNameStart(ch) && ch != ':' || ch == '?') {
                result.append(ch);
            } else {
                result.append("__").append(Base32.encode(Character.toString(ch))).append("__");
            }
            for (int i = 1; i < length; ++i) {
                ch = name.charAt(i);
                if (ch == ':' && ("xmlns".equals(name.substring(0, i)) || namespaces.contains(name.substring(0, i)))) {
                    result.append(ch);
                    continue;
                }
                if (XMLChar.isName(ch) && ch != ':') {
                    result.append(ch);
                    continue;
                }
                result.append("__").append(Base32.encode(Character.toString(ch))).append("__");
            }
            return result.toString();
        }

        public static String escape(String s) {
            if (s == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            XmlValue.escape(s, sb);
            return sb.toString();
        }

        private static void escape(String s, StringBuilder sb) {
            int len = s.length();
            block12: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\'': {
                        sb.append("'");
                        continue block12;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block12;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block12;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block12;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block12;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block12;
                    }
                    case '\n': {
                        sb.append("\n");
                        continue block12;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block12;
                    }
                    case '\t': {
                        sb.append("\t");
                        continue block12;
                    }
                    case '\u20ac': {
                        sb.append("\u20ac");
                        continue block12;
                    }
                    default: {
                        if (ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                            String ss = Integer.toHexString(ch);
                            sb.append("&#x");
                            for (int k = 0; k < 4 - ss.length(); ++k) {
                                sb.append('0');
                            }
                            sb.append(ss.toUpperCase()).append(";");
                            continue block12;
                        }
                        sb.append(ch);
                    }
                }
            }
        }

        public static String unescape(String s) {
            if (s == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            XmlValue.unescape(s, sb);
            return sb.toString();
        }

        private static void unescape(String s, StringBuilder sb) {
            int len = s.length();
            StringBuilder localSb = new StringBuilder();
            int index = 0;
            while (index < len) {
                int skipChars = XmlValue.translate(s, index, localSb);
                if (skipChars > 0) {
                    sb.append((CharSequence)localSb);
                    localSb.setLength(0);
                    index += skipChars;
                    continue;
                }
                sb.append(s.charAt(index));
                ++index;
            }
        }

        private static int translate(CharSequence input, int index, StringBuilder builder) {
            int shortest = 4;
            int longest = 6;
            if ('&' == input.charAt(index)) {
                int max = 6;
                if (index + 6 > input.length()) {
                    max = input.length() - index;
                }
                for (int i = max; i >= 4; --i) {
                    CharSequence subSeq = input.subSequence(index, index + i);
                    String result = (String)XML_UNESCAPE.get(subSeq.toString());
                    if (result == null) continue;
                    builder.append(result);
                    return i;
                }
            }
            return 0;
        }

        public static String getMapKey(Object map) {
            return map instanceof Map && !((Map)map).isEmpty() ? String.valueOf(((Map)map).entrySet().iterator().next().getKey()) : "";
        }

        public static Object getMapValue(Object map) {
            return map instanceof Map && !((Map)map).isEmpty() ? ((Map)map).entrySet().iterator().next().getValue() : null;
        }
    }

    public static class XmlObject {
        public static void writeXml(Map map, String name, XmlStringBuilder builder, boolean parentTextFound, Set<String> namespaces, boolean addArray) {
            if (map == null) {
                XmlValue.writeXml(Xml.NULL, name, builder, false, namespaces, addArray);
                return;
            }
            List<XmlStringBuilder> elems = U.newArrayList();
            List<String> attrs = U.newArrayList();
            XmlStringBuilder.Step identStep = builder.getIdentStep();
            int ident = builder.getIdent() + (name == null ? 0 : builder.getIdentStep().getIdent());
            List entries = U.newArrayList(map.entrySet());
            Set<String> attrKeys = U.newLinkedHashSet();
            XmlObject.fillNamespacesAndAttrs(map, namespaces, attrKeys);
            for (int index = 0; index < entries.size(); ++index) {
                boolean addNewLine;
                Map.Entry entry = entries.get(index);
                boolean bl = addNewLine = index < entries.size() - 1 && !String.valueOf(entries.get(index + 1).getKey()).startsWith(Xml.TEXT);
                if (String.valueOf(entry.getKey()).startsWith("-") && entry.getValue() instanceof String) {
                    attrs.add(" " + XmlValue.escapeName(String.valueOf(entry.getKey()).substring(1), namespaces) + "=\"" + XmlValue.escape(String.valueOf(entry.getValue())).replace("\"", Xml.QUOT) + "\"");
                    continue;
                }
                if (String.valueOf(entry.getKey()).startsWith(Xml.TEXT)) {
                    XmlObject.addText(entry, elems, identStep, ident, attrKeys, attrs);
                    continue;
                }
                boolean localParentTextFound = !elems.isEmpty() && elems.get(elems.size() - 1) instanceof XmlStringBuilderText || parentTextFound;
                XmlObject.processElements(entry, identStep, ident, addNewLine, elems, namespaces, localParentTextFound);
            }
            if (addArray && !attrKeys.contains(Xml.ARRAY)) {
                attrs.add(Xml.ARRAY_TRUE);
            }
            XmlObject.addToBuilder(name, parentTextFound, builder, namespaces, attrs, elems);
        }

        private static void fillNamespacesAndAttrs(Map map, Set<String> namespaces, Set<String> attrKeys) {
            for (Map.Entry entry : map.entrySet()) {
                if (!String.valueOf(entry.getKey()).startsWith("-") || entry.getValue() instanceof Map || entry.getValue() instanceof List) continue;
                if (String.valueOf(entry.getKey()).startsWith("-xmlns:")) {
                    namespaces.add(String.valueOf(entry.getKey()).substring(7));
                }
                attrKeys.add(String.valueOf(entry.getKey()));
            }
        }

        private static void addToBuilder(String name, boolean parentTextFound, XmlStringBuilder builder, Set<String> namespaces, List<String> attrs, List<XmlStringBuilder> elems) {
            boolean selfClosing = attrs.remove(" self-closing=\"true\"");
            XmlObject.addOpenElement(name, parentTextFound, builder, namespaces, selfClosing, attrs, elems);
            if (!selfClosing) {
                for (XmlStringBuilder localBuilder1 : elems) {
                    builder.append(localBuilder1.toString());
                }
            }
            if (name != null) {
                builder.decIdent();
                if (!elems.isEmpty() && !(elems.get(elems.size() - 1) instanceof XmlStringBuilderText)) {
                    builder.newLine().fillSpaces();
                }
                if (!selfClosing) {
                    builder.append("</").append(XmlValue.escapeName(name, namespaces)).append(">");
                }
            }
        }

        private static void addOpenElement(String name, boolean parentTextFound, XmlStringBuilder builder, Set<String> namespaces, boolean selfClosing, List<String> attrs, List<XmlStringBuilder> elems) {
            if (name != null) {
                if (!parentTextFound) {
                    builder.fillSpaces();
                }
                builder.append("<").append(XmlValue.escapeName(name, namespaces)).append(U.join(attrs, ""));
                if (selfClosing) {
                    builder.append("/");
                }
                builder.append(">").incIdent();
                if (!elems.isEmpty() && !(elems.get(0) instanceof XmlStringBuilderText)) {
                    builder.newLine();
                }
            }
        }

        private static void processElements(Map.Entry entry, XmlStringBuilder.Step identStep, int ident, boolean addNewLine, List<XmlStringBuilder> elems, Set<String> namespaces, boolean parentTextFound) {
            if (String.valueOf(entry.getKey()).startsWith(Xml.COMMENT)) {
                XmlObject.addComment(entry, identStep, ident, parentTextFound, addNewLine, elems);
            } else if (String.valueOf(entry.getKey()).startsWith(Xml.CDATA)) {
                XmlObject.addCdata(entry, identStep, ident, addNewLine, elems);
            } else if (entry.getValue() instanceof List && !((List)entry.getValue()).isEmpty()) {
                XmlObject.addElements(identStep, ident, entry, namespaces, elems, addNewLine);
            } else {
                XmlObject.addElement(identStep, ident, entry, namespaces, elems, addNewLine);
            }
        }

        private static void addText(Map.Entry entry, List<XmlStringBuilder> elems, XmlStringBuilder.Step identStep, int ident, Set<String> attrKeys, List<String> attrs) {
            if (entry.getValue() instanceof List) {
                for (Object value : (List)entry.getValue()) {
                    elems.add(new XmlStringBuilderText(identStep, ident).append(XmlValue.escape(String.valueOf(value))));
                }
            } else {
                if (entry.getValue() instanceof Number && !attrKeys.contains(Xml.NUMBER)) {
                    attrs.add(Xml.NUMBER_TEXT);
                } else if (entry.getValue() instanceof Boolean && !attrKeys.contains(Xml.BOOLEAN)) {
                    attrs.add(" boolean=\"true\"");
                } else {
                    if (entry.getValue() == null && !attrKeys.contains(Xml.NULL_ATTR)) {
                        attrs.add(" null=\"true\"");
                        return;
                    }
                    if ("".equals(entry.getValue()) && !attrKeys.contains(Xml.STRING)) {
                        attrs.add(" string=\"true\"");
                        return;
                    }
                }
                elems.add(new XmlStringBuilderText(identStep, ident).append(XmlValue.escape(String.valueOf(entry.getValue()))));
            }
        }

        private static void addElements(XmlStringBuilder.Step identStep, int ident, Map.Entry entry, Set<String> namespaces, List<XmlStringBuilder> elems, boolean addNewLine) {
            boolean parentTextFound = !elems.isEmpty() && elems.get(elems.size() - 1) instanceof XmlStringBuilderText;
            XmlStringBuilderWithoutHeader localBuilder = new XmlStringBuilderWithoutHeader(identStep, ident);
            XmlArray.writeXml((List)entry.getValue(), localBuilder, String.valueOf(entry.getKey()), parentTextFound, (Set<String>)namespaces);
            if (addNewLine) {
                localBuilder.newLine();
            }
            elems.add(localBuilder);
        }

        private static void addElement(XmlStringBuilder.Step identStep, int ident, Map.Entry entry, Set<String> namespaces, List<XmlStringBuilder> elems, boolean addNewLine) {
            boolean parentTextFound = !elems.isEmpty() && elems.get(elems.size() - 1) instanceof XmlStringBuilderText;
            XmlStringBuilderWithoutHeader localBuilder = new XmlStringBuilderWithoutHeader(identStep, ident);
            XmlValue.writeXml(entry.getValue(), String.valueOf(entry.getKey()), localBuilder, parentTextFound, namespaces, false);
            if (addNewLine) {
                localBuilder.newLine();
            }
            elems.add(localBuilder);
        }

        private static void addComment(Map.Entry entry, XmlStringBuilder.Step identStep, int ident, boolean parentTextFound, boolean addNewLine, List<XmlStringBuilder> elems) {
            if (entry.getValue() instanceof List) {
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    elems.add(XmlObject.addCommentValue(identStep, ident, String.valueOf(iterator.next()), parentTextFound, iterator.hasNext() || addNewLine));
                }
            } else {
                elems.add(XmlObject.addCommentValue(identStep, ident, String.valueOf(entry.getValue()), parentTextFound, addNewLine));
            }
        }

        private static XmlStringBuilder addCommentValue(XmlStringBuilder.Step identStep, int ident, String value, boolean parentTextFound, boolean addNewLine) {
            XmlStringBuilderWithoutHeader localBuilder = new XmlStringBuilderWithoutHeader(identStep, ident);
            if (!parentTextFound) {
                localBuilder.fillSpaces();
            }
            localBuilder.append("<!--").append(value).append("-->");
            if (addNewLine) {
                localBuilder.newLine();
            }
            return localBuilder;
        }

        private static void addCdata(Map.Entry entry, XmlStringBuilder.Step identStep, int ident, boolean addNewLine, List<XmlStringBuilder> elems) {
            if (entry.getValue() instanceof List) {
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    elems.add(XmlObject.addCdataValue(identStep, ident, String.valueOf(iterator.next()), iterator.hasNext() || addNewLine));
                }
            } else {
                elems.add(XmlObject.addCdataValue(identStep, ident, String.valueOf(entry.getValue()), addNewLine));
            }
        }

        private static XmlStringBuilder addCdataValue(XmlStringBuilder.Step identStep, int ident, String value, boolean addNewLine) {
            XmlStringBuilderText localBuilder = new XmlStringBuilderText(identStep, ident);
            localBuilder.append("<![CDATA[").append(value).append("]]>");
            if (addNewLine) {
                localBuilder.newLine();
            }
            return localBuilder;
        }
    }

    public static class XmlArray {
        public static void writeXml(Collection collection, String name, XmlStringBuilder builder, boolean parentTextFound, Set<String> namespaces, boolean addArray) {
            if (collection == null) {
                builder.append(Xml.NULL);
                return;
            }
            if (name != null) {
                builder.fillSpaces().append("<").append(XmlValue.escapeName(name, namespaces));
                if (addArray) {
                    builder.append(Xml.ARRAY_TRUE);
                }
                if (collection.isEmpty()) {
                    builder.append(" empty-array=\"true\"");
                }
                builder.append(">").incIdent();
                if (!collection.isEmpty()) {
                    builder.newLine();
                }
            }
            XmlArray.writeXml(collection, builder, name, parentTextFound, namespaces);
            if (name != null) {
                builder.decIdent();
                if (!collection.isEmpty()) {
                    builder.newLine().fillSpaces();
                }
                builder.append("</").append(XmlValue.escapeName(name, namespaces)).append(">");
            }
        }

        private static void writeXml(Collection collection, XmlStringBuilder builder, String name, boolean parentTextFound, Set<String> namespaces) {
            boolean localParentTextFound = parentTextFound;
            List entries = U.newArrayList(collection);
            for (int index = 0; index < entries.size(); ++index) {
                boolean addNewLine;
                Object value = entries.get(index);
                boolean bl = addNewLine = index < entries.size() - 1 && !XmlValue.getMapKey(XmlValue.getMapValue(entries.get(index + 1))).startsWith(Xml.TEXT);
                if (value == null) {
                    builder.fillSpaces().append("<" + (name == null ? Xml.ELEMENT_TEXT : XmlValue.escapeName(name, namespaces)) + (collection.size() == 1 ? Xml.ARRAY_TRUE : "") + Xml.NULL_TRUE);
                } else {
                    if (value instanceof Map && ((Map)value).size() == 1 && XmlValue.getMapKey(value).equals("#item") && XmlValue.getMapValue(value) instanceof Map) {
                        XmlObject.writeXml((Map)XmlValue.getMapValue(value), null, builder, localParentTextFound, namespaces, true);
                        if (XmlValue.getMapKey(XmlValue.getMapValue(value)).startsWith(Xml.TEXT)) {
                            localParentTextFound = true;
                            continue;
                        }
                    } else {
                        XmlValue.writeXml(value, name == null ? Xml.ELEMENT_TEXT : name, builder, localParentTextFound, namespaces, collection.size() == 1 || value instanceof Collection);
                    }
                    localParentTextFound = false;
                }
                if (!addNewLine) continue;
                builder.newLine();
            }
        }

        public static void writeXml(byte[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(short[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(int[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(long[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(float[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(double[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(boolean[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(char[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(Object[] array, String name, XmlStringBuilder builder, boolean parentTextFound, Set<String> namespaces) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    XmlValue.writeXml(array[i], name == null ? Xml.ELEMENT_TEXT : name, builder, parentTextFound, namespaces, false);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }
    }

    public static class XmlStringBuilderText
    extends XmlStringBuilderWithoutHeader {
        public XmlStringBuilderText(XmlStringBuilder.Step identStep, int ident) {
            super(identStep, ident);
        }
    }

    public static class XmlStringBuilderWithoutHeader
    extends XmlStringBuilder {
        public XmlStringBuilderWithoutHeader(XmlStringBuilder.Step identStep, int ident) {
            super(new StringBuilder(), identStep, ident);
        }

        @Override
        public String toString() {
            return this.builder.toString();
        }
    }

    public static class XmlStringBuilderWithoutRoot
    extends XmlStringBuilder {
        public XmlStringBuilderWithoutRoot(XmlStringBuilder.Step identStep, String encoding, String standalone) {
            super(new StringBuilder("<?xml version=\"1.0\" encoding=\"" + XmlValue.escape(encoding).replace("\"", Xml.QUOT) + "\"" + standalone + "?>" + (identStep == XmlStringBuilder.Step.COMPACT ? "" : "\n")), identStep, 0);
        }

        @Override
        public String toString() {
            return this.builder.toString();
        }
    }

    public static class XmlStringBuilder {
        protected final StringBuilder builder;
        private final Step identStep;
        private int ident;

        public XmlStringBuilder() {
            this.builder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>\n");
            this.identStep = Step.TWO_SPACES;
            this.ident = 2;
        }

        public XmlStringBuilder(StringBuilder builder, Step identStep, int ident) {
            this.builder = builder;
            this.identStep = identStep;
            this.ident = ident;
        }

        public XmlStringBuilder append(String string) {
            this.builder.append(string);
            return this;
        }

        public XmlStringBuilder fillSpaces() {
            for (int index = 0; index < this.ident; ++index) {
                this.builder.append(this.identStep == Step.TABS ? (char)'\t' : ' ');
            }
            return this;
        }

        public XmlStringBuilder incIdent() {
            this.ident += this.identStep.getIdent();
            return this;
        }

        public XmlStringBuilder decIdent() {
            this.ident -= this.identStep.getIdent();
            return this;
        }

        public XmlStringBuilder newLine() {
            if (this.identStep != Step.COMPACT) {
                this.builder.append("\n");
            }
            return this;
        }

        public int getIdent() {
            return this.ident;
        }

        public Step getIdentStep() {
            return this.identStep;
        }

        public String toString() {
            return this.builder.toString() + "\n</root>";
        }

        public static enum Step {
            TWO_SPACES(2),
            THREE_SPACES(3),
            FOUR_SPACES(4),
            COMPACT(0),
            TABS(1);

            private int ident;

            private Step(int ident) {
                this.ident = ident;
            }

            public int getIdent() {
                return this.ident;
            }
        }
    }
}

