/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlefebure.minio;

import com.github.jlefebure.minio.MinioConfigurationProperties;
import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.NoResponseException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.xmlpull.v1.XmlPullParserException;

@Configuration
@ConditionalOnClass(value={MinioClient.class})
@EnableConfigurationProperties(value={MinioConfigurationProperties.class})
@ComponentScan(value={"com.github.jlefebure.minio"})
public class MinioConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinioConfiguration.class);
    @Autowired
    private MinioConfigurationProperties minioConfigurationProperties;

    @Bean
    public MinioClient minioClient() throws InvalidEndpointException, InvalidPortException, IOException, InvalidKeyException, NoSuchAlgorithmException, InsufficientDataException, InternalException, NoResponseException, InvalidBucketNameException, XmlPullParserException, ErrorResponseException {
        MinioClient minioClient = null;
        try {
            minioClient = new MinioClient(this.minioConfigurationProperties.getUrl(), this.minioConfigurationProperties.getAccessKey(), this.minioConfigurationProperties.getSecretKey(), this.minioConfigurationProperties.isSecure());
            minioClient.setTimeout(this.minioConfigurationProperties.getConnectTimeout().toMillis(), this.minioConfigurationProperties.getWriteTimeout().toMillis(), this.minioConfigurationProperties.getReadTimeout().toMillis());
        }
        catch (InvalidEndpointException | InvalidPortException e) {
            LOGGER.error("Error while connecting to Minio", e);
            throw e;
        }
        try {
            LOGGER.debug("Checking if bucket {} exists", (Object)this.minioConfigurationProperties.getBucket());
            boolean b = minioClient.bucketExists(this.minioConfigurationProperties.getBucket());
            if (!b) {
                throw new InvalidBucketNameException(this.minioConfigurationProperties.getBucket(), "Bucket does not exists");
            }
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            LOGGER.error("Error while checking bucket", e);
            throw e;
        }
        return minioClient;
    }
}

