/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlefebure.minio;

import com.github.jlefebure.minio.MinioConfigurationProperties;
import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.NoResponseException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;
import org.xmlpull.v1.XmlPullParserException;

@Component
public class MinioHealthIndicator
implements HealthIndicator {
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioConfigurationProperties minioConfigurationProperties;

    public Health health() {
        if (this.minioClient == null) {
            return Health.down().build();
        }
        try {
            if (this.minioClient.bucketExists(this.minioConfigurationProperties.getBucket())) {
                return Health.up().withDetail("bucketName", (Object)this.minioConfigurationProperties.getBucket()).build();
            }
            return Health.down().withDetail("bucketName", (Object)this.minioConfigurationProperties.getBucket()).build();
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            return Health.down((Exception)e).withDetail("bucketName", (Object)this.minioConfigurationProperties.getBucket()).build();
        }
    }
}

