/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlefebure.minio;

import com.github.jlefebure.minio.MinioConfiguration;
import com.github.jlefebure.minio.MinioConfigurationProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.minio.MinioClient;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
@ConditionalOnClass(value={MinioClient.class})
@ConditionalOnEnabledHealthIndicator(value="minio")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={MinioConfiguration.class})
public class MinioMetricConfiguration {
    @Autowired
    private MeterRegistry meterRegistry;
    @Autowired
    private MinioConfigurationProperties minioConfigurationProperties;
    private Timer listOkTimer;
    private Timer listKoTimer;
    private Timer getOkTimer;
    private Timer getKoTimer;
    private Timer putOkTimer;
    private Timer putKoTimer;
    private Timer removeOkTimer;
    private Timer removeKoTimer;
    private Timer listBucketOkTimer;
    private Timer listBucketKoTimer;

    @PostConstruct
    public void initTimers() {
        this.listOkTimer = Timer.builder((String)this.minioConfigurationProperties.getMetricName()).tag("operation", "listObjects").tag("status", "ok").tag("bucket", this.minioConfigurationProperties.getBucket()).register(this.meterRegistry);
        this.listKoTimer = Timer.builder((String)this.minioConfigurationProperties.getMetricName()).tag("operation", "listObjects").tag("status", "ko").tag("bucket", this.minioConfigurationProperties.getBucket()).register(this.meterRegistry);
        this.getOkTimer = Timer.builder((String)this.minioConfigurationProperties.getMetricName()).tag("operation", "getObject").tag("status", "ok").tag("bucket", this.minioConfigurationProperties.getBucket()).register(this.meterRegistry);
        this.getKoTimer = Timer.builder((String)this.minioConfigurationProperties.getMetricName()).tag("operation", "getObject").tag("status", "ko").tag("bucket", this.minioConfigurationProperties.getBucket()).register(this.meterRegistry);
        this.putOkTimer = Timer.builder((String)this.minioConfigurationProperties.getMetricName()).tag("operation", "putObject").tag("status", "ok").tag("bucket", this.minioConfigurationProperties.getBucket()).register(this.meterRegistry);
        this.putKoTimer = Timer.builder((String)this.minioConfigurationProperties.getMetricName()).tag("operation", "putObject").tag("status", "ko").tag("bucket", this.minioConfigurationProperties.getBucket()).register(this.meterRegistry);
        this.listBucketOkTimer = Timer.builder((String)(this.minioConfigurationProperties.getMetricName() + ".list.bucket")).tag("operation", "listBuckets").tag("status", "ok").register(this.meterRegistry);
        this.listBucketKoTimer = Timer.builder((String)(this.minioConfigurationProperties.getMetricName() + ".list.bucket")).tag("operation", "listBuckets").tag("status", "ko").register(this.meterRegistry);
        this.removeOkTimer = Timer.builder((String)this.minioConfigurationProperties.getMetricName()).tag("operation", "removeObject").tag("status", "ok").tag("bucket", this.minioConfigurationProperties.getBucket()).register(this.meterRegistry);
        this.removeKoTimer = Timer.builder((String)this.minioConfigurationProperties.getMetricName()).tag("operation", "removeObject").tag("status", "ko").tag("bucket", this.minioConfigurationProperties.getBucket()).register(this.meterRegistry);
    }

    @ConditionalOnBean(value={MinioClient.class})
    @Around(value="execution(* io.minio.MinioClient.getObject(..))")
    public Object getMeter(ProceedingJoinPoint pjp) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object proceed = pjp.proceed();
            this.getOkTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            return proceed;
        }
        catch (Exception e) {
            this.getKoTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            throw e;
        }
    }

    @ConditionalOnBean(value={MinioClient.class})
    @Around(value="execution(* io.minio.MinioClient.listObjects(..))")
    public Object listMeter(ProceedingJoinPoint pjp) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object proceed = pjp.proceed();
            this.listOkTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            return proceed;
        }
        catch (Exception e) {
            this.listKoTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            throw e;
        }
    }

    @ConditionalOnBean(value={MinioClient.class})
    @Around(value="execution(* io.minio.MinioClient.putObject(..))")
    public Object putMeter(ProceedingJoinPoint pjp) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object proceed = pjp.proceed();
            this.putOkTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            return proceed;
        }
        catch (Exception e) {
            this.putKoTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            throw e;
        }
    }

    @ConditionalOnBean(value={MinioClient.class})
    @Around(value="execution(* io.minio.MinioClient.listBuckets(..))")
    public Object listBucketMeter(ProceedingJoinPoint pjp) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object proceed = pjp.proceed();
            this.listBucketOkTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            return proceed;
        }
        catch (Exception e) {
            this.listBucketKoTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            throw e;
        }
    }

    @ConditionalOnBean(value={MinioClient.class})
    @Around(value="execution(* io.minio.MinioClient.removeObject(..))")
    public Object removeMeter(ProceedingJoinPoint pjp) throws Throwable {
        long l = System.currentTimeMillis();
        try {
            Object proceed = pjp.proceed();
            this.removeOkTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            return proceed;
        }
        catch (Exception e) {
            this.removeKoTimer.record(System.currentTimeMillis() - l, TimeUnit.MILLISECONDS);
            throw e;
        }
    }
}

