/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlefebure.minio;

import com.github.jlefebure.minio.MinioConfigurationProperties;
import com.github.jlefebure.minio.MinioException;
import com.github.jlefebure.minio.MinioFetchException;
import io.minio.MinioClient;
import io.minio.Result;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidArgumentException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.NoResponseException;
import io.minio.messages.Item;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xmlpull.v1.XmlPullParserException;

@Service
public class MinioService {
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioConfigurationProperties configurationProperties;

    public List<Item> list() throws MinioException {
        try {
            Iterable myObjects = this.minioClient.listObjects(this.configurationProperties.getBucket());
            return this.getItems(myObjects);
        }
        catch (XmlPullParserException e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public List<Item> list(Path path) throws MinioException {
        try {
            Iterable myObjects = this.minioClient.listObjects(this.configurationProperties.getBucket(), path.toString());
            return this.getItems(myObjects);
        }
        catch (XmlPullParserException e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    private List<Item> getItems(Iterable<Result<Item>> myObjects) {
        return StreamSupport.stream(myObjects.spliterator(), true).map(itemResult -> {
            try {
                return (Item)itemResult.get();
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                throw new MinioFetchException("Error while parsing list of objects", e);
            }
        }).collect(Collectors.toList());
    }

    public InputStream get(Path path) throws MinioException {
        try {
            return this.minioClient.getObject(this.configurationProperties.getBucket(), path.toString());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidArgumentException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void getAndSave(Path source, String fileName) throws MinioException {
        try {
            this.minioClient.getObject(this.configurationProperties.getBucket(), source.toString(), fileName);
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidArgumentException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void upload(Path source, InputStream file, ContentType contentType) throws MinioException {
        try {
            this.minioClient.putObject(this.configurationProperties.getBucket(), source.toString(), file, contentType.getMimeType());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidArgumentException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void upload(Path source, InputStream file, String contentType) throws MinioException {
        try {
            this.minioClient.putObject(this.configurationProperties.getBucket(), source.toString(), file, contentType);
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidArgumentException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }

    public void remove(Path source) throws MinioException {
        try {
            this.minioClient.removeObject(this.configurationProperties.getBucket(), source.toString());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidArgumentException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
            throw new MinioException("Error while fetching files in Minio", e);
        }
    }
}

