/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json;

import org.jsfr.json.JsonSaxHandler;
import org.jsfr.json.PrimitiveHolder;
import org.jsfr.json.provider.JsonProvider;

public class JsonDomBuilder
implements JsonSaxHandler {
    private static final int ROOT = 0;
    private static final int IN_OBJECT = 1;
    private static final int IN_ARRAY = 2;
    private JsonProvider provider;
    private String propertyName;
    private Node[] stack = new Node[32];
    private int stackSize = 0;

    public JsonDomBuilder() {
        this.push(0, null);
    }

    private void push(int newTop, Object topValue) {
        Node next;
        if (this.stackSize == this.stack.length) {
            Node[] newStack = new Node[this.stackSize * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stackSize);
            this.stack = newStack;
        }
        if ((next = this.stack[this.stackSize]) == null) {
            this.stack[this.stackSize] = next = new Node();
        }
        next.value = topValue;
        next.scope = newTop;
        ++this.stackSize;
    }

    private Node peekNode() {
        return this.stack[this.stackSize - 1];
    }

    private int peek() {
        return this.peekNode().scope;
    }

    protected Object peekValue() {
        return this.peekNode().value;
    }

    private void replaceTop(Object value) {
        this.stack[this.stackSize - 1].value = value;
    }

    private void pop() {
        --this.stackSize;
    }

    public void setProvider(JsonProvider provider) {
        this.provider = provider;
    }

    @Override
    public boolean startJSON() {
        return true;
    }

    @Override
    public boolean endJSON() {
        return true;
    }

    @Override
    public boolean startObject() {
        Object newObject = this.provider.createObject();
        Node top = this.peekNode();
        switch (top.scope) {
            case 0: {
                this.replaceTop(newObject);
                break;
            }
            case 1: {
                this.provider.put(top.value, this.propertyName, newObject);
                this.propertyName = null;
                break;
            }
            case 2: {
                this.provider.add(top.value, newObject);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.push(1, newObject);
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) {
        switch (this.peek()) {
            case 1: {
                this.propertyName = key;
                break;
            }
            case 2: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    @Override
    public boolean endObject() {
        switch (this.peek()) {
            case 1: {
                this.pop();
                break;
            }
            case 2: {
                throw new IllegalStateException();
            }
        }
        return false;
    }

    @Override
    public boolean startArray() {
        Object newArray = this.provider.createArray();
        Node top = this.peekNode();
        switch (top.scope) {
            case 0: {
                this.replaceTop(newArray);
                break;
            }
            case 1: {
                this.provider.put(top.value, this.propertyName, newArray);
                this.propertyName = null;
                break;
            }
            case 2: {
                this.provider.add(top.value, newArray);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.push(2, newArray);
        return true;
    }

    @Override
    public boolean endArray() {
        this.pop();
        return true;
    }

    @Override
    public boolean primitive(PrimitiveHolder primitiveHolder) {
        Object value = primitiveHolder.getValue();
        Node top = this.peekNode();
        switch (top.scope) {
            case 0: {
                this.replaceTop(value);
                break;
            }
            case 1: {
                this.provider.put(top.value, this.propertyName, value);
                this.propertyName = null;
                break;
            }
            case 2: {
                this.provider.add(top.value, value);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    public boolean isInRoot() {
        return this.peek() == 0;
    }

    public void clear() {
        this.propertyName = null;
        this.provider = null;
        this.stack = null;
    }

    private static class Node {
        private int scope;
        private Object value;

        private Node() {
        }
    }
}

