/*
 * Decompiled with CFR 0.152.
 */
package org.jsfr.json.compiler;

import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jsfr.json.compiler.JsonPathBaseVisitor;
import org.jsfr.json.compiler.JsonPathLexer;
import org.jsfr.json.compiler.JsonPathParser;
import org.jsfr.json.path.JsonPath;

public class JsonPathCompiler
extends JsonPathBaseVisitor<Void> {
    private JsonPath.Builder builder;

    public JsonPath.Builder getBuilder() {
        return this.builder;
    }

    @Override
    public Void visitPath(JsonPathParser.PathContext ctx) {
        this.builder = JsonPath.Builder.start();
        return (Void)super.visitPath(ctx);
    }

    @Override
    public Void visitSearchChild(JsonPathParser.SearchChildContext ctx) {
        this.builder.scan().child(ctx.KEY().getText());
        return (Void)super.visitSearchChild(ctx);
    }

    @Override
    public Void visitSearch(JsonPathParser.SearchContext ctx) {
        this.builder.scan();
        return (Void)super.visitSearch(ctx);
    }

    @Override
    public Void visitChildNode(JsonPathParser.ChildNodeContext ctx) {
        this.builder.child(ctx.KEY().getText());
        return (Void)super.visitChildNode(ctx);
    }

    @Override
    public Void visitChildrenNode(JsonPathParser.ChildrenNodeContext ctx) {
        int i = 0;
        String[] keys = new String[ctx.KEY().size()];
        for (TerminalNode key : ctx.KEY()) {
            keys[i++] = key.getText();
        }
        this.builder.children(keys);
        return (Void)super.visitChildren((RuleNode)ctx);
    }

    @Override
    public Void visitIndex(JsonPathParser.IndexContext ctx) {
        this.builder.index(Integer.parseInt(ctx.NUM().getText()));
        return (Void)super.visitIndex(ctx);
    }

    @Override
    public Void visitIndexes(JsonPathParser.IndexesContext ctx) {
        int i = 0;
        Integer[] keys = new Integer[ctx.NUM().size()];
        for (TerminalNode key : ctx.NUM()) {
            keys[i++] = Integer.parseInt(key.getText());
        }
        this.builder.indexes(keys);
        return (Void)super.visitIndexes(ctx);
    }

    @Override
    public Void visitSlicing(JsonPathParser.SlicingContext ctx) {
        Integer left = null;
        Integer temp = null;
        for (ParseTree node : ctx.children) {
            if (!(node instanceof TerminalNode)) continue;
            TerminalNode tNode = (TerminalNode)node;
            if (((TerminalNode)node).getSymbol().getType() == 19) {
                left = temp;
                temp = null;
                continue;
            }
            if (tNode.getSymbol().getType() != 20) continue;
            temp = Integer.parseInt(tNode.getText());
        }
        Integer right = temp;
        this.builder.slicing(left, right);
        return (Void)super.visitSlicing(ctx);
    }

    @Override
    public Void visitAnyChild(JsonPathParser.AnyChildContext ctx) {
        this.builder.anyChild();
        return (Void)super.visitAnyChild(ctx);
    }

    @Override
    public Void visitAnyIndex(JsonPathParser.AnyIndexContext ctx) {
        this.builder.anyIndex();
        return (Void)super.visitAnyIndex(ctx);
    }

    @Override
    public Void visitAny(JsonPathParser.AnyContext ctx) {
        this.builder.any();
        return (Void)super.visitAny(ctx);
    }

    @Override
    public Void visitFilter(JsonPathParser.FilterContext ctx) {
        return (Void)super.visitFilter(ctx);
    }

    @Override
    public Void visitExpr(JsonPathParser.ExprContext ctx) {
        return (Void)super.visitExpr(ctx);
    }

    public static JsonPath[] compile(String ... paths) {
        JsonPath[] jsonPaths = new JsonPath[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            jsonPaths[i] = JsonPathCompiler.compile(paths[i]);
        }
        return jsonPaths;
    }

    public static JsonPath compile(String path) {
        JsonPathLexer lexer = new JsonPathLexer((CharStream)new ANTLRInputStream(path));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        JsonPathParser parser = new JsonPathParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        JsonPathParser.PathContext tree = parser.path();
        JsonPathCompiler compiler = new JsonPathCompiler();
        compiler.visit((ParseTree)tree);
        return compiler.getBuilder().build();
    }

    public static void main(String[] s) {
        JsonPath path = JsonPathCompiler.compile("$..abc.c.d[1].e[2,3,6]");
        System.out.println(path);
    }
}

