/*
 * Decompiled with CFR 0.152.
 */
package com.github.kklisura.cdt.protocol.commands;

import com.github.kklisura.cdt.protocol.events.debugger.BreakpointResolved;
import com.github.kklisura.cdt.protocol.events.debugger.Paused;
import com.github.kklisura.cdt.protocol.events.debugger.Resumed;
import com.github.kklisura.cdt.protocol.events.debugger.ScriptFailedToParse;
import com.github.kklisura.cdt.protocol.events.debugger.ScriptParsed;
import com.github.kklisura.cdt.protocol.support.annotations.EventName;
import com.github.kklisura.cdt.protocol.support.annotations.Experimental;
import com.github.kklisura.cdt.protocol.support.annotations.Optional;
import com.github.kklisura.cdt.protocol.support.annotations.ParamName;
import com.github.kklisura.cdt.protocol.support.annotations.ReturnTypeParameter;
import com.github.kklisura.cdt.protocol.support.annotations.Returns;
import com.github.kklisura.cdt.protocol.support.types.EventHandler;
import com.github.kklisura.cdt.protocol.support.types.EventListener;
import com.github.kklisura.cdt.protocol.types.debugger.BreakLocation;
import com.github.kklisura.cdt.protocol.types.debugger.ContinueToLocationTargetCallFrames;
import com.github.kklisura.cdt.protocol.types.debugger.EvaluateOnCallFrame;
import com.github.kklisura.cdt.protocol.types.debugger.Location;
import com.github.kklisura.cdt.protocol.types.debugger.RestartFrame;
import com.github.kklisura.cdt.protocol.types.debugger.ScriptPosition;
import com.github.kklisura.cdt.protocol.types.debugger.SearchMatch;
import com.github.kklisura.cdt.protocol.types.debugger.SetBreakpoint;
import com.github.kklisura.cdt.protocol.types.debugger.SetBreakpointByUrl;
import com.github.kklisura.cdt.protocol.types.debugger.SetInstrumentationBreakpointInstrumentation;
import com.github.kklisura.cdt.protocol.types.debugger.SetPauseOnExceptionsState;
import com.github.kklisura.cdt.protocol.types.debugger.SetScriptSource;
import com.github.kklisura.cdt.protocol.types.runtime.CallArgument;
import com.github.kklisura.cdt.protocol.types.runtime.StackTrace;
import com.github.kklisura.cdt.protocol.types.runtime.StackTraceId;
import java.util.List;

public interface Debugger {
    public void continueToLocation(@ParamName(value="location") Location var1);

    public void continueToLocation(@ParamName(value="location") Location var1, @Optional @ParamName(value="targetCallFrames") ContinueToLocationTargetCallFrames var2);

    public void disable();

    @Returns(value="debuggerId")
    public String enable();

    @Returns(value="debuggerId")
    public String enable(@Experimental @Optional @ParamName(value="maxScriptsCacheSize") Double var1);

    public EvaluateOnCallFrame evaluateOnCallFrame(@ParamName(value="callFrameId") String var1, @ParamName(value="expression") String var2);

    public EvaluateOnCallFrame evaluateOnCallFrame(@ParamName(value="callFrameId") String var1, @ParamName(value="expression") String var2, @Optional @ParamName(value="objectGroup") String var3, @Optional @ParamName(value="includeCommandLineAPI") Boolean var4, @Optional @ParamName(value="silent") Boolean var5, @Optional @ParamName(value="returnByValue") Boolean var6, @Experimental @Optional @ParamName(value="generatePreview") Boolean var7, @Optional @ParamName(value="throwOnSideEffect") Boolean var8, @Experimental @Optional @ParamName(value="timeout") Double var9);

    @Returns(value="locations")
    @ReturnTypeParameter(value={BreakLocation.class})
    public List<BreakLocation> getPossibleBreakpoints(@ParamName(value="start") Location var1);

    @Returns(value="locations")
    @ReturnTypeParameter(value={BreakLocation.class})
    public List<BreakLocation> getPossibleBreakpoints(@ParamName(value="start") Location var1, @Optional @ParamName(value="end") Location var2, @Optional @ParamName(value="restrictToFunction") Boolean var3);

    @Returns(value="scriptSource")
    public String getScriptSource(@ParamName(value="scriptId") String var1);

    @Experimental
    @Returns(value="stackTrace")
    public StackTrace getStackTrace(@ParamName(value="stackTraceId") StackTraceId var1);

    public void pause();

    @Experimental
    public void pauseOnAsyncCall(@ParamName(value="parentStackTraceId") StackTraceId var1);

    public void removeBreakpoint(@ParamName(value="breakpointId") String var1);

    public RestartFrame restartFrame(@ParamName(value="callFrameId") String var1);

    public void resume();

    @Returns(value="result")
    @ReturnTypeParameter(value={SearchMatch.class})
    public List<SearchMatch> searchInContent(@ParamName(value="scriptId") String var1, @ParamName(value="query") String var2);

    @Returns(value="result")
    @ReturnTypeParameter(value={SearchMatch.class})
    public List<SearchMatch> searchInContent(@ParamName(value="scriptId") String var1, @ParamName(value="query") String var2, @Optional @ParamName(value="caseSensitive") Boolean var3, @Optional @ParamName(value="isRegex") Boolean var4);

    public void setAsyncCallStackDepth(@ParamName(value="maxDepth") Integer var1);

    @Experimental
    public void setBlackboxPatterns(@ParamName(value="patterns") List<String> var1);

    @Experimental
    public void setBlackboxedRanges(@ParamName(value="scriptId") String var1, @ParamName(value="positions") List<ScriptPosition> var2);

    public SetBreakpoint setBreakpoint(@ParamName(value="location") Location var1);

    public SetBreakpoint setBreakpoint(@ParamName(value="location") Location var1, @Optional @ParamName(value="condition") String var2);

    @Returns(value="breakpointId")
    public String setInstrumentationBreakpoint(@ParamName(value="instrumentation") SetInstrumentationBreakpointInstrumentation var1);

    public SetBreakpointByUrl setBreakpointByUrl(@ParamName(value="lineNumber") Integer var1);

    public SetBreakpointByUrl setBreakpointByUrl(@ParamName(value="lineNumber") Integer var1, @Optional @ParamName(value="url") String var2, @Optional @ParamName(value="urlRegex") String var3, @Optional @ParamName(value="scriptHash") String var4, @Optional @ParamName(value="columnNumber") Integer var5, @Optional @ParamName(value="condition") String var6);

    @Experimental
    @Returns(value="breakpointId")
    public String setBreakpointOnFunctionCall(@ParamName(value="objectId") String var1);

    @Experimental
    @Returns(value="breakpointId")
    public String setBreakpointOnFunctionCall(@ParamName(value="objectId") String var1, @Optional @ParamName(value="condition") String var2);

    public void setBreakpointsActive(@ParamName(value="active") Boolean var1);

    public void setPauseOnExceptions(@ParamName(value="state") SetPauseOnExceptionsState var1);

    @Experimental
    public void setReturnValue(@ParamName(value="newValue") CallArgument var1);

    public SetScriptSource setScriptSource(@ParamName(value="scriptId") String var1, @ParamName(value="scriptSource") String var2);

    public SetScriptSource setScriptSource(@ParamName(value="scriptId") String var1, @ParamName(value="scriptSource") String var2, @Optional @ParamName(value="dryRun") Boolean var3);

    public void setSkipAllPauses(@ParamName(value="skip") Boolean var1);

    public void setVariableValue(@ParamName(value="scopeNumber") Integer var1, @ParamName(value="variableName") String var2, @ParamName(value="newValue") CallArgument var3, @ParamName(value="callFrameId") String var4);

    public void stepInto();

    public void stepInto(@Experimental @Optional @ParamName(value="breakOnAsyncCall") Boolean var1);

    public void stepOut();

    public void stepOver();

    @EventName(value="breakpointResolved")
    public EventListener onBreakpointResolved(EventHandler<BreakpointResolved> var1);

    @EventName(value="paused")
    public EventListener onPaused(EventHandler<Paused> var1);

    @EventName(value="resumed")
    public EventListener onResumed(EventHandler<Resumed> var1);

    @EventName(value="scriptFailedToParse")
    public EventListener onScriptFailedToParse(EventHandler<ScriptFailedToParse> var1);

    @EventName(value="scriptParsed")
    public EventListener onScriptParsed(EventHandler<ScriptParsed> var1);
}

