/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.kongchen.swagger.docgen.GenerateException;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SecurityDefinition {
    private String name;
    private String type;
    private String in;
    private String description;
    private String json;
    private String jsonPath;

    public Map<String, SecuritySchemeDefinition> generateSecuritySchemeDefinitions() throws GenerateException {
        HashMap<String, SecuritySchemeDefinition> map = new HashMap<String, SecuritySchemeDefinition>();
        List<Object> securityDefinitions = new ArrayList();
        if (this.json != null || this.jsonPath != null) {
            securityDefinitions = this.loadSecurityDefintionsFromJsonFile();
        } else {
            securityDefinitions.add(new ObjectMapper().valueToTree((Object)this));
        }
        for (JsonNode jsonNode : securityDefinitions) {
            SecuritySchemeDefinition ssd = this.getSecuritySchemeDefinitionByType(jsonNode.get("type").asText(), jsonNode);
            if (ssd == null) continue;
            map.put(jsonNode.get("name").asText(), ssd);
        }
        return map;
    }

    private List<JsonNode> loadSecurityDefintionsFromJsonFile() throws GenerateException {
        ArrayList<JsonNode> securityDefinitions = new ArrayList<JsonNode>();
        try {
            InputStream jsonStream = this.json != null ? this.getClass().getResourceAsStream(this.json) : new FileInputStream(this.jsonPath);
            JsonNode tree = new ObjectMapper().readTree(jsonStream);
            Iterator securityDefinitionNameIterator = tree.fieldNames();
            while (securityDefinitionNameIterator.hasNext()) {
                String securityDefinitionName = (String)securityDefinitionNameIterator.next();
                JsonNode securityDefinition = tree.get(securityDefinitionName);
                securityDefinition = ((ObjectNode)securityDefinition).put("name", securityDefinitionName);
                securityDefinitions.add(securityDefinition);
            }
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
        return securityDefinitions;
    }

    private SecuritySchemeDefinition getSecuritySchemeDefinitionByType(String type, JsonNode node) throws GenerateException {
        try {
            ObjectMapper mapper = new ObjectMapper();
            OAuth2Definition def = null;
            if (type.equals(new OAuth2Definition().getType())) {
                def = new OAuth2Definition();
                if (node != null) {
                    def = (SecuritySchemeDefinition)mapper.readValue(node.traverse(), OAuth2Definition.class);
                }
            } else if (type.equals(new BasicAuthDefinition().getType())) {
                def = new BasicAuthDefinition();
                if (node != null) {
                    def = (SecuritySchemeDefinition)mapper.readValue(node.traverse(), BasicAuthDefinition.class);
                }
            } else if (type.equals(new ApiKeyAuthDefinition().getType())) {
                def = new ApiKeyAuthDefinition();
                if (node != null) {
                    def = (SecuritySchemeDefinition)mapper.readValue(node.traverse(), ApiKeyAuthDefinition.class);
                }
            }
            return def;
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIn() {
        return this.in;
    }

    public void setIn(String in) {
        this.in = in;
    }
}

