/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.impl.AttributeUseImpl;
import com.sun.xml.xsom.impl.ElementDecl;
import com.sun.xml.xsom.impl.ParticleImpl;
import com.sun.xml.xsom.impl.parser.DelayedRef;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.xml.sax.ErrorHandler;

public class JaxbValidationsPlugins
extends Plugin {
    public static final String PLUGIN_OPTION_NAME = "XJsr303Annotations";
    public static final String TARGET_NAMESPACE_PARAMETER_NAME = "XJsr303Annotations:targetNamespace";
    public static final String JSR_349 = "XJsr303Annotations:JSR_349";
    public static final String GENERATE_NOT_NULL_ANNOTATIONS = "XJsr303Annotations:generateNotNullAnnotations";
    protected String namespace = "http://jaxb.dev.java.net/plugin/code-injector";
    public String targetNamespace = "TARGET_NAMESPACE";
    public boolean jsr349 = false;
    public boolean notNullAnnotations = true;

    public String getOptionName() {
        return PLUGIN_OPTION_NAME;
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        int index_generateNotNullAnnotations;
        int index;
        String arg1 = args[i];
        int consumed = 0;
        int indexOfNamespace = arg1.indexOf(TARGET_NAMESPACE_PARAMETER_NAME);
        if (indexOfNamespace > 0) {
            this.targetNamespace = arg1.substring(indexOfNamespace + TARGET_NAMESPACE_PARAMETER_NAME.length() + "=".length());
            ++consumed;
        }
        if ((index = arg1.indexOf(JSR_349)) > 0) {
            this.jsr349 = Boolean.parseBoolean(arg1.substring(index + JSR_349.length() + "=".length()));
            ++consumed;
        }
        if ((index_generateNotNullAnnotations = arg1.indexOf(GENERATE_NOT_NULL_ANNOTATIONS)) > 0) {
            this.notNullAnnotations = Boolean.parseBoolean(arg1.substring(index_generateNotNullAnnotations + GENERATE_NOT_NULL_ANNOTATIONS.length() + "=".length()));
            ++consumed;
        }
        return consumed;
    }

    public List<String> getCustomizationURIs() {
        return Collections.singletonList(this.namespace);
    }

    public boolean isCustomizationTagName(String nsUri, String localName) {
        return nsUri.equals(this.namespace) && localName.equals("code");
    }

    public void onActivated(Options opts) throws BadCommandLineException {
        super.onActivated(opts);
    }

    public String getUsage() {
        return "  -XJsr303Annotations      :  inject Bean validation annotations (JSR 303); -XJsr303Annotations:targetNamespace=http://www.foo.com/bar  :      additional settings for @Valid annotation";
    }

    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) {
        try {
            for (ClassOutline co : model.getClasses()) {
                for (CPropertyInfo property : co.target.getProperties()) {
                    if (property instanceof CElementPropertyInfo) {
                        this.processElement((CElementPropertyInfo)property, co, model);
                        continue;
                    }
                    if (!(property instanceof CAttributePropertyInfo)) continue;
                    this.processAttribute((CAttributePropertyInfo)property, co, model);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void processElement(CElementPropertyInfo property, ClassOutline clase, Outline model) {
        Object term;
        FieldOutline field = model.getField((CPropertyInfo)property);
        XSComponent schemaComponent = property.getSchemaComponent();
        ParticleImpl particle = (ParticleImpl)schemaComponent;
        int maxOccurs = this.toInt(this.getField("maxOccurs", particle));
        int minOccurs = this.toInt(this.getField("minOccurs", particle));
        JFieldVar var = (JFieldVar)clase.implClass.fields().get(this.getField("privateName", property));
        if ((minOccurs < 0 || minOccurs >= 1) && !this.hasAnnotation(var, NotNull.class) && this.notNullAnnotations) {
            System.out.println("@NotNull: " + property.getName() + " added to class " + clase.implClass.name());
            var.annotate(NotNull.class);
        }
        if (maxOccurs > 1 && !this.hasAnnotation(var, Size.class)) {
            System.out.println("@Size (" + minOccurs + "," + maxOccurs + ") " + property.getName() + " added to class " + clase.implClass.name());
            var.annotate(Size.class).param("min", minOccurs).param("max", maxOccurs);
        }
        if (maxOccurs == -1 && minOccurs > 0 && !this.hasAnnotation(var, Size.class)) {
            System.out.println("@Size (" + minOccurs + ") " + property.getName() + " added to class " + clase.implClass.name());
            var.annotate(Size.class).param("min", minOccurs);
        }
        if ((term = this.getField("term", particle)) instanceof ElementDecl) {
            this.processValidAnnotation(property, clase, var, (ElementDecl)term);
        } else if (term instanceof DelayedRef.Element) {
            XSElementDecl xsElementDecl = ((DelayedRef.Element)term).get();
            this.processValidAnnotation(property, clase, var, (ElementDecl)xsElementDecl);
        }
    }

    private void processValidAnnotation(CElementPropertyInfo property, ClassOutline clase, JFieldVar var, ElementDecl element) {
        if (element.getType().getTargetNamespace().startsWith(this.targetNamespace) && element.getType().isComplexType() && !this.hasAnnotation(var, Valid.class)) {
            System.out.println("@Valid: " + property.getName() + " added to class " + clase.implClass.name());
            var.annotate(Valid.class);
        }
        if (element.getType() instanceof XSSimpleType) {
            this.processType((XSSimpleType)element.getType(), var, property.getName(), clase.implClass.name());
        } else if (element.getType().getBaseType() instanceof XSSimpleType) {
            this.processType((XSSimpleType)element.getType().getBaseType(), var, property.getName(), clase.implClass.name());
        }
    }

    protected int toInt(Object maxOccurs) {
        if (maxOccurs instanceof BigInteger) {
            return ((BigInteger)maxOccurs).intValue();
        }
        if (maxOccurs instanceof Integer) {
            return (Integer)maxOccurs;
        }
        throw new IllegalArgumentException("unknown type " + maxOccurs.getClass());
    }

    public void processAttribute(CAttributePropertyInfo property, ClassOutline clase, Outline model) {
        FieldOutline field = model.getField((CPropertyInfo)property);
        System.out.println("Attribute " + property.getName() + " added to class " + clase.implClass.name());
        XSComponent definition = property.getSchemaComponent();
        AttributeUseImpl particle = (AttributeUseImpl)definition;
        JFieldVar var = (JFieldVar)clase.implClass.fields().get(this.getField("privateName", property));
        if (particle.isRequired() && !this.hasAnnotation(var, NotNull.class) && this.notNullAnnotations) {
            System.out.println("@NotNull: " + property.getName() + " added to class " + clase.implClass.name());
            var.annotate(NotNull.class);
        }
        if (particle.getDecl().getType().getTargetNamespace().startsWith(this.targetNamespace) && particle.getDecl().getType().isComplexType() && !this.hasAnnotation(var, Valid.class)) {
            System.out.println("@Valid: " + property.getName() + " added to class " + clase.implClass.name());
            var.annotate(Valid.class);
        }
        this.processType(particle.getDecl().getType(), var, property.getName(), clase.implClass.name());
    }

    public void processType(XSSimpleType simpleType, JFieldVar field, String campo, String clase) {
        XSFacet minExclusive;
        XSFacet maxExclusive;
        XSFacet minInclusive;
        XSFacet maxInclusive;
        if (!this.hasAnnotation(field, Size.class)) {
            Integer minLength;
            Integer maxLength = simpleType.getFacet("maxLength") == null ? null : this.parseInt(simpleType.getFacet((String)"maxLength").getValue().value);
            Integer n = minLength = simpleType.getFacet("minLength") == null ? null : this.parseInt(simpleType.getFacet((String)"minLength").getValue().value);
            if (maxLength != null && minLength != null) {
                System.out.println("@Size(" + minLength + "," + maxLength + "): " + campo + " added to class " + clase);
                field.annotate(Size.class).param("min", minLength.intValue()).param("max", maxLength.intValue());
            } else if (minLength != null) {
                System.out.println("@Size(" + minLength + ", null): " + campo + " added to class " + clase);
                field.annotate(Size.class).param("min", minLength.intValue());
            } else if (maxLength != null) {
                System.out.println("@Size(null, " + maxLength + "): " + campo + " added to class " + clase);
                field.annotate(Size.class).param("max", maxLength.intValue());
            }
        }
        if ((maxInclusive = simpleType.getFacet("maxInclusive")) != null && this.isValidValue(maxInclusive) && !this.hasAnnotation(field, DecimalMax.class)) {
            System.out.println("@DecimalMax(" + maxInclusive.getValue().value + "): " + campo + " added to class " + clase);
            field.annotate(DecimalMax.class).param("value", maxInclusive.getValue().value);
        }
        if ((minInclusive = simpleType.getFacet("minInclusive")) != null && this.isValidValue(minInclusive) && !this.hasAnnotation(field, DecimalMin.class)) {
            System.out.println("@DecimalMin(" + minInclusive.getValue().value + "): " + campo + " added to class " + clase);
            field.annotate(DecimalMin.class).param("value", minInclusive.getValue().value);
        }
        if ((maxExclusive = simpleType.getFacet("maxExclusive")) != null && this.isValidValue(maxExclusive) && !this.hasAnnotation(field, DecimalMax.class)) {
            System.out.println("@DecimalMax(" + maxExclusive.getValue().value + "): " + campo + " added to class " + clase);
            JAnnotationUse annotate = field.annotate(DecimalMax.class);
            annotate.param("value", maxExclusive.getValue().value);
            if (this.jsr349) {
                annotate.param("inclusive", false);
            }
        }
        if ((minExclusive = simpleType.getFacet("minExclusive")) != null && this.isValidValue(minExclusive) && !this.hasAnnotation(field, DecimalMin.class)) {
            System.out.println("@DecimalMin(" + minExclusive.getValue().value + "): " + campo + " added to class " + clase);
            JAnnotationUse annotate = field.annotate(DecimalMin.class);
            annotate.param("value", minExclusive.getValue().value);
            if (this.jsr349) {
                annotate.param("inclusive", false);
            }
        }
        if (simpleType.getFacet("totalDigits") != null) {
            int fractionDigits;
            Integer totalDigits = simpleType.getFacet("totalDigits") == null ? null : this.parseInt(simpleType.getFacet((String)"totalDigits").getValue().value);
            int n = fractionDigits = simpleType.getFacet("fractionDigits") == null ? 0 : this.parseInt(simpleType.getFacet((String)"fractionDigits").getValue().value);
            if (!this.hasAnnotation(field, Digits.class)) {
                System.out.println("@Digits(" + totalDigits + "," + fractionDigits + "): " + campo + " added to class " + clase);
                JAnnotationUse annox = field.annotate(Digits.class).param("integer", totalDigits - fractionDigits);
                if (simpleType.getFacet("fractionDigits") != null) {
                    annox.param("fraction", fractionDigits);
                }
            }
        }
        if (simpleType.getFacet("pattern") != null) {
            String pattern = simpleType.getFacet((String)"pattern").getValue().value;
            if ("String".equals(field.type().name()) && !"\\c+".equals(pattern)) {
                System.out.println("@Pattern(" + pattern + "): " + campo + " added to class " + clase);
                if (!this.hasAnnotation(field, Pattern.class)) {
                    field.annotate(Pattern.class).param("regexp", pattern);
                }
            }
        }
    }

    protected boolean isValidValue(XSFacet facet) {
        String value = facet.getValue().value;
        return value != null && !this.isMax(value) && !this.isMin(value);
    }

    protected boolean isMin(String value) {
        return this.equals(value, Long.MIN_VALUE) || this.equals(value, Integer.MIN_VALUE);
    }

    protected boolean isMax(String value) {
        return this.equals(value, Long.MAX_VALUE) || this.equals(value, Integer.MAX_VALUE);
    }

    protected boolean equals(String value, long val) {
        return value.equals(BigInteger.valueOf(val).toString());
    }

    public boolean hasAnnotation(JFieldVar var, Class anotacion) {
        List lista = (List)this.getField("annotations", var);
        if (lista != null) {
            for (JAnnotationUse uso : lista) {
                if (!((Class)this.getField("clazz._class", uso)).getCanonicalName().equals(anotacion.getCanonicalName())) continue;
                return true;
            }
        }
        return false;
    }

    protected Integer parseInt(String valor) {
        try {
            Integer i = Integer.parseInt(valor);
            if (i < Integer.MAX_VALUE && i > Integer.MIN_VALUE) {
                return i;
            }
        }
        catch (Exception e) {
            try {
                return (int)Math.round(Double.parseDouble(valor));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected Object getField(String path, Object oo) {
        try {
            if (path.contains(".")) {
                String field = path.substring(0, path.indexOf("."));
                Field declaredField = oo.getClass().getDeclaredField(field);
                declaredField.setAccessible(true);
                Object result = declaredField.get(oo);
                return this.getField(path.substring(path.indexOf(".") + 1), result);
            }
            Field simpleField = JaxbValidationsPlugins.getSimpleField(path, oo.getClass());
            simpleField.setAccessible(true);
            return simpleField.get(oo);
        }
        catch (Exception e) {
            System.out.println("Field " + path + " not found on " + oo.getClass().getName());
            return null;
        }
    }

    protected static Field getSimpleField(String fieldName, Class<?> clazz) {
        Class<?> tmpClass = clazz;
        try {
            do {
                for (Field field : tmpClass.getDeclaredFields()) {
                    String candidateName = field.getName();
                    if (!candidateName.equals(fieldName)) continue;
                    field.setAccessible(true);
                    return field;
                }
                tmpClass = tmpClass.getSuperclass();
            } while (clazz != null);
        }
        catch (Exception e) {
            System.out.println("Field '" + fieldName + "' not found on class " + clazz);
        }
        return null;
    }
}

