/*
 * Decompiled with CFR 0.152.
 */
package com.github.labai.deci;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0005\u0018\u0000 22\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u000223B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0015J\u0011\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rH\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\nH\u0086\u0002J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rH\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\nH\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rH\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\nH\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rH\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\nH\u0086\u0002J\u0011\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0007H\u0086\u0004J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rH\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\nH\u0086\u0002J\u0006\u0010#\u001a\u00020\rJ\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0007H\u0016J\b\u0010-\u001a\u00020\nH\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0004H\u0016J\t\u00101\u001a\u00020\u0000H\u0086\u0002R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/github/labai/deci/Deci;", "", "", "str", "", "(Ljava/lang/String;)V", "int", "", "(I)V", "long", "", "(J)V", "decimal", "Ljava/math/BigDecimal;", "context", "Lcom/github/labai/deci/Deci$DeciContext;", "(Ljava/math/BigDecimal;Lcom/github/labai/deci/Deci$DeciContext;)V", "_hashCode", "Ljava/lang/Integer;", "calcDivScale", "divisor", "calcDivScale$deci", "compareTo", "other", "div", "equals", "", "", "hashCode", "minus", "plus", "rem", "round", "scale", "times", "toBigDecimal", "toByte", "", "toChar", "", "toDouble", "", "toFloat", "", "toInt", "toLong", "toShort", "", "toString", "unaryMinus", "Companion", "DeciContext", "deci"})
public final class Deci
extends Number
implements Comparable<Deci> {
    private final BigDecimal decimal;
    private Integer _hashCode;
    private final DeciContext context;
    private static final DeciContext defaultDeciContext;
    private static final Deci d0;
    private static final Deci d1;
    public static final Companion Companion;

    @NotNull
    public final Deci unaryMinus() {
        BigDecimal bigDecimal = this.decimal.negate();
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"decimal.negate()");
        return new Deci(bigDecimal, this.context);
    }

    @NotNull
    public final Deci plus(@NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        BigDecimal bigDecimal = this.decimal.add(other);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"decimal.add(other)");
        return new Deci(bigDecimal, this.context);
    }

    @NotNull
    public final Deci minus(@NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        BigDecimal bigDecimal = this.decimal.subtract(other);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"decimal.subtract(other)");
        return new Deci(bigDecimal, this.context);
    }

    @NotNull
    public final Deci times(@NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        BigDecimal bigDecimal = this.decimal.multiply(other);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"decimal.multiply(other)");
        return new Deci(bigDecimal, this.context);
    }

    @NotNull
    public final Deci div(@NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        BigDecimal bigDecimal = this.decimal.divide(other, this.calcDivScale$deci(other), this.context.getRoundingMode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"decimal.divide(other, ca\u2026r), context.roundingMode)");
        return new Deci(bigDecimal, this.context);
    }

    @NotNull
    public final Deci rem(@NotNull BigDecimal other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        BigDecimal bigDecimal = this.decimal.remainder(other);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"decimal.remainder(other)");
        return new Deci(bigDecimal, this.context);
    }

    @NotNull
    public final Deci plus(@NotNull Deci other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.plus(other.decimal);
    }

    @NotNull
    public final Deci minus(@NotNull Deci other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.minus(other.decimal);
    }

    @NotNull
    public final Deci times(@NotNull Deci other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.times(other.decimal);
    }

    @NotNull
    public final Deci div(@NotNull Deci other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.div(other.decimal);
    }

    @NotNull
    public final Deci rem(@NotNull Deci other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.rem(other.decimal);
    }

    @NotNull
    public final Deci plus(int other) {
        return this.plus(new BigDecimal(other));
    }

    @NotNull
    public final Deci minus(int other) {
        return this.minus(new BigDecimal(other));
    }

    @NotNull
    public final Deci times(int other) {
        return this.times(new BigDecimal(other));
    }

    @NotNull
    public final Deci div(int other) {
        return this.div(new BigDecimal(other));
    }

    @NotNull
    public final Deci rem(int other) {
        return this.rem(new BigDecimal(other));
    }

    @NotNull
    public final Deci plus(long other) {
        return this.plus(new BigDecimal(other));
    }

    @NotNull
    public final Deci minus(long other) {
        return this.minus(new BigDecimal(other));
    }

    @NotNull
    public final Deci times(long other) {
        return this.times(new BigDecimal(other));
    }

    @NotNull
    public final Deci div(long other) {
        return this.div(new BigDecimal(other));
    }

    @NotNull
    public final Deci rem(long other) {
        return this.rem(new BigDecimal(other));
    }

    public byte toByte() {
        return this.decimal.byteValue();
    }

    public char toChar() {
        return this.decimal.toChar();
    }

    public double toDouble() {
        return this.decimal.doubleValue();
    }

    public float toFloat() {
        return this.decimal.floatValue();
    }

    public int toInt() {
        return this.decimal.intValue();
    }

    public long toLong() {
        return this.decimal.longValue();
    }

    public short toShort() {
        return this.decimal.shortValue();
    }

    @NotNull
    public final BigDecimal toBigDecimal() {
        return this.decimal;
    }

    @NotNull
    public final Deci round(int scale) {
        BigDecimal bigDecimal = this.decimal.setScale(scale, this.context.getRoundingMode());
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"this.decimal.setScale(scale, context.roundingMode)");
        return new Deci(bigDecimal, null, 2, null);
    }

    @Override
    public int compareTo(@NotNull Deci other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.decimal.compareTo(other.decimal);
    }

    @NotNull
    public String toString() {
        if (this.decimal.scale() == 0) {
            String string = this.decimal.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"decimal.toString()");
            return string;
        }
        BigDecimal d = this.decimal.stripTrailingZeros();
        if (d.scale() < 0) {
            d = d.setScale(0);
        }
        String string = d.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"d.toString()");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.github.labai.deci.Deci");
        }
        Deci cfr_ignored_0 = (Deci)object2;
        return this.decimal.compareTo(((Deci)other).decimal) == 0;
    }

    public int hashCode() {
        if (this._hashCode == null) {
            this._hashCode = this.decimal.stripTrailingZeros().hashCode();
        }
        Integer n = this._hashCode;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        return n;
    }

    public final int calcDivScale$deci(@NotNull BigDecimal divisor) {
        int divisorIntDigits;
        Intrinsics.checkParameterIsNotNull((Object)divisor, (String)"divisor");
        int thisIntDigits = this.decimal.signum() == 0 ? 1 : this.decimal.precision() - this.decimal.scale();
        int n = divisorIntDigits = divisor.signum() == 0 ? 1 : divisor.precision() - divisor.scale();
        if (divisorIntDigits < 0) {
            int n2 = this.decimal.scale();
            int n3 = this.context.getScale();
            boolean bl = false;
            return Math.max(n2, n3);
        }
        int n4 = this.context.getScale();
        int n5 = this.context.getPrecision() + divisorIntDigits - thisIntDigits;
        boolean bl = false;
        return Math.max(n4, n5);
    }

    @JvmOverloads
    public Deci(@NotNull BigDecimal decimal, @NotNull DeciContext context) {
        BigDecimal bigDecimal;
        Intrinsics.checkParameterIsNotNull((Object)decimal, (String)"decimal");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        Deci deci = this;
        if (decimal.signum() == 0) {
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            bigDecimal = bigDecimal2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal2, (String)"BigDecimal.ZERO");
        } else if (decimal.scale() < 0) {
            BigDecimal bigDecimal3 = decimal.setScale(0, this.context.getRoundingMode());
            bigDecimal = bigDecimal3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal3, (String)"decimal.setScale(0, context.roundingMode)");
        } else if (decimal.scale() > this.context.getScale()) {
            int n;
            int n2 = 0;
            int n3 = decimal.scale() - decimal.precision();
            Deci deci2 = deci;
            int n4 = 0;
            int zeros = n = Math.max(n2, n3);
            n3 = this.context.getScale();
            n4 = Integer.min(zeros + this.context.getPrecision(), decimal.scale());
            boolean bl = false;
            n = Math.max(n3, n4);
            deci = deci2;
            int scale = n;
            BigDecimal bigDecimal4 = decimal.setScale(scale, this.context.getRoundingMode());
            bigDecimal = bigDecimal4;
            Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal4, (String)"decimal.setScale(scale, context.roundingMode)");
        } else {
            bigDecimal = decimal;
        }
        deci.decimal = bigDecimal;
    }

    public /* synthetic */ Deci(BigDecimal bigDecimal, DeciContext deciContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            deciContext = defaultDeciContext;
        }
        this(bigDecimal, deciContext);
    }

    @JvmOverloads
    public Deci(@NotNull BigDecimal decimal) {
        this(decimal, null, 2, null);
    }

    public Deci(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        this(new BigDecimal(str), null, 2, null);
    }

    public Deci(int n) {
        this(new BigDecimal(n), null, 2, null);
    }

    public Deci(long l) {
        this(new BigDecimal(l), null, 2, null);
    }

    static {
        Companion = new Companion(null);
        defaultDeciContext = new DeciContext(20, RoundingMode.HALF_UP, 20);
        d0 = new Deci(0);
        d1 = new Deci(1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/github/labai/deci/Deci$DeciContext;", "", "scale", "", "roundingMode", "Ljava/math/RoundingMode;", "(ILjava/math/RoundingMode;)V", "precision", "(ILjava/math/RoundingMode;I)V", "getPrecision", "()I", "getRoundingMode", "()Ljava/math/RoundingMode;", "getScale", "deci"})
    public static final class DeciContext {
        private final int scale;
        @NotNull
        private final RoundingMode roundingMode;
        private final int precision;

        public final int getScale() {
            return this.scale;
        }

        @NotNull
        public final RoundingMode getRoundingMode() {
            return this.roundingMode;
        }

        public final int getPrecision() {
            return this.precision;
        }

        public DeciContext(int scale, @NotNull RoundingMode roundingMode, int precision) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)roundingMode), (String)"roundingMode");
            this.scale = scale;
            this.roundingMode = roundingMode;
            this.precision = precision;
            boolean bl = this.scale >= 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "scale must be >= 0 (is " + this.scale + ')';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = this.scale <= 2000;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "scale must be <= 2000 (is " + this.scale + ')';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = this.precision >= 1;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl6 = false;
                String string = "precision must be >= 1 (is " + this.precision + ')';
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = this.precision <= 2000;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl7 = false;
                String string = "precision must be <= 2000 (is " + this.precision + ')';
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        public DeciContext(int scale, @NotNull RoundingMode roundingMode) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)roundingMode), (String)"roundingMode");
            this(scale, roundingMode, scale);
        }

        public /* synthetic */ DeciContext(int n, RoundingMode roundingMode, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                roundingMode = RoundingMode.HALF_UP;
            }
            this(n, roundingMode);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/labai/deci/Deci$Companion;", "", "()V", "d0", "Lcom/github/labai/deci/Deci;", "d1", "defaultDeciContext", "Lcom/github/labai/deci/Deci$DeciContext;", "valueOf", "int", "", "long", "", "deci"})
    public static final class Companion {
        @NotNull
        public final Deci valueOf(int n) {
            Deci deci;
            switch (n) {
                case 0: {
                    deci = d0;
                    break;
                }
                case 1: {
                    deci = d1;
                    break;
                }
                default: {
                    deci = new Deci(n);
                }
            }
            return deci;
        }

        @NotNull
        public final Deci valueOf(long l) {
            long l2 = l;
            return l2 == 0L ? d0 : (l2 == 1L ? d1 : new Deci(l));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

