/*
 * Decompiled with CFR 0.152.
 */
package com.github.lalyos.jfiglet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

enum SmushingRule implements Comparable<SmushingRule>
{
    HORIZONTAL_EQUAL_CHARACTER_SMUSHING(Type.HORIZONTAL, Layout.CONTROLLED_SMUSHING, 1){

        @Override
        Character smush(char char1, char char2, char hardblank) {
            return char1 != hardblank && char1 == char2 ? Character.valueOf(char1) : null;
        }
    }
    ,
    HORIZONTAL_UNDERSCORE_SMUSHING(Type.HORIZONTAL, Layout.CONTROLLED_SMUSHING, 2){

        @Override
        Character smush(char char1, char char2, char hardblank) {
            String chars = "|/\\[]{}()<>";
            if (char1 == '_' && "|/\\[]{}()<>".indexOf(char2) != -1) {
                return Character.valueOf(char2);
            }
            if (char2 == '_' && "|/\\[]{}()<>".indexOf(char1) != -1) {
                return Character.valueOf(char1);
            }
            return null;
        }
    }
    ,
    HORIZONTAL_HIERARCHY_SMUSHING(Type.HORIZONTAL, Layout.CONTROLLED_SMUSHING, 4){

        @Override
        Character smush(char char1, char char2, char hardblank) {
            String classes = "| /\\ [] {} () <>";
            int pos1 = classes.indexOf(char1);
            int pos2 = classes.indexOf(char2);
            if (pos1 != -1 && pos2 != -1 && pos1 != pos2 && Math.abs(pos1 - pos2) != 1) {
                return Character.valueOf(classes.substring(Math.max(pos1, pos2), Math.max(pos1, pos2) + 1).charAt(0));
            }
            return null;
        }
    }
    ,
    HORIZONTAL_OPPOSITE_PAIR_SMUSHING(Type.HORIZONTAL, Layout.CONTROLLED_SMUSHING, 8){

        @Override
        Character smush(char char1, char char2, char hardblank) {
            String opposingBrackets = "[] {} ()";
            int pos1 = opposingBrackets.indexOf(char1);
            int pos2 = opposingBrackets.indexOf(char2);
            if (pos1 != -1 && pos2 != -1 && pos1 != pos2 && Math.abs(pos1 - pos2) == 1) {
                return Character.valueOf('|');
            }
            return null;
        }
    }
    ,
    HORIZONTAL_BIG_X_SMUSHING(Type.HORIZONTAL, Layout.CONTROLLED_SMUSHING, 16){

        @Override
        Character smush(char char1, char char2, char hardblank) {
            if (char1 == '/' && char2 == "\\".charAt(0)) {
                return Character.valueOf('|');
            }
            if (char1 == "\\".charAt(0) && char2 == '/') {
                return Character.valueOf('Y');
            }
            if (char1 == '>' && char2 == '<') {
                return Character.valueOf('X');
            }
            return null;
        }
    }
    ,
    HORIZONTAL_HARDBLANK_SMUSHING(Type.HORIZONTAL, Layout.CONTROLLED_SMUSHING, 32){

        @Override
        Character smush(char char1, char char2, char hardblank) {
            return char1 == hardblank && char2 == hardblank ? Character.valueOf(hardblank) : null;
        }
    }
    ,
    HORIZONTAL_FITTING(Type.HORIZONTAL, Layout.FITTING, 64){

        @Override
        Character smush(char char1, char char2, char hardblank) {
            return char1 == ' ' && char2 == ' ' ? Character.valueOf(' ') : null;
        }
    }
    ,
    HORIZONTAL_SMUSHING(Type.HORIZONTAL, Layout.SMUSHING, 128){

        @Override
        Character smush(char char1, char char2, char hardblank) {
            return char1 != hardblank && char2 != hardblank ? Character.valueOf(char2) : null;
        }
    }
    ,
    VERTICAL_EQUAL_CHARACTER_SMUSHING(Type.VERTICAL, Layout.CONTROLLED_SMUSHING, 256),
    VERTICAL_UNDERSCORE_SMUSHING(Type.VERTICAL, Layout.CONTROLLED_SMUSHING, 512),
    VERTICAL_HIERARCHY_SMUSHING(Type.VERTICAL, Layout.CONTROLLED_SMUSHING, 1024),
    VERTICAL_HORIZONTAL_LINE_SMUSHING(Type.VERTICAL, Layout.CONTROLLED_SMUSHING, 2048),
    VERTICAL_VERTICAL_LINE_SMUSHING(Type.VERTICAL, Layout.CONTROLLED_SMUSHING, 4096),
    VERTICAL_FITTING(Type.VERTICAL, Layout.FITTING, 8192),
    VERTICAL_SMUSHING(Type.VERTICAL, Layout.SMUSHING, 16384);

    private final Type type;
    private final Layout layout;
    private final int codeValue;
    private static final Map<Integer, SmushingRule> codeValueToRule;

    private SmushingRule(Type type, Layout layout, int codeValue) {
        this.type = type;
        this.layout = layout;
        this.codeValue = codeValue;
    }

    Character smush(char char1, char char2, char hardblank) {
        return null;
    }

    boolean smushes(char char1, char char2, char hardblank) {
        return this.smush(char1, char2, hardblank) != null;
    }

    int getCodeValue() {
        return this.codeValue;
    }

    Type getType() {
        return this.type;
    }

    Layout getLayout() {
        return this.layout;
    }

    static SmushingRule getByCodeValue(int codeValue) {
        return codeValueToRule.get(codeValue);
    }

    static List<Integer> getAvailableCodeValues() {
        ArrayList<Integer> list = new ArrayList<Integer>(codeValueToRule.keySet());
        Collections.sort(list);
        Collections.reverse(list);
        return Collections.unmodifiableList(list);
    }

    static {
        HashMap<Integer, SmushingRule> results = new HashMap<Integer, SmushingRule>();
        for (SmushingRule rule : SmushingRule.values()) {
            results.put(rule.getCodeValue(), rule);
        }
        codeValueToRule = Collections.unmodifiableMap(results);
    }

    static enum Layout {
        FULL_WIDTH,
        FITTING,
        SMUSHING,
        CONTROLLED_SMUSHING;

    }

    static enum Type {
        HORIZONTAL,
        VERTICAL;

    }
}

