/*
 * Decompiled with CFR 0.152.
 */
package com.github.lalyos.jfiglet;

import com.github.lalyos.jfiglet.SmushingRule;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class SmushingRulesToApply {
    private final SmushingRule.Layout horizontalLayout;
    private final SmushingRule.Layout verticalLayout;
    private final List<SmushingRule> horizontalSmushingRules;
    private final List<SmushingRule> verticalSmushingRules;

    SmushingRulesToApply(SmushingRule.Layout horizontalLayout, SmushingRule.Layout verticalLayout, List<SmushingRule> horizontalSmushingRules, List<SmushingRule> verticalSmushingRules) {
        this.horizontalLayout = horizontalLayout;
        this.verticalLayout = verticalLayout;
        Collections.sort(horizontalSmushingRules, new SmushingRuleCodeValueComparator());
        this.horizontalSmushingRules = Collections.unmodifiableList(horizontalSmushingRules);
        Collections.sort(verticalSmushingRules, new SmushingRuleCodeValueComparator());
        this.verticalSmushingRules = Collections.unmodifiableList(verticalSmushingRules);
    }

    SmushingRule.Layout getHorizontalLayout() {
        return this.horizontalLayout;
    }

    SmushingRule.Layout getVerticalLayout() {
        return this.verticalLayout;
    }

    List<SmushingRule> getHorizontalSmushingRules() {
        return this.horizontalSmushingRules;
    }

    List<SmushingRule> getVerticalSmushingRules() {
        return this.verticalSmushingRules;
    }

    boolean smushesHorizontal(char char1, char char2, char hardblank) {
        for (SmushingRule smushingRule : this.getHorizontalSmushingRules()) {
            if (!smushingRule.smushes(char1, char2, hardblank)) continue;
            return true;
        }
        return false;
    }

    Character smushHorizontal(char char1, char char2, char hardblank) {
        if (char1 == ' ') {
            return Character.valueOf(char2);
        }
        if (char2 == ' ') {
            return Character.valueOf(char1);
        }
        if (this.getHorizontalLayout() == SmushingRule.Layout.SMUSHING) {
            return SmushingRule.HORIZONTAL_SMUSHING.smush(char1, char2, hardblank);
        }
        for (SmushingRule smushingRule : this.getHorizontalSmushingRules()) {
            if (!smushingRule.smushes(char1, char2, hardblank)) continue;
            return smushingRule.smush(char1, char2, hardblank);
        }
        throw new ImproperUseException("Method should only be called when smush is possible");
    }

    class ImproperUseException
    extends RuntimeException {
        ImproperUseException(String message) {
            super(message);
        }
    }

    private class SmushingRuleCodeValueComparator
    implements Comparator<SmushingRule> {
        private SmushingRuleCodeValueComparator() {
        }

        @Override
        public int compare(SmushingRule o1, SmushingRule o2) {
            return Integer.valueOf(o1.getCodeValue()).compareTo(o2.getCodeValue());
        }
    }
}

