/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.parser;

import com.lowagie.text.pdf.CMapAwareDocumentFont;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.parser.FinalText;
import com.lowagie.text.pdf.parser.GraphicsState;
import com.lowagie.text.pdf.parser.Matrix;
import com.lowagie.text.pdf.parser.ParsedTextImpl;
import com.lowagie.text.pdf.parser.TextAssembler;
import com.lowagie.text.pdf.parser.Vector;
import com.lowagie.text.pdf.parser.Word;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ParsedText
extends ParsedTextImpl {
    protected final Matrix textToUserSpaceTransformMatrix;
    protected final GraphicsState gs;
    protected PdfString pdfText = null;

    protected String decode(String in) {
        byte[] bytes;
        if ("Identity-H".equals(this.gs.font.getEncoding())) {
            try {
                bytes = in.getBytes("UTF-16");
            }
            catch (UnsupportedEncodingException e) {
                bytes = in.getBytes();
            }
        }
        bytes = in.getBytes();
        return this.gs.font.decode(bytes, 0, bytes.length);
    }

    protected String decode(PdfString in) {
        byte[] bytes = in.getOriginalBytes();
        return this.gs.font.decode(bytes, 0, bytes.length);
    }

    @Deprecated
    ParsedText(String text, GraphicsState gs, Matrix textMatrix) {
        this(text, new GraphicsState(gs), textMatrix.multiply(gs.ctm), ParsedText.getUnscaledFontSpaceWidth(gs));
    }

    ParsedText(PdfString text, GraphicsState gs, Matrix textMatrix) {
        this(text, new GraphicsState(gs), textMatrix.multiply(gs.ctm), ParsedText.getUnscaledFontSpaceWidth(gs));
    }

    private ParsedText(PdfString text, GraphicsState gs, Matrix textMatrix, float unscaledWidth) {
        super(null, ParsedText.pointToUserSpace(0.0f, 0.0f, textMatrix), ParsedText.pointToUserSpace(ParsedText.getStringWidth(text.toString(), gs), 0.0f, textMatrix), ParsedText.pointToUserSpace(1.0f, 0.0f, textMatrix), ParsedText.convertHeightToUser(gs.font.getFontDescriptor(1, gs.fontSize), textMatrix), ParsedText.convertHeightToUser(gs.font.getFontDescriptor(3, gs.fontSize), textMatrix), ParsedText.convertWidthToUser(unscaledWidth, textMatrix));
        if ("Identity-H".equals(gs.font.getEncoding())) {
            try {
                this.pdfText = new PdfString(new String(text.getBytes(), "UTF-16"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("This error can't actually happen as java always has Unicode", e);
            }
        } else {
            this.pdfText = text;
        }
        this.textToUserSpaceTransformMatrix = textMatrix;
        this.gs = gs;
    }

    @Deprecated
    private ParsedText(String text, GraphicsState gs, Matrix textMatrix, float unscaledWidth) {
        super(text, ParsedText.pointToUserSpace(0.0f, 0.0f, textMatrix), ParsedText.pointToUserSpace(ParsedText.getStringWidth(text, gs), 0.0f, textMatrix), ParsedText.pointToUserSpace(1.0f, 0.0f, textMatrix), ParsedText.convertHeightToUser(gs.font.getFontDescriptor(1, gs.fontSize), textMatrix), ParsedText.convertHeightToUser(gs.font.getFontDescriptor(3, gs.fontSize), textMatrix), ParsedText.convertWidthToUser(unscaledWidth, textMatrix));
        this.textToUserSpaceTransformMatrix = textMatrix;
        this.gs = gs;
    }

    private static Vector pointToUserSpace(float xoffset, float yoffset, Matrix textToUserSpaceTransformMatrix) {
        Vector result = new Vector(xoffset, yoffset, 1.0f).cross(textToUserSpaceTransformMatrix);
        return result;
    }

    private static float getUnscaledFontSpaceWidth(GraphicsState gs) {
        char charToUse = ' ';
        if (gs.font.getWidth(charToUse) == 0) {
            charToUse = '\u00a0';
        }
        return ParsedText.getStringWidth(String.valueOf(charToUse), gs);
    }

    private static float getStringWidth(String string, GraphicsState gs) {
        CMapAwareDocumentFont font = gs.font;
        char[] chars = string.toCharArray();
        float totalWidth = 0.0f;
        for (char c : chars) {
            float w = (float)((DocumentFont)font).getWidth(c) / 1000.0f;
            float wordSpacing = Character.isSpaceChar(c) ? gs.wordSpacing : 0.0f;
            totalWidth += (w * gs.fontSize + gs.characterSpacing + wordSpacing) * gs.horizontalScaling;
        }
        return totalWidth;
    }

    public List<Word> getAsPartialWords() {
        ArrayList<Word> result = new ArrayList<Word>();
        CMapAwareDocumentFont font = this.gs.font;
        char[] chars = this.pdfText.getOriginalChars();
        boolean[] hasSpace = new boolean[chars.length];
        float totalWidth = 0.0f;
        StringBuffer wordAccum = new StringBuffer(3);
        float wordStartOffset = 0.0f;
        boolean wordsAreComplete = this.preprocessString(chars, hasSpace);
        boolean currentBreakBefore = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            float w = (float)font.getWidth(c) / 1000.0f;
            if (hasSpace[i]) {
                if (wordAccum.length() > 0) {
                    result.add(this.createWord(wordAccum, wordStartOffset, totalWidth, this.getBaseline(), wordsAreComplete, currentBreakBefore));
                    wordAccum = new StringBuffer();
                }
                if (!Character.isWhitespace(c)) {
                    wordStartOffset = totalWidth;
                }
                totalWidth += (w * this.gs.fontSize + this.gs.characterSpacing + this.gs.wordSpacing) * this.gs.horizontalScaling;
                if (Character.isWhitespace(c)) {
                    wordStartOffset = totalWidth;
                }
                wordAccum.append(c);
                currentBreakBefore = true;
                continue;
            }
            wordAccum.append(c);
            totalWidth += (w * this.gs.fontSize + this.gs.characterSpacing) * this.gs.horizontalScaling;
        }
        if (wordAccum.length() > 0) {
            result.add(this.createWord(wordAccum, wordStartOffset, totalWidth, this.getBaseline(), wordsAreComplete, currentBreakBefore));
        }
        return result;
    }

    private boolean preprocessString(char[] chars, boolean[] hasSpace) {
        boolean wordsAreComplete = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            hasSpace[i] = false;
            String charValue = this.gs.font.decode(c);
            if (charValue == null) continue;
            for (char cFinal : charValue.toCharArray()) {
                if (!Character.isSpaceChar(cFinal)) continue;
                wordsAreComplete = true;
                hasSpace[i] = true;
            }
        }
        return wordsAreComplete;
    }

    private Word createWord(StringBuffer wordAccum, float wordStartOffset, float wordEndOffset, Vector baseline, boolean wordsAreComplete, boolean currentBreakBefore) {
        Word newWord = new Word(this.gs.font.decode(wordAccum.toString()), this.getAscent(), this.getDescent(), ParsedText.pointToUserSpace(wordStartOffset, 0.0f, this.textToUserSpaceTransformMatrix), ParsedText.pointToUserSpace(wordEndOffset, 0.0f, this.textToUserSpaceTransformMatrix), baseline, this.getSingleSpaceWidth(), wordsAreComplete, currentBreakBefore);
        return newWord;
    }

    public float getUnscaledTextWidth(GraphicsState gs) {
        return ParsedText.getStringWidth(this.getFontCodes(), gs);
    }

    private static float convertWidthToUser(float width, Matrix textToUserSpaceTransformMatrix) {
        Vector startPos = ParsedText.pointToUserSpace(0.0f, 0.0f, textToUserSpaceTransformMatrix);
        Vector endPos = ParsedText.pointToUserSpace(width, 0.0f, textToUserSpaceTransformMatrix);
        return ParsedText.distance(startPos, endPos);
    }

    private static float distance(Vector startPos, Vector endPos) {
        return endPos.subtract(startPos).length();
    }

    private static float convertHeightToUser(float height, Matrix textToUserSpaceTransformMatrix) {
        Vector startPos = ParsedText.pointToUserSpace(0.0f, 0.0f, textToUserSpaceTransformMatrix);
        Vector endPos = ParsedText.pointToUserSpace(0.0f, height, textToUserSpaceTransformMatrix);
        return ParsedText.distance(endPos, startPos);
    }

    @Override
    public void accumulate(TextAssembler p, String contextName) {
        p.process(this, contextName);
    }

    @Override
    public void assemble(TextAssembler p) {
        p.renderText(this);
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (text == null && this.pdfText != null) {
            return this.decode(this.pdfText);
        }
        return text;
    }

    public String getFontCodes() {
        if (this.pdfText != null) {
            return this.pdfText.toString();
        }
        return null;
    }

    @Override
    public FinalText getFinalText(PdfReader reader, int page, TextAssembler assembler, boolean useMarkup) {
        throw new RuntimeException("Final text should never be called on unprocessed word fragment.");
    }

    public String toString() {
        return "[ParsedText: [" + this.getText() + "] " + this.getStartPoint() + ", " + this.getEndPoint() + "] lead]";
    }

    @Override
    public boolean shouldNotSplit() {
        return false;
    }

    @Override
    public boolean breakBefore() {
        return false;
    }
}

