/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.batch;

import com.github.loki4j.client.util.StringUtils;
import java.util.Arrays;

public class LogRecordStream {
    public final String[] labels;
    public final int hash;
    public final int utf8SizeBytes;

    private LogRecordStream(String[] labels) {
        this.labels = labels;
        this.hash = Arrays.hashCode(labels);
        int sizeBytes = 0;
        for (int i = 0; i < labels.length; ++i) {
            sizeBytes += StringUtils.utf8Length(labels[i]);
        }
        this.utf8SizeBytes = sizeBytes;
    }

    public static LogRecordStream create(String ... labels) {
        return new LogRecordStream(labels);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hash ^ this.hash >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogRecordStream other = (LogRecordStream)obj;
        return Arrays.equals(this.labels, other.labels);
    }

    public String toString() {
        return "Stream [hash=" + this.hash + ", labels=" + Arrays.toString(this.labels) + "]";
    }
}

