/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiPatternExtractor<E> {
    private static final int INITIAL_STRING_BUILDER_SIZE = 64;
    private final List<Converter<E>> converters = new ArrayList<Converter<E>>();

    public MultiPatternExtractor(List<String> patterns, Context context) throws ScanException {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(context);
        Map effectiveConverterMap = patternLayout.getEffectiveConverterMap();
        for (String pattern : patterns) {
            try {
                Parser p = new Parser(pattern);
                if (context != null) {
                    p.setContext(context);
                }
                Node t = p.parse();
                Converter converter = p.compile(t, effectiveConverterMap);
                ConverterUtil.setContextForConverters((Context)context, (Converter)converter);
                ConverterUtil.startConverters((Converter)converter);
                this.converters.add(converter);
            }
            catch (ScanException sce) {
                throw new ScanException("Unable to parse pattern: \"" + pattern + "\"", (Throwable)sce);
            }
        }
    }

    public String[] extract(E event) {
        StringBuilder strBuilder = new StringBuilder(64);
        String[] result = new String[this.converters.size()];
        for (int i = 0; i < this.converters.size(); ++i) {
            for (Converter c = this.converters.get(i); c != null; c = c.getNext()) {
                c.write(strBuilder, event);
            }
            result[i] = strBuilder.toString();
            strBuilder.setLength(0);
        }
        return result;
    }
}

