/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.slf4j.marker;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Marker;

public abstract class AbstractKeyValueMarker
implements Marker {
    private final Supplier<Map<String, String>> kvSupplier;
    private final AtomicReference<Map<String, String>> kvValue = new AtomicReference<Object>(null);

    public AbstractKeyValueMarker(Supplier<Map<String, String>> kvSupplier) {
        if (kvSupplier == null) {
            throw new IllegalArgumentException("Labels can not be null");
        }
        this.kvSupplier = kvSupplier;
    }

    public Map<String, String> getKeyValuePairs() {
        this.kvValue.compareAndSet(null, this.kvSupplier.get());
        return this.kvValue.get();
    }

    public void add(Marker reference) {
        throw new UnsupportedOperationException("LabelMarker does not support adding references");
    }

    public boolean remove(Marker reference) {
        return false;
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean hasReferences() {
        return false;
    }

    public Iterator<Marker> iterator() {
        return Collections.emptyIterator();
    }

    public boolean contains(Marker other) {
        return false;
    }

    public boolean contains(String name) {
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

