/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.batch;

import com.github.loki4j.client.util.StringUtils;
import java.util.Map;

public class LogRecord {
    public final long timestampMs;
    public final int nanosInMs;
    public final Map<String, String> stream;
    public final int streamUtf8SizeBytes;
    public final String message;
    public final int messageUtf8SizeBytes;
    public final Map<String, String> metadata;
    public final int metadataUtf8SizeBytes;

    private LogRecord(long timestampMs, int nanosInMs, Map<String, String> stream, String message, Map<String, String> metadata) {
        this.timestampMs = timestampMs;
        this.nanosInMs = nanosInMs;
        this.message = message;
        this.messageUtf8SizeBytes = StringUtils.utf8Length(message);
        this.stream = stream;
        this.streamUtf8SizeBytes = LogRecord.kvpUtf8SizeBytes(stream);
        this.metadata = metadata;
        this.metadataUtf8SizeBytes = LogRecord.kvpUtf8SizeBytes(metadata);
    }

    public static LogRecord create(long timestampMs, int nanosInMs, Map<String, String> stream, String message, Map<String, String> metadata) {
        return new LogRecord(timestampMs, nanosInMs, stream, message, metadata);
    }

    public String toString() {
        return "LogRecord [ts=" + this.timestampMs + ", nanos=" + this.nanosInMs + ", stream=" + String.valueOf(this.stream) + ", message=" + this.message + ", metadata=" + String.valueOf(this.metadata) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.timestampMs ^ this.timestampMs >>> 32);
        result = 31 * result + this.nanosInMs;
        result = 31 * result + (this.stream == null ? 0 : this.stream.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogRecord other = (LogRecord)obj;
        if (this.timestampMs != other.timestampMs) {
            return false;
        }
        if (this.nanosInMs != other.nanosInMs) {
            return false;
        }
        if (this.stream == null ? other.stream != null : !this.stream.equals(other.stream)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata));
    }

    private static int kvpUtf8SizeBytes(Map<String, String> map) {
        int utf8SizeBytes = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            utf8SizeBytes += StringUtils.utf8Length(entry.getKey());
            utf8SizeBytes += StringUtils.utf8Length(entry.getValue());
        }
        return utf8SizeBytes;
    }
}

