/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.writer;

import com.github.loki4j.client.batch.LogRecord;
import com.github.loki4j.client.batch.LogRecordBatch;
import com.github.loki4j.client.writer.Writer;
import com.github.loki4j.pkg.dslplatform.json.RawJsonWriter;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;

public final class JsonWriter
implements Writer {
    private final RawJsonWriter raw;

    public JsonWriter(int capacity) {
        this.raw = new RawJsonWriter(capacity);
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public void serializeBatch(LogRecordBatch batch) {
        Map<String, String> currentStream = batch.get((int)0).stream;
        this.beginStreams(batch.get(0), currentStream);
        for (int i = 1; i < batch.size(); ++i) {
            if (!batch.get((int)i).stream.equals(currentStream)) {
                currentStream = batch.get((int)i).stream;
                this.nextStream(batch.get(i), currentStream);
                continue;
            }
            this.nextRecord(batch.get(i));
        }
        this.endStreams();
    }

    @Override
    public int size() {
        return this.raw.size();
    }

    @Override
    public void toByteBuffer(ByteBuffer buffer) {
        this.raw.toByteBuffer(buffer);
    }

    @Override
    public byte[] toByteArray() {
        return this.raw.toByteArray();
    }

    @Override
    public final void reset() {
        this.raw.reset();
    }

    private void beginStreams(LogRecord firstRecord, Map<String, String> firstLabels) {
        this.raw.writeByte((byte)123);
        this.raw.writeQuotedAscii("streams");
        this.raw.writeByte((byte)58);
        this.raw.writeByte((byte)91);
        this.stream(firstRecord, firstLabels);
    }

    private void nextStream(LogRecord firstRecord, Map<String, String> labels) {
        this.raw.writeByte((byte)93);
        this.raw.writeByte((byte)125);
        this.raw.writeByte((byte)44);
        this.stream(firstRecord, labels);
    }

    private void stream(LogRecord firstRecord, Map<String, String> labels) {
        this.raw.writeByte((byte)123);
        this.raw.writeQuotedAscii("stream");
        this.raw.writeByte((byte)58);
        this.keyValuePairs(labels);
        this.raw.writeByte((byte)44);
        this.raw.writeQuotedAscii("values");
        this.raw.writeByte((byte)58);
        this.raw.writeByte((byte)91);
        this.record(firstRecord);
    }

    private void nextRecord(LogRecord record) {
        this.raw.writeByte((byte)44);
        this.record(record);
    }

    private void record(LogRecord record) {
        this.raw.writeByte((byte)91);
        this.raw.writeQuotedAscii(record.timestampMs + this.nanosToStr(record.nanosInMs));
        this.raw.writeByte((byte)44);
        this.raw.writeString(record.message);
        if (!record.metadata.isEmpty()) {
            this.raw.writeByte((byte)44);
            this.keyValuePairs(record.metadata);
        }
        this.raw.writeByte((byte)93);
    }

    private void keyValuePairs(Map<String, String> kvp) {
        this.raw.writeByte((byte)123);
        Iterator<Map.Entry<String, String>> entries = kvp.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            this.raw.writeString(entry.getKey());
            this.raw.writeByte((byte)58);
            this.raw.writeString(entry.getValue());
            if (!entries.hasNext()) continue;
            this.raw.writeByte((byte)44);
        }
        this.raw.writeByte((byte)125);
    }

    private String nanosToStr(int nanos) {
        char[] c = new char[6];
        int rem = nanos;
        for (int i = c.length - 1; i >= 0; --i) {
            c[i] = (char)(48 + rem % 10);
            rem /= 10;
        }
        return new String(c);
    }

    private void endStreams() {
        this.raw.writeByte((byte)93);
        this.raw.writeByte((byte)125);
        this.raw.writeByte((byte)93);
        this.raw.writeByte((byte)125);
    }
}

