/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.writer;

import com.github.loki4j.client.batch.LogRecord;
import com.github.loki4j.client.batch.LogRecordBatch;
import com.github.loki4j.client.util.ByteBufferFactory;
import com.github.loki4j.client.writer.Writer;
import com.github.loki4j.pkg.google.protobuf.Timestamp;
import com.github.loki4j.pkg.loki.protobuf.Push;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.xerial.snappy.Snappy;

public final class ProtobufWriter
implements Writer {
    private final ByteBuffer uncompressed;
    private final ByteBuffer compressed;
    private Push.PushRequest.Builder request;
    private Push.StreamAdapter.Builder stream;
    private int size = 0;

    public ProtobufWriter(int capacity, ByteBufferFactory bbFactory) {
        int capacityX1_5 = capacity + capacity / 2;
        this.uncompressed = bbFactory.allocate(capacityX1_5);
        this.compressed = bbFactory.allocate(capacityX1_5);
        this.request = Push.PushRequest.newBuilder();
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public void serializeBatch(LogRecordBatch batch) {
        Map<String, String> currentStream = batch.get((int)0).stream;
        this.nextStream(currentStream);
        for (int i = 0; i < batch.size(); ++i) {
            if (!batch.get((int)i).stream.equals(currentStream)) {
                currentStream = batch.get((int)i).stream;
                this.nextStream(currentStream);
            }
            this.nextEntry(batch.get(i));
        }
        try {
            this.endStreams();
        }
        catch (IOException e) {
            throw new RuntimeException("Protobuf encoding error", e);
        }
    }

    private void nextStream(Map<String, String> labelSet) {
        this.stream = this.request.addStreamsBuilder().setLabels(ProtobufWriter.label(labelSet));
    }

    static String label(Map<String, String> labels) {
        StringBuilder s = new StringBuilder();
        s.append('{');
        Iterator<Map.Entry<String, String>> entries = labels.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            s.append(entry.getKey());
            s.append('=');
            s.append('\"');
            s.append(entry.getValue().replace("\"", "\\\""));
            s.append('\"');
            if (!entries.hasNext()) continue;
            s.append(',');
        }
        s.append('}');
        return s.toString();
    }

    private void nextEntry(LogRecord record) {
        Push.EntryAdapter.Builder entry = Push.EntryAdapter.newBuilder().setTimestamp(Timestamp.newBuilder().setSeconds(record.timestampMs / 1000L).setNanos((int)(record.timestampMs % 1000L) * 1000000 + record.nanosInMs)).setLine(record.message);
        for (Map.Entry<String, String> kvp : record.metadata.entrySet()) {
            entry.addStructuredMetadata(Push.LabelPairAdapter.newBuilder().setName(kvp.getKey()).setValue(kvp.getValue()));
        }
        this.stream.addEntries(entry);
    }

    private void endStreams() throws IOException {
        CodedOutputStream writer = CodedOutputStream.newInstance((ByteBuffer)this.uncompressed);
        this.request.build().writeTo(writer);
        writer.flush();
        this.uncompressed.flip();
        if (this.uncompressed.hasArray()) {
            this.size = Snappy.compress((byte[])this.uncompressed.array(), (int)0, (int)this.uncompressed.limit(), (byte[])this.compressed.array(), (int)0);
            this.compressed.limit(this.size());
        } else {
            this.size = Snappy.compress((ByteBuffer)this.uncompressed, (ByteBuffer)this.compressed);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void toByteBuffer(ByteBuffer buffer) {
        buffer.put(this.compressed);
        buffer.flip();
        this.reset();
    }

    @Override
    public final byte[] toByteArray() {
        byte[] result = new byte[this.compressed.remaining()];
        this.compressed.get(result);
        this.reset();
        return result;
    }

    @Override
    public final void reset() {
        this.request = Push.PushRequest.newBuilder();
        this.stream = null;
        this.size = 0;
        this.uncompressed.clear();
        this.compressed.clear();
    }
}

